#include <iostream.h>
#include <fstream.h>

#include "MachineGroup.h"
#include "Smachine.h"
#include "MachEvent.h"
#include "State.h"
#include "Transition.h"

main()
{
	MachineGroup mg2 ;
	Smachine *sm1 = mg2.add_machine("sm1") ;
	Smachine *sm2 = mg2.add_machine("sm2") ;

	MachEvent *e1_sm1 = sm1->add_event("event 1") ;
	MachEvent *e2_sm1 = sm1->add_event("event 2") ;

	e1_sm1->add_parameter("char *", "foo") ;
	e1_sm1->add_parameter("char *", "bar") ;

	State *s1_sm1 = sm1->add_state() ;
	State *s2_sm1 = sm1->add_state() ;

	s1_sm1->add_parameter("int", "mumble") ;
	s1_sm1->add_parameter("int *", "m2") ;

	LoopTransition *lt1 = s1_sm1->add_loop_transition(e1_sm1) ;
	lt1->attach_angle(1.5) ;

	SegmentTransition *st1 = s1_sm1->add_segment_transition(e2_sm1, s2_sm1) ;
	SegmentTransition::TransitionVertices& vert = st1->vertices() ;
	vert.push_back(Point(0.5, 0.5)) ;
	vert.push_back(Point(0.85, 0.85)) ;

	cout << mg2.file_map() ;
}
