
void MachineGroup::
test()
{
	modified(false) ;
	const char *au = "author" ;
	author(au) ;
	const string& tau = author() ;
	if (tau.compare(au) != 0)
	{
		cerr << "Failed to set author field: got " << tau
			<< ", expected " << au << endl ;
	}
	test_modified(true) ;

	modified(false) ;
	const char *rv = "revision" ;
	revision(rv) ;
	const string& trv = revision() ;
	if (trv.compare(rv) != 0)
	{
		cerr << "Failed to set revision field: got " << trv
			<< ", expected " << rv << endl ;
	}
	test_modified(true) ;

	Smachine *m1 = add_machine("m1") ;
	if (m1 == NULL)
	{
		cerr << "Cannot add machine \"m1\"" << endl ;
	}
	test_modified(true) ;
	Smachine *m2 = add_machine("m2") ;
	if (m2 == NULL)
	{
		cerr << "Cannot add machine \"m2\"" << endl ;
	}
	test_modified(true) ;
	Smachine *found = find_machine("m1") ;
	if (!found)
	{
		cerr << "Cannot find machine \"m1\"" << endl ;
	}
	found = find_machine("m2") ;
	if (!found)
	{
		cerr << "Cannot find machine \"m2\"" << endl ;
	}

	modified(false) ;
	remove_machine(m1) ;
	found = find_machine("m1") ;
	if (found)
	{
		cerr << "Found machine \"m1\" after it was removed" << endl ;
	}
	test_modified(true) ;

	remove_machine(m2) ;
	found = find_machine("m2") ;
	if (found)
	{
		cerr << "Found machine \"m2\" after it was removed" << endl ;
	}
	test_modified(true) ;

	SmachineList& mlist = machine_list() ;
	size_t sz = mlist.size() ;
	if (sz != 0)
	{
		cerr << "Unexpected number of machines in list: expected 0, got "
			<< sz << endl ;
	}
}
void MachineGroup::
test_modified(
	bool expected)
{
	bool got = modified() ;
	if (got != expected)
	{
		cerr << "Incorrect modification indicator, expected \"" << expected
			<< "\", got " << "\"" << got << "\"" << endl ;
	}
}
