/*
 *++
MODULE:

$RCSfile: GraphicBuilder.h,v $
$Revision: 1.3 $
$Date: 1997/02/08 04:37:41 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: GraphicBuilder.h,v $
Revision 1.3  1997/02/08 04:37:41  andrewm
Checkpoint before returning to work on the GUI portion.

Revision 1.2  1996/09/22 01:18:43  andrewm
pre-alpha release

 * Revision 1.1  1996/06/26  03:17:38  andrewm
 * Initial revision
 *
 * Revision 1.1  1996/06/15  23:53:35  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _GraphicBuilder_h_
#define _GraphicBuilder_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "MachBuilder.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class StateGraphic ;
class TransitionGraphic ;

class GraphicBuilder :
	public MachBuilder
{
public:
	GraphicBuilder(void) ;

	virtual void build_state(const char *name) ;
	virtual void build_state_graphic_center(const char *x, const char *y) ;
	virtual void build_state_graphic_radius(const char *radius) ;

	virtual void build_transition(const char *event,
		const char *destination) ;
	virtual void build_loop_graphic(const char *angle) ;
	virtual void build_segment_vertex(const char *x, const char *y) ;

private:
	StateGraphic *_current_state_graphic ;
	TransitionGraphic *_current_transition_graphic ;
} ;



#endif /* _GraphicBuilder_h_ */
