/*
 *++
MODULE:

$RCSfile: GraphicRetriever.cc,v $
$Revision: 1.3 $
$Date: 1996/09/22 01:18:43 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: GraphicRetriever.cc,v $
Revision 1.3  1996/09/22 01:18:43  andrewm
pre-alpha release

// Revision 1.2  1996/07/15  01:21:16  andrewm
// checkpoint again
//
// Revision 1.1  1996/06/26  03:17:38  andrewm
// Initial revision
//
// Revision 1.1  1996/06/15  23:53:35  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <stdlib.h>
#include <stdio.h>

#include "GraphicRetriever.h"
#include "PageGroup.h"
#include "Page.h"
#include "StateGraphic.h"
#include "TransitionGraphic.h"
#include "Geom2d.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: GraphicRetriever.cc,v $ $Revision: 1.3 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

GraphicRetriever::
GraphicRetriever(
	PageGroup *page_group) :
		MachRetriever(page_group->machine_group()),
		_page_group(page_group),
		_current_page(NULL),
		_current_state_graphic(NULL),
		_current_transition_graphic(NULL),
		_segment_iter(NULL)
{
}

GraphicRetriever::
~GraphicRetriever(void)
{
	if (_segment_iter) delete _segment_iter ;
}

const char *GraphicRetriever::
retrieve_machine(void)
{
	const char *mname = MachRetriever::retrieve_machine() ;
	if (mname)
		_current_page = _page_group->find_page(_machine_iter->current()) ;
	return mname ;
}

const char *GraphicRetriever::
retrieve_state(void)
{
	const char *sname = MachRetriever::retrieve_state() ;
	if (sname)
	{
		_current_state_graphic =
			_current_page->find_state_graphic(_state_iter->current()) ;
	}
	return sname ;
}

void GraphicRetriever::
retrieve_state_graphic_center(
	const char **x,
	const char **y)
{
	if (x) *x = NULL ;
	if (y) *y = NULL ;

	if (_current_state_graphic)
	{
		const Point center(_current_state_graphic->center()) ;

		static char x_buf[32] ;
		sprintf(x_buf, "%u", unsigned(center.x())) ;
		if (x) *x = x_buf ;

		static char y_buf[32] ;
		sprintf(y_buf, "%u", unsigned(center.y())) ;
		if (y) *y = y_buf ;
	}
}

const char *GraphicRetriever::
retrieve_state_graphic_radius(void)
{
	const char *rval = NULL ;
	if (_current_state_graphic)
	{
		static char r_buf[32] ;
		sprintf(r_buf, "%u", unsigned(_current_state_graphic->radius())) ;
		rval = r_buf ;
	}
	return rval ;
}

void GraphicRetriever::
retrieve_transition(
	const char **event,
	const char **destination)
{
	MachRetriever::retrieve_transition(event, destination) ;
	if (event && *event)
	{
		_current_transition_graphic =
			_current_state_graphic->find_transition_graphic(
				_transition_iter->current()) ;

		delete _segment_iter ;
		_segment_iter = _current_transition_graphic ?
				_current_transition_graphic->create_segment_iterator() :
				new NullIterator<XPoint> ;
	}
}

const char *GraphicRetriever::
retrieve_loop_graphic(void)
{
	const char *angle_string = NULL ;
	if (_current_transition_graphic)
	{
		int angle = _current_transition_graphic->attach_angle() ;
		if (angle >= 0)
		{
			static char angle_buf[32] ;

			sprintf(angle_buf, "%d", angle) ;
			angle_string = angle_buf ;
		}
	}
	return angle_string ;
}

void GraphicRetriever::
retrieve_segment_vertex_start(void)
{
	_segment_iter->first() ;
}

bool GraphicRetriever::
retrieve_segment_vertex_done(void)
{
	return _segment_iter->done() ;
}

void GraphicRetriever::
retrieve_segment_vertex_next(void)
{
	_segment_iter->next() ;
}

void GraphicRetriever::
retrieve_segment_vertex(
	const char **x,
	const char **y)
{
	const char *x_vert = NULL ;
	const char *y_vert = NULL ;
	XPoint vertex = _segment_iter->current() ;
	if (vertex.x >=0 && vertex.y >= 0)
	{
		static char x_vert_buf[32] ;
		sprintf(x_vert_buf, "%d", vertex.x) ;
		x_vert = x_vert_buf ;

		static char y_vert_buf[32] ;
		sprintf(y_vert_buf, "%d", vertex.y) ;
		y_vert = y_vert_buf ;
	}

	if (x) *x = x_vert ;
	if (y) *y = y_vert ;
}
