/*
 *++
MODULE:

$RCSfile: HIOWriter.cc,v $
$Revision: 1.6 $
$Date: 1996/10/01 04:39:31 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: HIOWriter.cc,v $
Revision 1.6  1996/10/01 04:39:31  andrewm
checkpoint and revision

// Revision 1.5  1996/09/22  01:18:43  andrewm
// pre-alpha release
//
// Revision 1.4  1996/08/18  17:58:26  andrewm
// checkpoint
//
// Revision 1.3  1996/07/27  20:57:24  andrewm
// checkpoint
//
// Revision 1.2  1996/06/26  03:17:38  andrewm
// checkpoint
//
// Revision 1.1  1996/06/15  23:53:35  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <stdlib.h>
#include <iostream.h>
#include <errno.h>

#include "HIOWriter.h"
#include "SMAbstractRetriever.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: HIOWriter.cc,v $ $Revision: 1.6 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

HIOWriter::
~HIOWriter()
{
	if (_file_list)
		hio_delete_assignment_list(&_file_list) ;
}

void HIOWriter::
retrieve()
{
	AssignmentList file_list(&_file_list) ;

	_retriever->retrieve_start() ;

	update_value(_retriever->retrieve_author(), "author", file_list) ;
	update_value(_retriever->retrieve_revision(), "revision", file_list) ;
	write_machines(file_list) ;

	_retriever->retrieve_end() ;
}

bool HIOWriter::
write_file(
	const char *filename)
{
	if (filename == NULL || strlen(filename) == 0)
	{
		cerr << "HIOWriter: NULL file name" << endl ;
		return false ;
	}

	if (_file_list == NULL)
	{
		cerr << "HIOWriter: NULL file list" << endl ;
		return false ;
	}

	FILE *outfile = fopen(filename, "w") ;
	if (outfile == NULL)
	{
		cerr << "Cannot open \"" << filename << "\" for writing: "
			<< strerror(errno) << endl ;
		return false ;
	}

	hio_write(outfile, _file_list) ;
	fclose(outfile) ;
	return true ;
}

void HIOWriter::
write_machines(
	AssignmentList list)
{
	Assignment sm_assign(update_assignment("state_machines", list)) ;
	for (_retriever->retrieve_machine_start() ;
		!_retriever->retrieve_machine_done() ;
		_retriever->retrieve_machine_next())
	{
		const char *machine_name = _retriever->retrieve_machine() ;
		if (machine_name)
		{
			Assignment machine(update_assignment(machine_name,
				sm_assign.valueList())) ;
			AssignmentList machine_list(machine.valueList()) ;

			update_value(_retriever->retrieve_counter(), "counter",
				machine_list) ;
			update_value(_retriever->retrieve_prolog(), "prolog",
				machine_list) ;
			update_value(_retriever->retrieve_epilog(), "epilog",
				machine_list) ;
			update_value(_retriever->retrieve_error_action(), "error_action",
				machine_list) ;
			update_value(_retriever->retrieve_ignore_action(), "ignore_action",
				machine_list) ;
			update_value(_retriever->retrieve_initial_state(),
				"initial_state", machine_list) ;
			update_value(_retriever->retrieve_terminal_state(),
				"terminal_state", machine_list) ;
			update_value(_retriever->retrieve_default_state(), "default_state",
				machine_list) ;
			write_events(machine_list) ;
			write_states(machine_list) ;
		}
	}
}

void HIOWriter::
write_events(
	AssignmentList list)
{
	_retriever->retrieve_event_start() ;
	if (!_retriever->retrieve_event_done())
	{
		Assignment event_assign(update_assignment("events", list)) ;

		for ( ; !_retriever->retrieve_event_done() ;
			_retriever->retrieve_event_next())
		{
			const char *event_name = _retriever->retrieve_event() ;
			Assignment event(update_assignment(event_name,
				event_assign.valueList())) ;
			write_event_parameters(event.valueList()) ;
		}
	}
}

void HIOWriter::
write_event_parameters(
	AssignmentList list)
{
	int i = 0 ;
	for (_retriever->retrieve_event_parameter_start() ;
		!_retriever->retrieve_event_parameter_done() ;
		_retriever->retrieve_event_parameter_next())
	{
		const char *type ;
		const char *name ;
		_retriever->retrieve_event_parameter(&type, &name) ;
		if (type && name)
		{
			Assignment param_assign(update_assignment(i++, list)) ;
			param_assign += Assignment("type", type) ;
			param_assign += Assignment("name", name) ;
		}
	}
}

void HIOWriter::
write_states(
	AssignmentList list)
{
	_retriever->retrieve_state_start() ;
	if (!_retriever->retrieve_state_done())
	{
		Assignment state_assign(update_assignment("states", list)) ;

		for ( ; !_retriever->retrieve_state_done() ;
			_retriever->retrieve_state_next())
		{
			const char *state_name = _retriever->retrieve_state() ;
			Assignment state(update_assignment(state_name,
				state_assign.valueList())) ;

			AssignmentList state_list(state.valueList()) ;
			write_state_parameters(state_list) ;
			update_value(_retriever->retrieve_code(), "code", state_list) ;
			write_state_graphic_center(state_list) ;
			update_value(_retriever->retrieve_state_graphic_radius(), "radius",
				state_list) ;
			write_transitions(state_list) ;
		}
	}
}

void HIOWriter::
write_state_parameters(
	AssignmentList list)
{
	int i = 0 ;
	_retriever->retrieve_state_parameter_start() ;
	if (!_retriever->retrieve_state_parameter_done())
	{
		Assignment param_assign(update_assignment("parameters", list)) ;

		for ( ; !_retriever->retrieve_state_parameter_done() ;
			_retriever->retrieve_state_parameter_next())
		{
			const char *type ;
			const char *name ;
			_retriever->retrieve_state_parameter(&type, &name) ;
			if (type && name)
			{
				Assignment decl(update_assignment(i++,
					param_assign.valueList())) ;
				decl += Assignment("type", type) ;
				decl += Assignment("name", name) ;
			}
		}
	}
}

void HIOWriter::
write_state_graphic_center(
	AssignmentList list)
{
	const char *x = NULL ;
	const char *y = NULL ;
	_retriever->retrieve_state_graphic_center(&x, &y) ;
	if (x && y)
	{
		Assignment center(update_assignment("center", list)) ;
		AssignmentList center_list(center.valueList()) ;
		update_value(x, 0, center_list) ;
		update_value(y, 1, center_list) ;
	}
}


void HIOWriter::
write_transitions(
	AssignmentList list)
{
	_retriever->retrieve_transition_start() ;
	if (!_retriever->retrieve_transition_done())
	{
		Assignment trans_assign(update_assignment("transitions", list)) ;

		for ( ; !_retriever->retrieve_transition_done() ;
			_retriever->retrieve_transition_next())
		{
			const char *event = NULL ;
			const char *destination = NULL ;
			_retriever->retrieve_transition(&event, &destination) ;
			if (event && destination)
			{
				Assignment transition(update_assignment(event,
					trans_assign.valueList())) ;
				AssignmentList trans_list(transition.valueList()) ;

				update_value(destination, "destination", trans_list) ;
				update_value(_retriever->retrieve_loop_graphic(), "attach",
					trans_list) ;
				write_segment_graphics(trans_list) ;
			}
		}
	}
}

void HIOWriter::
write_segment_graphics(
	AssignmentList list)
{
	_retriever->retrieve_segment_vertex_start() ;
	if (!_retriever->retrieve_segment_vertex_done())
	{
		Assignment trans_assign(update_assignment("path", list)) ;
		AssignmentList trans_list(trans_assign.valueList()) ;

		for (int i = 0 ; !_retriever->retrieve_segment_vertex_done() ;
			_retriever->retrieve_segment_vertex_next())
		{
			const char *x = NULL ;
			const char *y = NULL ;
			_retriever->retrieve_segment_vertex(&x, &y) ;
			if (x && y)
			{
				Assignment segment_vertex(update_assignment(i++, trans_list)) ;
				AssignmentList sv_list(segment_vertex.valueList()) ;

				update_value(x, 0, sv_list) ;
				update_value(y, 1, sv_list) ;
			}
		}
	}
}

void HIOWriter::
update_value(
	const char *value,
	const char *name,
	AssignmentList list)
{
	Assignment assign(list.find_assignment(name)) ;
	if (value && *value)
	{
		if (assign)
			assign.valueString(value) ;
		else
			list += Assignment(name, value) ;
	}
	else if (assign)
	{
		list -= assign ;
		~assign ;
	}
}

void HIOWriter::
update_value(
	const char *value,
	int number,
	AssignmentList list)
{
	Assignment assign(list.find_assignment(number)) ;
	if (value && *value)
	{
		if (assign)
			assign.valueString(value) ;
		else
			list += Assignment(number, value) ;
	}
	else if (assign)
	{
		list -= assign ;
		~assign ;
	}
}

Assignment HIOWriter::
update_assignment(
	const char *assign_name,
	AssignmentList list)
{
	Assignment assign(list.find_assignment(assign_name)) ;
	if (!assign)
	{
		assign = Assignment(assign_name, Value(Value::ValueList)) ;
		list += assign ;
	}

	return assign ;
}

Assignment HIOWriter::
update_assignment(
	int number,
	AssignmentList list)
{
	Assignment assign(list.find_assignment(number)) ;
	if (!assign)
	{
		assign = Assignment(number, Value(Value::ValueList)) ;
		list += assign ;
	}

	return assign ;
}
