/*
 *++
MODULE:

$RCSfile: MachBuilder.cc,v $
$Revision: 1.6 $
$Date: 1996/10/01 04:39:31 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MachBuilder.cc,v $
Revision 1.6  1996/10/01 04:39:31  andrewm
checkpoint and revision

// Revision 1.5  1996/09/22  01:18:43  andrewm
// pre-alpha release
//
// Revision 1.4  1996/08/18  17:58:26  andrewm
// checkpoint
//
// Revision 1.3  1996/07/27  20:57:24  andrewm
// checkpoint
//
// Revision 1.2  1996/06/26  03:17:38  andrewm
// *** empty log message ***
//
// Revision 1.1  1996/06/15  23:53:35  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <iostream.h>
#include <stdlib.h>

#include "MachBuilder.h"
#include "MachineGroup.h"
#include "Smachine.h"
#include "MachEvent.h"
#include "State.h"
#include "Transition.h"
#include "Parameter.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: MachBuilder.cc,v $ $Revision: 1.6 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

MachBuilder::
MachBuilder() :
	_current_group(0),
	_current_machine(0),
	_current_event(0),
	_current_state(0)
{
}

void MachBuilder::
build_start()
{
	_current_group = new MachineGroup() ;
}

void MachBuilder::
build_end()
{
	_current_group->modified(false) ;
}

void MachBuilder::
build_author(
	const char *author)
{
	if (author)
		_current_group->author(author) ;
}

void MachBuilder::
build_revision(
	const char *revision)
{
	if (revision)
		_current_group->revision(revision) ;
}

void MachBuilder::
build_machine(
	const char *name)
{
	_current_machine = _current_group->add_machine(name) ;
}

void MachBuilder::
build_counter(
	const char *counter)
{
	if (counter)
	{
		char *end ;
		int cnt_value = strtol(counter, &end, 0) ;
		if (*end == '\0')
			_current_machine->counter(cnt_value) ;
		else
			cerr << "Conversion error for counter \"" << counter << "\""
				<< endl ;
	}
}

void MachBuilder::
build_prolog(
	const char *prolog,
	int line_no)
{
	if (prolog)
		_current_machine->prolog(prolog, line_no) ;
}

void MachBuilder::
build_epilog(
	const char *epilog,
	int line_no)
{
	if (epilog)
		_current_machine->epilog(epilog, line_no) ;
}

void MachBuilder::
build_error_action(
	const char *error_action,
	int line_no)
{
	if (error_action)
		_current_machine->error_action(error_action, line_no) ;
}

void MachBuilder::
build_ignore_action(
	const char *ignore_action,
	int line_no)
{
	if (ignore_action)
		_current_machine->ignore_action(ignore_action, line_no) ;
}

void MachBuilder::
build_initial_state(
	const char *initial_name)
{
	if (initial_name)
	{
		State *initial_state = _current_machine->find_state(initial_name) ;
		if (initial_state)
		{
			_current_machine->initial_state(initial_state) ;
		}
		else
		{
			cerr << "Initial state \"" << initial_name << "\" not found"
				<< endl ;
		}
	}
}

void MachBuilder::
build_terminal_state(
	const char *terminal_name)
{
	if (terminal_name)
	{
		State *terminal_state = _current_machine->find_state(terminal_name) ;
		if (terminal_state)
		{
			_current_machine->terminal_state(terminal_state) ;
		}
		else
		{
			cerr << "Initial state \"" << terminal_name << "\" not found"
				<< endl ;
		}
	}
}

void MachBuilder::
build_default_state(
	const char *default_name)
{
	if (default_name)
	{
		State *default_state = _current_machine->find_state(default_name) ;
		if (default_state)
		{
			_current_machine->default_state(default_state) ;
		}
		else
		{
			cerr << "Initial state \"" << default_name << "\" not found"
				<< endl ;
		}
	}
}

void MachBuilder::
build_event(
	const char *name)
{
	_current_event = _current_machine->add_event(name) ;
}

void MachBuilder::
build_event_parameter(
	const char *type,
	const char *name)
{
	_current_event->add_parameter(type, name) ;
}

void MachBuilder::
build_state(
	const char *name)
{
	_current_state = _current_machine->add_state(name) ;
}

void MachBuilder::
build_code(
	const char *code,
	int line_no)
{
	if (code)
		_current_state->code(code, line_no) ;
}

void MachBuilder::
build_state_parameter(
	const char *type,
	const char *name)
{
	_current_state->add_parameter(type, name) ;
}

void MachBuilder::
build_transition(
	const char *event,
	const char *destination)
{
	MachEvent *e = _current_machine->find_event(event) ;
	if (!e)
	{
		cerr << "Event \"" << event << "\" was not found" << endl ;
		return ;
	}
	State *d = _current_machine->find_state(destination) ;
	if (!d)
	{
		cerr << "State \"" << destination << "\" was not found" << endl ;
		return ;
	}

	_current_transition = _current_state->add_transition(e, d) ;
}
