/*
 *++
MODULE:

$RCSfile: MachBuilder.h,v $
$Revision: 1.6 $
$Date: 1996/10/01 04:39:31 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MachBuilder.h,v $
Revision 1.6  1996/10/01 04:39:31  andrewm
checkpoint and revision

 * Revision 1.5  1996/09/22  01:18:43  andrewm
 * pre-alpha release
 *
 * Revision 1.4  1996/08/18  17:58:26  andrewm
 * checkpoint
 *
 * Revision 1.3  1996/07/27  20:57:24  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/06/26  03:17:38  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/06/15  23:53:35  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _MachBuilder_h_
#define _MachBuilder_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "SMAbstractBuilder.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class MachineGroup ;
class Smachine ;
class MachEvent ;
class State ;
class Transition ;

class MachBuilder :
	public SMAbstractBuilder
{
public:
	MachBuilder() ;

	virtual void build_start() ;
	virtual void build_end() ;

	virtual void build_author(const char *author) ;
	virtual void build_revision(const char *revision) ;

	virtual void build_machine(const char *name) ;
	virtual void build_counter(const char *counter) ;
	virtual void build_prolog(const char *prolog, int line_no) ;
	virtual void build_epilog(const char *epilog, int line_no) ;
	virtual void build_error_action(const char *error_action, int line_no) ;
	virtual void build_ignore_action(const char *ignore_action, int line_no) ;
	virtual void build_initial_state(const char *initial_name) ;
	virtual void build_terminal_state(const char *terminal_name) ;
	virtual void build_default_state(const char *default_name) ;

	virtual void build_event(const char *name) ;
	virtual void build_event_parameter(const char *type, const char *name) ;

	virtual void build_state(const char *name) ;
	virtual void build_code(const char *code, int line_no) ;
	virtual void build_state_parameter(const char *type, const char *name) ;

	virtual void build_transition(const char *event, const char *destination) ;

	MachineGroup *machine_group() const ;

protected:
	MachineGroup *_current_group ;
	Smachine *_current_machine ;
	MachEvent *_current_event ;
	State *_current_state ;
	Transition *_current_transition ;
} ;

inline MachineGroup *MachBuilder::
machine_group() const
{
	return _current_group ;
}


#endif /* _MachBuilder_h_ */
