/*
 *++
MODULE:

$RCSfile: MachRetriever.cc,v $
$Revision: 1.7 $
$Date: 1996/11/17 21:50:52 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MachRetriever.cc,v $
Revision 1.7  1996/11/17 21:50:52  andrewm
Converting to the new version of g++ (2.7.2) and now everything
is under CVS.

Revision 1.6  1996/10/01 04:39:31  andrewm
checkpoint and revision

// Revision 1.5  1996/09/22  01:18:43  andrewm
// pre-alpha release
//
// Revision 1.4  1996/08/18  17:58:26  andrewm
// checkpoint
//
// Revision 1.3  1996/07/27  20:57:24  andrewm
// checkpoint
//
// Revision 1.2  1996/06/26  03:17:38  andrewm
// checkpoint
//
// Revision 1.1  1996/06/15  23:53:35  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <stdio.h>

#include "MachRetriever.h"
#include "MachineGroup.h"
#include "Smachine.h"
#include "MachEvent.h"
#include "State.h"
#include "Transition.h"
#include "Parameter.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: MachRetriever.cc,v $ $Revision: 1.7 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

MachRetriever::
MachRetriever(
	MachineGroup *machine_group) :
		_machine_group(machine_group),
		_machine_iter(0),
		_event_iter(0),
		_event_parameter_iter(0),
		_state_iter(0),
		_state_parameter_iter(0),
		_transition_iter(0)
{
}

MachRetriever::
~MachRetriever()
{
	if (_machine_iter) delete _machine_iter ;
	if (_event_iter) delete _event_iter ;
	if (_event_parameter_iter) delete _event_parameter_iter ;
	if (_state_iter) delete _state_iter ;
	if (_state_parameter_iter) delete _state_parameter_iter ;
	if (_transition_iter) delete _transition_iter ;
}

const char *MachRetriever::
retrieve_author()
{
	return _machine_group->author() ;
}

const char *MachRetriever::
retrieve_revision()
{
	return _machine_group->revision() ;
}

void MachRetriever::
retrieve_machine_start()
{
	if (_machine_iter) delete _machine_iter ;
	_machine_iter = _machine_group->create_machine_iterator() ;
	_machine_iter->first() ;
}

bool MachRetriever::
retrieve_machine_done()
{
	return _machine_iter ? _machine_iter->done() : true ;
}

void MachRetriever::
retrieve_machine_next()
{
	if (_machine_iter)
		_machine_iter->next() ;
}

const char *MachRetriever::
retrieve_machine()
{
	const char *name = NULL ;
	if (_machine_iter && !_machine_iter->done())
	{
		Smachine *sm = _machine_iter->current() ;
		if (sm->state_count() > 0)
			name = sm->name() ;
	}
	return name ;
}

const char *MachRetriever::
retrieve_counter()
{
	static char cnv_buf[32] ;
	sprintf(cnv_buf, "%d", _machine_iter->current()->counter()) ;
	return cnv_buf ;
}

const char *MachRetriever::
retrieve_prolog()
{
	return (const char *)_machine_iter->current()->prolog() ;
}

const char *MachRetriever::
retrieve_epilog()
{
	return (const char *)_machine_iter->current()->epilog() ;
}

const char *MachRetriever::
retrieve_error_action()
{
	return (const char *)_machine_iter->current()->error_action() ;
}

const char *MachRetriever::
retrieve_ignore_action()
{
	return (const char *)_machine_iter->current()->ignore_action() ;
}

const char *MachRetriever::
retrieve_initial_state()
{
	State *initial_state = _machine_iter->current()->initial_state() ;
	return initial_state ? (const char *)initial_state->name() :
		(const char *)NULL ;
}

const char *MachRetriever::
retrieve_terminal_state()
{
	State *terminal_state = _machine_iter->current()->terminal_state() ;
	return terminal_state ? (const char *)terminal_state->name() :
		(const char *)NULL ;
}

const char *MachRetriever::
retrieve_default_state()
{
	State *default_state = _machine_iter->current()->default_state() ;
	return default_state ? (const char *)default_state->name() :
		(const char *)NULL ;
}

void MachRetriever::
retrieve_event_start()
{
	if (_event_iter) delete _event_iter ;
	_event_iter = _machine_iter->current()->create_event_iterator() ;
	_event_iter->first() ;
}

bool MachRetriever::
retrieve_event_done()
{
	return _event_iter ? _event_iter->done() : true ;
}

void MachRetriever::
retrieve_event_next()
{
	if (_event_iter)
		_event_iter->next() ;
}

const char *MachRetriever::
retrieve_event()
{
	return ((_event_iter && !_event_iter->done()) ?
			(const char *)_event_iter->current()->name() :
			(const char *)NULL) ;
}

void MachRetriever::
retrieve_event_parameter_start()
{
	if (_event_parameter_iter) delete _event_parameter_iter ;
	_event_parameter_iter =
		_event_iter->current()->create_parameter_iterator() ;
	_event_parameter_iter->first() ;
}

bool MachRetriever::
retrieve_event_parameter_done()
{
	return _event_parameter_iter ? _event_parameter_iter->done() : true ;
}

void MachRetriever::
retrieve_event_parameter_next()
{
	if (_event_parameter_iter)
		_event_parameter_iter->next() ;
}

void MachRetriever::
retrieve_event_parameter(
	const char **type,
	const char **name)
{
	if (_event_parameter_iter && !_event_parameter_iter->done())
	{
		Parameter *param = _event_parameter_iter->current() ;
		*type = (const char *)param->type() ;
		*name = (const char *)param->name() ;
	}
	else
		*type = *name = NULL ;
}

void MachRetriever::
retrieve_state_start()
{
	if (_state_iter) delete _state_iter ;
	_state_iter = _machine_iter->current()->create_state_iterator() ;
	_state_iter->first() ;
}

bool MachRetriever::
retrieve_state_done()
{
	return _state_iter ? _state_iter->done() : true ;
}

void MachRetriever::
retrieve_state_next()
{
	if (_state_iter)
		_state_iter->next() ;
}

const char *MachRetriever::
retrieve_state()
{
	return ((_state_iter && !_state_iter->done()) ?
			(const char *)_state_iter->current()->name() :
			(const char *)NULL) ;
}

void MachRetriever::
retrieve_state_parameter_start()
{
	if (_state_parameter_iter) delete _state_parameter_iter ;
	_state_parameter_iter =
		_state_iter->current()->create_parameter_iterator() ;
	_state_parameter_iter->first() ;
}

bool MachRetriever::
retrieve_state_parameter_done()
{
	return _state_parameter_iter ? _state_parameter_iter->done() : true ;
}

void MachRetriever::
retrieve_state_parameter_next()
{
	if (_state_parameter_iter)
		_state_parameter_iter->next() ;
}

void MachRetriever::
retrieve_state_parameter(
	const char **type,
	const char **name)
{
	if (_state_parameter_iter && !_state_parameter_iter->done())
	{
		Parameter *param = _state_parameter_iter->current() ;
		*type = (const char *)param->type() ;
		*name = (const char *)param->name() ;
	}
	else
		*type = *name = NULL ;
}

const char *MachRetriever::
retrieve_code()
{
	return (const char *)_state_iter->current()->code() ;
}

void MachRetriever::
retrieve_transition_start()
{
	if (_transition_iter) delete _transition_iter ;
	_transition_iter = _state_iter->current()->create_transition_iterator() ;
	_transition_iter->first() ;
}

bool MachRetriever::
retrieve_transition_done()
{
	return _transition_iter ? _transition_iter->done() : true ;
}

void MachRetriever::
retrieve_transition_next()
{
	if (_transition_iter)
		_transition_iter->next() ;
}

void MachRetriever::
retrieve_transition(
	const char **event,
	const char **destination)
{
	if (event) *event = NULL ;
	if (destination) *destination = NULL ;

	if (_transition_iter && !_transition_iter->done())
	{
		Transition *transition = _transition_iter->current() ;
		MachEvent *e = transition->event() ;
		if (e && event)
			*event = (const char *)e->name() ;
		State *d = transition->destination() ;
		if (d && destination)
			*destination = (const char *)d->name() ;
	}
}
