/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: CSutils.cc,v $
$Revision: 1.5 $
$Date: 1997/07/02 04:45:14 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: CSutils.cc,v $
Revision 1.5  1997/07/02 04:45:14  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.4  1997/02/23 23:44:14  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.3  1996/09/22 01:22:58  andrewm
*** empty log message ***

// Revision 1.2  1996/07/15  01:20:12  andrewm
// checkpoint again
//
// Revision 1.2  1996/07/15  01:20:12  andrewm
// checkpoint again
//
// Revision 1.1  1996/06/26  03:12:53  andrewm
// Initial revision
//
// Revision 1.1  1996/05/26  22:27:43  andrewm
// Initial revision
//
// Revision 1.2  1996/02/27  04:52:23  andrewm
// Checkpoint before going in and straightening out some of the
// class architecture.
//
// Revision 1.1  1996/02/19  19:41:00  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <assert.h>

#include <Xm/Xm.h>
#include "CSutils.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/
static void create_parse_table(void) ;

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: CSutils.cc,v $ $Revision: 1.5 $" ;
static XmParseTable ptable = NULL ;
const int ptable_size = 2 ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

XmString
TextToCS(
	const char *text)
{
	if (text)
	{
		if (ptable == NULL)
			create_parse_table() ;

		return XmStringParseText((XtPointer)text, NULL, NULL, XmCHARSET_TEXT,
			ptable, ptable_size, NULL) ;
	}
	else
		return NULL ;
}

char *
CSToText(
	XmString cs)
{
	if (ptable == NULL)
		create_parse_table() ;

	return (char *)XmStringUnparse(cs, NULL, XmCHARSET_TEXT, XmCHARSET_TEXT,
		ptable, ptable_size, XmOUTPUT_ALL) ;
}

XmStringTable
TextArrayToCSTable(
	char **text_array,
	int count)
{
	if (ptable == NULL)
		create_parse_table() ;

	return XmStringTableParseStringArray((XtPointer *)text_array, count,
		NULL, XmCHARSET_TEXT, ptable, ptable_size, NULL) ;
}

char **
CSTableToTextArray(
	XmStringTable table,
	int count)
{
	if (ptable == NULL)
		create_parse_table() ;

	return (char **)XmStringTableUnparse(table, count, NULL, XmCHARSET_TEXT,
		XmCHARSET_TEXT, ptable, ptable_size, XmOUTPUT_ALL) ;
}

void
CSTableFree(
	XmStringTable table,
	int count)
{
	XmStringTable t = table ;
	for (XmString s = *t++ ; count-- > 0 ; s = *t++)
		XmStringFree(s) ;
	XtFree((char *)table) ;
}

void
TextArrayFree(
	char **array,
	int count)
{
	char **a = array ;
	for (char *s = *a++ ; count-- > 0 ; s = *a++)
		delete[] s ;
	delete[] array ;
}

static void
create_parse_table(void)
{
	Arg args[3] ;
	Cardinal n ;
	XmString tmp ;
	int index = 0 ;

	ptable = (XmParseTable)XtCalloc(ptable_size, sizeof(XmParseMapping)) ;

		// tab characters
	tmp = XmStringComponentCreate(XmSTRING_COMPONENT_TAB, 0, NULL) ;
	n = 0 ;
	XtSetArg(args[n], XmNincludeStatus, XmINSERT), n++ ;
	XtSetArg(args[n], XmNsubstitute, tmp), n++ ;
	XtSetArg(args[n], XmNpattern, "\t"), n++ ;
	ptable[index++] = XmParseMappingCreate(args, n) ;
	XmStringFree(tmp) ;

		// newline characters
	tmp = XmStringComponentCreate(XmSTRING_COMPONENT_SEPARATOR, 0, NULL) ;
	n = 0 ;
	XtSetArg(args[n], XmNincludeStatus, XmINSERT), n++ ;
	XtSetArg(args[n], XmNsubstitute, tmp), n++ ;
	XtSetArg(args[n], XmNpattern, "\n"), n++ ;
	ptable[index++] = XmParseMappingCreate(args, n) ;
	XmStringFree(tmp) ;

	assert(index <= ptable_size) ;
}
