/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Command.h,v $
$Revision: 1.7 $
$Date: 1997/07/02 04:45:15 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Command.h,v $
Revision 1.7  1997/07/02 04:45:15  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.6  1997/03/04 06:32:56  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.5  1997/02/23 23:44:14  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.4  1997/01/23 06:19:47  andrewm
Checkpoint as base and graphics classes stabilize.
Observer/subject pattern operating between base and graphic classes.

Revision 1.3  1996/09/22 01:22:58  andrewm
*** empty log message ***

 * Revision 1.2  1996/07/27  20:56:24  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/07/27  20:56:24  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/07/15  01:20:12  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _Command_h_
#define _Command_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <list>
#include <Xm/Xm.h>

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class Command
{
public:
	virtual ~Command() {}

	virtual void execute() = 0 ;

protected:
	Command() {}
} ;

class NullCommand :
	public Command
{
public:
	virtual void execute() {}
} ;

template<class Receiver>
class SimpleCommand :
	public Command
{
public:
	typedef void (Receiver::* Action)() ;

	SimpleCommand(Receiver *receiver, Action action) :
		_receiver(receiver), _action(action) {}
	virtual void execute() { (_receiver->*_action)() ; }

protected:
	Receiver *_receiver ;
	Action _action ;
} ;

class MacroCommand :
	public Command
{
public:
	MacroCommand() {}
	virtual ~MacroCommand() ;

	virtual void execute() ;
	virtual void add_command(Command *command) ;
	virtual void remove_command(Command *command) ;

protected:
	list<Command *> _command_list ;

private:
	MacroCommand& operator =(const MacroCommand&) ; // no copy
} ;

class XmCommand :
	public Command
{
public:
	virtual ~XmCommand() {}

	virtual void execute() {}
	virtual void execute(XmAnyCallbackStruct *callback) = 0 ;

protected:
	XmCommand() {}
} ;

class NullXmCommand :
	public XmCommand
{
public:
	virtual void execute(XmAnyCallbackStruct *callback_data) {}
} ;

template<class Receiver>
class SimpleXmCommand :
	public XmCommand
{
public:
	typedef void (Receiver::* XmAction)(XmAnyCallbackStruct *callback) ;

	SimpleXmCommand(Receiver *receiver, XmAction action) :
		_receiver(receiver), _action(action) {}
	virtual void execute(XmAnyCallbackStruct *callback_data) {
		(_receiver->*_action)(callback_data) ;
	}

protected:
	Receiver *_receiver ;
	XmAction _action ;
} ;


#endif /* _Command_h_ */
