/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: FileName.cc,v $
$Revision: 1.3 $
$Date: 1997/07/02 04:45:15 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: FileName.cc,v $
Revision 1.3  1997/07/02 04:45:15  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.2  1997/03/30 02:07:30  andrewm
Checkpoint.  Things working well. About to change the way
machines are stored in the backing file.

Revision 1.1  1997/02/23 23:44:15  andrewm
Checkpoint.  Things seem to be working reasonably well.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "FileName.h"
#include <string.h>
#include <fcntl.h>
#include <dirent.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: FileName.cc,v $ $Revision: 1.3 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/
FileName::
FileName()
{
}

FileName::
FileName(
	const char *path) :
	string(path)
{
}

FileName::
FileName(
	const string& path) :
	string(path)
{
}

FileName::
FileName(
	const char *dir,
	const char *name) :
	string(string(dir) + string("/") + string(name))
{
}

bool FileName::
can_stat() const
{
	struct stat file_stat ;
	bool got_stat = get_stat(&file_stat) ;
	return got_stat ;
}

time_t FileName::
access_time() const
{
	struct stat file_stat ;
	bool got_stat = get_stat(&file_stat) ;
	return got_stat == true ? file_stat.st_atime : 0 ;
}

time_t FileName::
modify_time() const
{
	struct stat file_stat ;
	bool got_stat = get_stat(&file_stat) ;
	return got_stat == true ? file_stat.st_mtime : 0 ;
}

time_t FileName::
change_time() const
{
	struct stat file_stat ;
	bool got_stat = get_stat(&file_stat) ;
	return got_stat == true ? file_stat.st_ctime : 0 ;
}

off_t FileName::
file_size() const
{
	struct stat file_stat ;
	bool got_stat = get_stat(&file_stat) ;
	return got_stat == true ? file_stat.st_size : 0 ;
}

bool FileName::
is_link() const
{
	struct stat file_stat ;
	bool got_stat = get_stat(&file_stat) ;
	return got_stat == true ? S_ISLNK(file_stat.st_mode) != 0 : false ;
}

bool FileName::
is_regular() const
{
	struct stat file_stat ;
	bool got_stat = get_stat(&file_stat) ;
	return got_stat == true ? S_ISREG(file_stat.st_mode) != 0 : false ;
}

bool FileName::
is_dir() const
{
	struct stat file_stat ;
	bool got_stat = get_stat(&file_stat) ;
	return got_stat == true ? S_ISDIR(file_stat.st_mode) != 0 : false ;
}

bool FileName::
mkdir() const
{
	return ::mkdir(c_str(), 0777) == 0 ;
}

bool FileName::
file_delete() const
{
	return (is_dir() ? rmdir(c_str()) : unlink(c_str())) == 0 ;
}

FileName::DirList FileName::
dir_list() const
{
	DirList list ;

	if (DIR *d = opendir(c_str()))
	{
		while (struct dirent *entry = readdir(d))
			list.push_back(string(entry->d_name)) ;
		closedir(d) ;
	}

	return list ;
}

bool FileName::
get_stat(
	struct stat *file_stat) const
{
	int s = stat(c_str(), file_stat) ;
	return s == 0 ;
}

ostream&
operator <<(
	ostream& s,
	const FileName& fn)
{
	return s << fn.c_str() ;
}
