/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: OstreamListIterator.h,v $
$Revision: 1.2 $
$Date: 1997/07/02 04:45:16 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: OstreamListIterator.h,v $
Revision 1.2  1997/07/02 04:45:16  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.1  1997/01/23 06:19:50  andrewm
Checkpoint as base and graphics classes stabilize.
Observer/subject pattern operating between base and graphic classes.

 *--
 */
#ifndef _OstreamListIterator_h_
#define _OstreamListIterator_h_

/*
PRAGMAS
*/

/*
INCLUDE FILES
*/
#include <iterator>

/*
MACRO DEFINITIONS
*/

/*
CLASS FORWARD REFERENCES
*/

/*
CLASS DEFINITIONS
*/

template <class T>
OstreamListIterator :
	public ostream_iterator<T>
{
public:
	OstreamListIterator(ostream& s, char *c) :
		ostream_iterator(s, c), _first(true) {}
	OstreamListIterator<T>& operator =(const T& value {
		if (first) first = false ;
		else if (string) *stream << string ;
		*stream << value ;
		return *this ;
	}

private:
	bool _first ;
}



#endif /* _OstreamListIterator_h_ */
