/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: PageSize.h,v $
$Revision: 1.2 $
$Date: 1997/07/02 04:45:16 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: PageSize.h,v $
Revision 1.2  1997/07/02 04:45:16  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.1  1997/06/21 02:21:34  andrewm
Checkpoint.  PostScript generator going well. A lot of small tweeks
all over to accomplish this.

 *--
 */
#ifndef _PageSize_h_
#define _PageSize_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <string>
#include <list>

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class PageSize
{
public:
	static PageSize *find(const char *name) ;

	~PageSize() ;

		// Useful member functions
	const string& name() { return _name ; }
	float width() { return _width ; }
	float height() { return _height ; }

		// Overloaded operators
	friend bool operator ==(const PageSize& ps1, const PageSize& ps2) ;
	friend bool operator !=(const PageSize& ps1, const PageSize& ps2) ;

private:
		// Construction and destruction
	PageSize(const char *name, float width, float height) ;
		// Copy constructor
		// No copies allowed!
	PageSize(const PageSize& page_size) ;
		// Assignment operator
		// No assignments allowed!
	PageSize& operator =(const PageSize& page_size) ;

private:
	string _name ;
	float _width ;
	float _height ;

private:
	static list<PageSize *> _pages ;

	static PageSize letter ;
	static PageSize legal ;
	static PageSize ledger ;
	static PageSize tabloid ;
	static PageSize a4 ;
	static PageSize a3 ;
	static PageSize a2 ;
	static PageSize a1 ;
	static PageSize a0 ;
} ;


#endif /* _PageSize_h_ */
