/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: SubProcess.h,v $
$Revision: 1.5 $
$Date: 1997/07/02 04:45:17 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: SubProcess.h,v $
Revision 1.5  1997/07/02 04:45:17  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.4  1997/02/23 23:44:15  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.3  1997/01/23 06:19:50  andrewm
Checkpoint as base and graphics classes stabilize.
Observer/subject pattern operating between base and graphic classes.

Revision 1.2  1996/09/22 01:22:58  andrewm
*** empty log message ***

 * Revision 1.1  1996/08/05  01:25:23  andrewm
 * Initial revision
 *
 * Revision 1.1  1996/08/05  01:25:23  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _SubProcess_h_
#define _SubProcess_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <sys/types.h>
#include <signal.h>

#include <X11/Intrinsic.h>

#include <list>

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class Command ;

class SubProcess
{
public:
	SubProcess(Command *exit_command) ;
	~SubProcess() ;

	pid_t run(const char *command ...) ;
	bool stop(int signal_id = SIGTERM) ;

	pid_t pid() { return _pid ; }

public:
	static void install_signalling(XtAppContext app_context) ;

private:
	Command *_exit_command ;
	pid_t _pid ;

private:
	typedef list<SubProcess *> SubProcessList ;
	typedef list<SubProcess *>::iterator SubProcessListIter ;

	static SubProcessList _subprocess_list ;
	static XtSignalId _sigchld_id ;

private:
	static void sigchld_callback(XtPointer closure, XtSignalId *id) ;
	static void sigchld_handler(int signum) ;
} ;



#endif /* _SubProcess_h_ */
