/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Page.h,v $
$Revision: 1.12 $
$Date: 1997/07/02 04:45:18 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Page.h,v $
Revision 1.12  1997/07/02 04:45:18  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.11  1997/06/06 04:34:28  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.10  1997/02/08 04:37:43  andrewm
Checkpoint before returning to work on the GUI portion.

Revision 1.9  1997/01/23 06:20:56  andrewm
Checkpoint as base and graphics classes are operating together.

Revision 1.8  1996/11/27 01:25:53  andrewm
Another checkpoint before I go off and figure out what to do about
the graphical representations so that I'll be able to get some post script
output one of these days.

Revision 1.7  1996/11/14 06:19:54  andrewm
checkpoint

 * Revision 1.6  1996/10/01  04:39:26  andrewm
 * checkpoint and revision
 *
 * Revision 1.5  1996/09/22  01:18:34  andrewm
 * pre-alpha release
 *
 * Revision 1.4  1996/08/18  17:58:13  andrewm
 * checkpoint
 *
 * Revision 1.3  1996/08/05  01:25:56  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/07/27  20:57:09  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/06/26  03:16:15  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _Page_h_
#define _Page_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "Observer.h"
#include "GraphicRenderer.h"
#include "Geom2d.h"

#include <list>

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class PageGroup ;
class Smachine ;
class State ;
class StateGraphic ;

class Page :
	public Observer
{
public:
	typedef list<StateGraphic *> StateGraphicList ;
	typedef list<StateGraphic *>::iterator StateGraphicListIter ;
	typedef list<StateGraphic *>::const_iterator StateGraphicListConstIter ;

public:
	Page(PageGroup *parent, Smachine *machine) ;
	~Page() ;

	PageGroup *parent() const { return _parent ; }
	void orphan() { _parent = NULL ; }
	Smachine *machine() const { return _machine ; }

	StateGraphic *find_state_graphic(State *state) ;
	StateGraphic *find_state_graphic(const char *state_name) ;
	void remove_state_graphic(StateGraphic *state_graphic) ;
	StateGraphicList& state_graphic_list() { return _state_graphic_list ; }

	void draw() ;

	virtual void update(const Subject *subject) ;
	virtual void subject_deleted(Subject *subject) ;

private:
	PageGroup *_parent ;
	Smachine *_machine ;
	StateGraphicList _state_graphic_list ;

private:
	Page& operator =(const Page& page) ; // no assignments
} ;



#endif /* _Page_h_ */
