/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: StateGraphic.h,v $
$Revision: 1.14 $
$Date: 1997/07/02 04:45:19 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: StateGraphic.h,v $
Revision 1.14  1997/07/02 04:45:19  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.13  1997/06/06 04:34:29  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.12  1997/05/31 21:12:44  andrewm
Checkpoint.  Things are working well.

Revision 1.11  1997/02/23 23:44:16  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.10  1997/02/08 04:37:44  andrewm
Checkpoint before returning to work on the GUI portion.

Revision 1.9  1997/01/23 06:20:56  andrewm
Checkpoint as base and graphics classes are operating together.

Revision 1.8  1996/11/27 01:25:54  andrewm
Another checkpoint before I go off and figure out what to do about
the graphical representations so that I'll be able to get some post script
output one of these days.

Revision 1.7  1996/11/14 06:19:54  andrewm
checkpoint

 * Revision 1.6  1996/10/01  04:39:26  andrewm
 * checkpoint and revision
 *
 * Revision 1.5  1996/09/22  01:18:34  andrewm
 * pre-alpha release
 *
 * Revision 1.4  1996/08/18  17:58:13  andrewm
 * checkpoint
 *
 * Revision 1.3  1996/08/05  01:25:56  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/07/27  20:57:09  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/06/26  03:16:15  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _StateGraphic_h_
#define _StateGraphic_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "Observer.h"
#include "DisplayItem.h"
#include "Geom2d.h"

#include <string>
#include <list>

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class Page ;
class State ;
class TransitionGraphic ;
class Transition ;
class MachEvent ;

class StateGraphic :
	public Observer,
	public DisplayItem
{
public:
	typedef list<TransitionGraphic *> TransitionGraphicList ;
	typedef list<TransitionGraphic *>::iterator TransitionGraphicListIter ;
	typedef list<TransitionGraphic *>::const_iterator
		TransitionGraphicListConstIter ;

public:
	StateGraphic(Page *parent, State *state) ;
	~StateGraphic() ;

	Page *parent() { return _parent ; }
	void orphan() { _parent = NULL ; }
	State *state() const { return _state ; }

	TransitionGraphic *find_transition_graphic(Transition *transition) const ;
	TransitionGraphic *find_transition_graphic(MachEvent *event) const ;
	void remove_transition_graphic(TransitionGraphic *transition_graphic) ;
	TransitionGraphicList& transition_graphic_list() {
		return _transition_graphic_list ; }

	virtual void update(const Subject *subject) ;
	virtual void subject_deleted(Subject *subject) ;

	virtual void draw() ;
	virtual void highlight() ;

private:
	Page *_parent ;
	State *_state ;
	Circle _circle ;
	string _name ;
	bool _selected ;
	bool _is_initial_state ;
	TransitionGraphicList _transition_graphic_list ;

private:
	void draw_state_graphic() ;
	StateGraphic& operator =(const StateGraphic& sg) ; // no assignments
} ;



#endif /* _StateGraphic_h_ */
