/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: XGraphicRenderer.h,v $
$Revision: 1.7 $
$Date: 1997/07/02 04:45:21 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: XGraphicRenderer.h,v $
Revision 1.7  1997/07/02 04:45:21  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.6  1997/06/21 02:21:35  andrewm
Checkpoint.  PostScript generator going well. A lot of small tweeks
all over to accomplish this.

Revision 1.5  1997/06/15 00:43:58  andrewm
Another checkpoint.  Reworked the way text is specfied to be drawn
for the benefit of the post script renderer.

Revision 1.4  1997/03/18 06:51:05  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

Revision 1.3  1997/03/12 03:13:09  andrewm
Checkpoint.  Things are working rather well.

Revision 1.2  1997/02/23 23:44:17  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.1  1997/01/23 06:20:57  andrewm
Checkpoint as base and graphics classes are operating together.

 *--
 */
#ifndef _XGraphicRenderer_h_
#define _XGraphicRenderer_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "GraphicRenderer.h"
#include <Xm/Xm.h>

/*
MACRO DEFINITIONS
*/

/*
CLASS REFERENCES
*/

/*
CLASS DEFINITIONS
*/
struct XPoint ;


class XGraphicRenderer :
	public GraphicRenderer
{
public:
	XGraphicRenderer() ;
	virtual ~XGraphicRenderer() ;

	void set_context(Widget widget, XmRenderTable rt) ;
	void realize_context() ;

	virtual Point scale_to_mm(const Point& point) ;
	virtual void circle(const Circle& circle) ;
	virtual void circular_arc(const Circle& circle, float start, float extent) ;
	virtual void rect(const Rectangle& rectangle) ;
	virtual void fillrect(const Rectangle& rectangle) ;
	virtual void line(const Point& begin_pt, const Point& end_pt) ;
	virtual void lines(const PointList& points) ;
	virtual void fillpolygon(const PointList& points) ;
	virtual void text(const string& text, const Point& location,
		TextOrigin origin) ;
	virtual Point text_extent(const string& text) ;
	virtual float line_width() ;
	virtual LineDrawingStyle line_style(LineDrawingStyle new_style) ;
	virtual void clear() ;

	virtual void clear_clip() ;
	virtual void add_rectangle_to_clip(const Rectangle& rect) ;
	virtual void set_clip() ;

private:
	Widget _widget ;
	Display *_display ;
	Screen *_screen ;
	Window _window ;
	GC _gc ;
	GC _clear_gc ;
	XmRenderTable _render ;
	int _width ;
	int _height ;
	Region _expose_region ;
	float _width_pixel_per_mm ;
	float _height_pixel_per_mm ;

private:
	Point scale_to_pixels(const Point& point) ;
	Circle scale_to_pixels(const Circle& circle) ;
	Rectangle scale_to_pixels(const Rectangle& rectangle) ;
	Point X_text_extent(const string& text) ;
	XPoint *cnv_points(const PointList& points) ;

private:
	static const int _arc_scale_factor = 64 ;
} ;


#endif /* _XGraphicRenderer_h_ */
