/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: CcCodeVisitor.cc,v $
$Revision: 1.8 $
$Date: 1997/07/02 04:45:21 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: CcCodeVisitor.cc,v $
Revision 1.8  1997/07/02 04:45:21  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.7  1997/02/08 04:37:44  andrewm
Checkpoint before returning to work on the GUI portion.

Revision 1.6  1997/01/12 02:17:46  andrewm
Changed the compiler so that state machine is defined as nested
classes in order to prevent polluting the global class name space.

Revision 1.5  1996/12/27 02:11:01  andrewm
Checkpoint before attempting to restructure the compiler to generate
nested class declarations.

Revision 1.4  1996/12/26 05:55:26  andrewm
Checkpoint, the compiler is working again.

Revision 1.3  1996/11/17 21:50:54  andrewm
Converting to the new version of g++ (2.7.2) and now everything
is under CVS.

Revision 1.2  1996/10/01 04:39:38  andrewm
checkpoint and revision

// Revision 1.1  1996/09/22  01:18:50  andrewm
// pre-alpha release
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <errno.h>

#include "CcCodeVisitor.h"
#include "MachineGroup.h"
#include "Smachine.h"
#include "StateClassDefVisitor.h"
#include "StateDefVisitor.h"
#include "MachineDefVisitor.h"
#include "EventDefVisitor.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: CcCodeVisitor.cc,v $ $Revision: 1.8 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

CcCodeVisitor::
CcCodeVisitor(
	const string& sourcefile,
	const string& codefile,
	bool line_directives) :
		_filename(sourcefile),
		_codefile(ofstream(codefile.c_str())),
		_line_directives(line_directives)
{
	if (!_codefile)
	{
		cerr
			<< "Cannot open \"" << codefile << "\" for output: "
			<< strerror(errno) << endl ;
	}
}

void CcCodeVisitor::
visit(
	MachineGroup *group)
{
	size_t dot = _filename.find_last_of('.') ;
	string headerfilename(_filename.substr(0, dot) + ".h") ;

	_codefile <<
		"//This file is automatically generated and should not be edited.\n"
		"#ifdef __GNUG__\n"
		"#\tpragma implementation\n"
		"#endif /* __GNUG__ */\n"
		"#include \"" << headerfilename << "\"" << endl ;

	_codefile << "// Group Prolog for " << _filename << endl ;
	const ChioTerm& prolog_string(group->group_prolog()) ;
	int prolog_line_no = prolog_string.lineno() ;
	if (_line_directives && prolog_line_no > 0)
		_codefile <<
			"#\tline " << prolog_line_no << " \"" << _filename << '"' << endl ;
	_codefile << (const string&)prolog_string << endl ;

	MachineVisitor::visit(group) ;

	_codefile << "// Epilog for " << _filename << endl ;
	const ChioTerm& epilog_string(group->group_epilog()) ;
	int epilog_line_no = epilog_string.lineno() ;
	if (_line_directives && epilog_line_no > 0)
		_codefile <<
			"#\tline " << epilog_line_no << " \"" << _filename << '"' << endl ;
	_codefile << (const string&)epilog_string << endl ;
}

void CcCodeVisitor::
visit(
	Smachine *machine)
{
	StateClassDefVisitor scdv(_filename, _codefile, _line_directives) ;
	machine->accept_visitor(scdv) ;

	StateDefVisitor sdv(_filename, _codefile, _line_directives) ;
	machine->accept_visitor(sdv) ;

	MachineDefVisitor mdv(_codefile) ;
	machine->accept_visitor(mdv) ;

	EventDefVisitor edv(_codefile) ;
	machine->accept_visitor(edv) ;
}
