/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: DotVisitor.cc,v $
$Revision: 1.5 $
$Date: 1997/07/02 04:45:21 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: DotVisitor.cc,v $
Revision 1.5  1997/07/02 04:45:21  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.4  1997/05/20 05:15:36  andrewm
Checkpoint.  Improved the structure of the "State" class and this
had quite some ripple effects.  However, now there is an abstract
class "State" with two concrete classes "PseudoState" to represent
error and ignore and "RealState" to represent the user specified
states.  Also improved the text display of event names on the transitions.

Revision 1.3  1997/05/15 04:14:47  andrewm
Checkpoint.  Reworked the low level file format stuff to contain
proper lists rather than maps keyed to binary numbers.
This point represents the entire program working with this file format
change.

Revision 1.2  1996/12/26 05:55:27  andrewm
Checkpoint, the compiler is working again.

Revision 1.1  1996/09/22 01:18:50  andrewm
pre-alpha release

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "DotVisitor.h"
#include "MachineGroup.h"
#include "Smachine.h"
#include "MachEvent.h"
#include "State.h"
#include "Transition.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: DotVisitor.cc,v $ $Revision: 1.5 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

void DotVisitor::
visit(
	Smachine *machine)
{
	_stream
		<< "digraph "
		<< machine->name().var_name()
		<< " {"
		<< endl ;

	ChioMap& file_map = machine->parent()->file_map() ;
	ChioMapIter found = file_map.find(_dot_options_name) ;
	if (found != file_map.end())
	{
		ChioMap& options_map = (*found).second ;
			// graph options here
		found = options_map.find(_graph_name) ;
		if (found != options_map.end())
		{
			ChioMap& graph_map = (*found).second ;
			for (ChioMapIter g_iter = graph_map.begin() ;
				g_iter != graph_map.end() ; ++g_iter)
			{
				const ChioTerm& s = (*g_iter).second ;
				_stream << '\t' << (const string&)s << ';' << endl ;
			}
		}
			// node options here
		found = options_map.find(_node_name) ;
		if (found != options_map.end())
		{
			ChioMap& node_map = (*found).second ;
			for (ChioMapIter n_iter = node_map.begin() ;
				n_iter != node_map.end() ; ++n_iter)
			{
				const ChioTerm& s = (*n_iter).second ;
				_stream << "\tnode [" << (const string&)s << "];" << endl ;
			}
		}
			// edge options here
		found = options_map.find(_edge_name) ;
		if (found != options_map.end())
		{
			ChioMap& edge_map = (*found).second ;
			for (ChioMapIter e_iter = edge_map.begin() ;
				e_iter != edge_map.end() ; ++e_iter)
			{
				const ChioTerm& s = (*e_iter).second ;
				_stream << "\tedge [" << (const string&)s << "];" << endl ;
			}
		}
	}

	MachineVisitor::visit(machine) ;

	_stream
		<< "}"
		<< endl ;
}

void DotVisitor::
visit(
	State *state)
{
	_stream
		<< "\t"
		<< state->name()
		<< " ["
		<< endl
		<< "\t\tlabel = "
		<< state->name()
		<< endl ;

	// other dot attributes could go here

	_stream
		<< "\t] ;"
		<< endl ;

	MachineVisitor::visit(state) ;
}

void DotVisitor::
visit(
	Transition *transition)
{
	State *source = transition->source() ;
	State *destination = transition->destination() ;
	if (!destination->is_pseudo_state())
	{
		_stream
			<< "\t"
			<< source->name()
			<< " -> "
			<< destination->name()
			<< " ["
			<< endl
			<< "\t\tlabel = "
			<< transition->event()->name()
			<< endl
			<< "\t] ;"
			<< endl ;
	}
}
