/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: EventDeclVisitor.cc,v $
$Revision: 1.8 $
$Date: 1997/07/02 04:45:22 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: EventDeclVisitor.cc,v $
Revision 1.8  1997/07/02 04:45:22  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.7  1997/07/01 03:54:34  andrewm
Changes in the way code is generated.  Now there is an initial event
function that must be called after construction but before any
other events are triggered.  This is to help integration of generated
classes into a class hierarchy.

Revision 1.6  1997/05/20 05:15:36  andrewm
Checkpoint.  Improved the structure of the "State" class and this
had quite some ripple effects.  However, now there is an abstract
class "State" with two concrete classes "PseudoState" to represent
error and ignore and "RealState" to represent the user specified
states.  Also improved the text display of event names on the transitions.

Revision 1.5  1997/05/15 04:14:47  andrewm
Checkpoint.  Reworked the low level file format stuff to contain
proper lists rather than maps keyed to binary numbers.
This point represents the entire program working with this file format
change.

Revision 1.4  1997/01/12 02:17:46  andrewm
Changed the compiler so that state machine is defined as nested
classes in order to prevent polluting the global class name space.

Revision 1.3  1996/12/27 02:11:01  andrewm
Checkpoint before attempting to restructure the compiler to generate
nested class declarations.

Revision 1.2  1996/12/26 05:55:27  andrewm
Checkpoint, the compiler is working again.

Revision 1.1  1996/09/22 01:18:50  andrewm
pre-alpha release

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "EventDeclVisitor.h"
#include "MachineGroup.h"
#include "Smachine.h"
#include "MachEvent.h"
#include "State.h"
#include "Transition.h"
#include "Parameter.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: EventDeclVisitor.cc,v $ $Revision: 1.8 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

EventDeclVisitor::
EventDeclVisitor(
	ostream& stream) :
		_headerfile(stream)
{
}

void EventDeclVisitor::
visit(
	Smachine *machine)
{
	_prefix_name = machine->name().var_name() ;
	string event_class = _prefix_name + "_Event" ;

	_headerfile << "\n\t// Event declarations for " << _prefix_name << endl ;

	_headerfile <<
		"\tclass " << event_class << endl <<
		"\t{\n" <<
		"\tpublic:\n"
			"\t\tvirtual const char *name() const = 0 ;\n"
			"\t\tvirtual void transition(" <<
				_prefix_name << "& machine) const = 0 ;\n"
			"\t\tfriend ostream& operator <<(ostream& s, " <<
				"const " << event_class << "& event) ;\n"
		"\t} ;" << endl ;

	State *initial_state = machine->initial_state() ;
	if (initial_state)
	{
		string class_name(_prefix_name + "_InitialEvent") ;
		_headerfile <<
			"\tclass " << class_name << " :\n"
				"\t\tpublic " << _prefix_name << "_Event\n"
			"\t{\n"
			"\tpublic:\n"
				"\t\t" << class_name << '(' ;

		const char *leader = "" ;
		const State::ParameterList& param_list =
			initial_state->parameter_list() ;
		for (State::ParameterListConstIter param_iter = param_list.begin() ;
			param_iter != param_list.end() ; param_iter++)
		{
			Parameter *parameter = *param_iter ;
			_headerfile << leader << (const string&)parameter->type() <<
				' ' << (const string&)parameter->name() ;
			leader = ", " ;
		}
		_headerfile << ')' ;
		leader = " : " ;
		for (State::ParameterListConstIter param_iter = param_list.begin() ;
			param_iter != param_list.end() ; param_iter++)
		{
			Parameter *parameter = *param_iter ;
			_headerfile << leader << '_' << (const string&)parameter->name() <<
				'(' << (const string&)parameter->name() << ')' ;
			leader = ", " ;
		}
		_headerfile <<
				" {}\n"
				"\t\tvirtual const char *name() const "
					"{ return \"initial_event\" ; }\n"
				"\t\tvirtual void transition(" <<
					_prefix_name << "& machine) const ;\n"
			"\n\tprivate:\n" ;
		for (State::ParameterListConstIter param_iter = param_list.begin() ;
			param_iter != param_list.end() ; param_iter++)
		{
			Parameter *param = *param_iter ;
			param->accept_visitor(*this) ;
		}
		_headerfile <<
			"\t} ;" << endl ;
	}

	Smachine::MachEventList& event_list = machine->event_list() ;
	for (Smachine::MachEventListIter event_iter = event_list.begin() ;
		event_iter != event_list.end() ; event_iter++)
	{
		MachEvent *ev = *event_iter ;
		ev->accept_visitor(*this) ;
	}
}

void EventDeclVisitor::
visit(
	MachEvent *event)
{
	string event_name = event->name().var_name() ;
	string event_class = _prefix_name + "_" + event_name + "_Event" ;

	_headerfile <<
		"\tclass " << event_class << " :\n"
			"\t\tpublic " << _prefix_name << "_Event\n"
		"\t{\n"
		"\tpublic:\n"
			"\t\t" << event_class << '(' ;
	const char *leader = "" ;
	MachEvent::ParameterList& param_list = event->parameter_list() ;
	for (MachEvent::ParameterListIter param_iter = param_list.begin() ;
		param_iter != param_list.end() ; param_iter++)
	{
		Parameter *parameter = *param_iter ;
		_headerfile << leader << (const string&)parameter->type() << ' '
			<< (const string&)parameter->name() ;
		leader = ", " ;
	}
	_headerfile << ')' ;
	leader = " : " ;
	for (MachEvent::ParameterListIter param_iter = param_list.begin() ;
		param_iter != param_list.end() ; param_iter++)
	{
		Parameter *parameter = *param_iter ;
		_headerfile << leader << '_' << (const string&)parameter->name() <<
			'(' << (const string&)parameter->name() << ')' ;
		leader = ", " ;
	}
	_headerfile <<
			" {}\n"
			"\t\tvirtual const char *name() const { return \"" <<
				event->name().var_name() << "\" ; }\n"
			"\t\tvirtual void transition(" <<
				_prefix_name << "& machine) const ;\n"
		"\n\tprivate:\n" ;
	for (MachEvent::ParameterListIter param_iter = param_list.begin() ;
		param_iter != param_list.end() ; param_iter++)
	{
		Parameter *param = *param_iter ;
		param->accept_visitor(*this) ;
	}
	_headerfile <<
		"\t} ;" << endl ;
}

void EventDeclVisitor::
visit(
	Parameter *parameter)
{
	_headerfile << 
		"\t\t" << (const string&)parameter->type() << " _"
		<< (const string &)parameter->name() << " ;" << endl ;
}
