/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: MachineDeclVisitor.cc,v $
$Revision: 1.9 $
$Date: 1997/07/02 04:45:23 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MachineDeclVisitor.cc,v $
Revision 1.9  1997/07/02 04:45:23  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.8  1997/07/01 03:54:34  andrewm
Changes in the way code is generated.  Now there is an initial event
function that must be called after construction but before any
other events are triggered.  This is to help integration of generated
classes into a class hierarchy.

Revision 1.7  1997/05/20 05:15:36  andrewm
Checkpoint.  Improved the structure of the "State" class and this
had quite some ripple effects.  However, now there is an abstract
class "State" with two concrete classes "PseudoState" to represent
error and ignore and "RealState" to represent the user specified
states.  Also improved the text display of event names on the transitions.

Revision 1.6  1997/05/15 04:14:48  andrewm
Checkpoint.  Reworked the low level file format stuff to contain
proper lists rather than maps keyed to binary numbers.
This point represents the entire program working with this file format
change.

Revision 1.5  1997/02/08 04:37:44  andrewm
Checkpoint before returning to work on the GUI portion.

Revision 1.4  1997/01/12 02:17:47  andrewm
Changed the compiler so that state machine is defined as nested
classes in order to prevent polluting the global class name space.

Revision 1.3  1996/12/27 02:11:02  andrewm
Checkpoint before attempting to restructure the compiler to generate
nested class declarations.

Revision 1.2  1996/12/26 05:55:28  andrewm
Checkpoint, the compiler is working again.

Revision 1.1  1996/09/22 01:18:50  andrewm
pre-alpha release

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "MachineDeclVisitor.h"
#include "MachineGroup.h"
#include "Smachine.h"
#include "MachEvent.h"
#include "State.h"
#include "Parameter.h"
#include "ForwardRefVisitor.h"
#include "StateClassDeclVisitor.h"
#include "StateDeclVisitor.h"
#include "EventDeclVisitor.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: MachineDeclVisitor.cc,v $ $Revision: 1.9 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

MachineDeclVisitor::
MachineDeclVisitor(
	ostream& stream) :
		_headerfile(stream),
		_first_param(false)
{
}

void MachineDeclVisitor::
visit(
	Smachine *machine)
{
	_prefix_name = machine->name().var_name() ;
	string state_class(_prefix_name + "_State") ;
	string event_class(_prefix_name + "_Event") ;

	_headerfile << "// State Machine declaration for " << _prefix_name << endl ;
	_headerfile <<
		"class " << _prefix_name <<
		"\n{" << endl ;

	_headerfile <<
		"\t// Prolog for " << _prefix_name << endl ;
	const ChioTerm& prolog_string(machine->prolog()) ;
	_headerfile << (const string&)prolog_string << endl ;

	_headerfile <<
			"\t// Forward References for " << _prefix_name << endl <<
			"\tclass " << state_class << " ;\n"
			"\tclass " << event_class << " ;\n"
		"\npublic:\n\t"
			<< _prefix_name << "(bool log = false) ;" << endl ;

	State *initial_state = machine->initial_state() ;
	if (initial_state)
	{
		_headerfile << "\tvoid initial_event(" ;
		const State::ParameterList& param_list =
			initial_state->parameter_list() ;
		_first_param = true ;
		for (State::ParameterListConstIter param_iter = param_list.begin() ;
			param_iter != param_list.end() ; param_iter++)
		{
			Parameter *param = *param_iter ;
			param->accept_visitor(*this) ;
		}
		_headerfile << ") ;" << endl ;
	}

	Smachine::MachEventList& event_list = machine->event_list() ;
	for (Smachine::MachEventListIter event_iter = event_list.begin() ;
		event_iter != event_list.end() ; event_iter++)
	{
		MachEvent *ev = *event_iter ;
		ev->accept_visitor(*this) ;
	}

	_headerfile <<
			"\n\tbool log() const { return _log_transition ; }\n"
			"\tvoid log(bool new_log) { _log_transition = new_log ; }\n" <<
			'\t' << state_class << " *current_state() const "
				"{ return _current_state ; }\n"

		"\nprivate:\n" <<
			'\t' << state_class << " *_current_state ;\n" <<
			'\t' << event_class << " *_current_event ;\n"
			"\tbool _in_transition ;\n"
			"\tbool _log_transition ;\n"
			"\tvoid trigger(const " << _prefix_name << "_Event& event) ;"
			<< endl ;

	ForwardRefVisitor frv(_headerfile) ;
	machine->accept_visitor(frv) ;

	StateClassDeclVisitor scdv(_headerfile) ;
	machine->accept_visitor(scdv) ;

	_headerfile <<
		"\n\tfriend void " << state_class << "::set_state("
			<< _prefix_name << "& machine, " <<
				state_class << " *state) ;" << endl ;

	StateDeclVisitor sdv(_headerfile) ;
	machine->accept_visitor(sdv) ;

	EventDeclVisitor edv(_headerfile) ;
	machine->accept_visitor(edv) ;

	_headerfile <<
		"\t// Epilog for " << _prefix_name << endl ;
	const ChioTerm& epilog_string(machine->epilog()) ;
	_headerfile << (const string&)epilog_string << endl ;

	_headerfile <<
		"} ;" << endl ;

	_headerfile <<
		"\ninline void " << _prefix_name << "::" << state_class << "::\n"
		"set_state(\n" <<
			'\t' << _prefix_name << "& machine,\n" <<
			'\t' << state_class << " *state)\n"
		"{\n"
			"\tmachine._current_state = state ;\n"
		"}" << endl ;
}

void MachineDeclVisitor::
visit(
	MachEvent *event)
{
	string event_name = event->name().var_name() ;

	_headerfile <<
		"\tvoid " << event_name << '(' ;

	_first_param = true ;
	MachEvent::ParameterList& param_list = event->parameter_list() ;
	for (MachEvent::ParameterListIter param_iter = param_list.begin() ;
		param_iter != param_list.end() ; param_iter++)
	{
		Parameter *param = *param_iter ;
		param->accept_visitor(*this) ;
	}

	_headerfile <<
		") ;" << endl ;
}

void MachineDeclVisitor::
visit(
	Parameter *parameter)
{
	_headerfile << (_first_param ? (_first_param = false, "") : ", ")
		<< (const string&)parameter->type() << ' '
		<< (const string&)parameter->name() ;
}
