/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: StateCheckVisitor.cc,v $
$Revision: 1.5 $
$Date: 1997/07/02 04:45:24 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: StateCheckVisitor.cc,v $
Revision 1.5  1997/07/02 04:45:24  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.4  1997/05/20 05:15:37  andrewm
Checkpoint.  Improved the structure of the "State" class and this
had quite some ripple effects.  However, now there is an abstract
class "State" with two concrete classes "PseudoState" to represent
error and ignore and "RealState" to represent the user specified
states.  Also improved the text display of event names on the transitions.

Revision 1.3  1996/12/26 05:55:29  andrewm
Checkpoint, the compiler is working again.

Revision 1.2  1996/10/01 04:39:38  andrewm
checkpoint and revision

// Revision 1.1  1996/09/22  01:18:50  andrewm
// pre-alpha release
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "Smachine.h"
#include "MachEvent.h"
#include "State.h"
#include "Transition.h"
#include "StateCheckVisitor.h"
#include <functional>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: StateCheckVisitor.cc,v $ $Revision: 1.5 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

StateCheckVisitor::
StateCheckVisitor() :
		_egress_count(0)
{
}

StateCheckVisitor::
~StateCheckVisitor()
{
}

void StateCheckVisitor::
visit(
	Smachine *machine)
{
	if (machine->initial_state() == NULL)
		_lacks_initial_state.push_back(machine) ;
	MachineVisitor::visit(machine) ;
}

void StateCheckVisitor::
visit(
	State *state)
{
	_egress_count = 0 ;
	MachineVisitor::visit(state) ;
	if (_egress_count == 0 && state->parent()->terminal_state() != state)
		_egress.push_back(state) ;

	int ingress_count = 0 ;
	Smachine::StateList& state_list = state->parent()->state_list() ;
	for (Smachine::StateListIter st_iter = state_list.begin() ;
		st_iter != state_list.end() ; st_iter++)
	{
		State *st = *st_iter ;
		if (st != state)
		{
			const State::TransitionList& trans_list = st->transition_list() ;
			for (State::TransitionListConstIter tr_iter = trans_list.begin() ;
				tr_iter != trans_list.end() ; tr_iter++)
			{
				Transition *tr = *tr_iter ;
				if (tr->destination() == state)
					ingress_count++ ;
			}
		}
	}
	if (ingress_count == 0 && state->parent()->initial_state() != state)
		_ingress.push_back(state) ;
}

void StateCheckVisitor::
visit(
	Transition *transition)
{
	State *destination = transition->destination() ;
	if (!destination->is_pseudo_state() && destination != transition->source())
	{
		_egress_count++ ;
	}
}

StateCheckVisitor::
discrepancies()
{
	return _lacks_initial_state.size() + _ingress.size() + _egress.size() ;
}

ostream&
operator <<(
	ostream& s,
	StateCheckVisitor& scv)
{
	for (StateCheckVisitor::SmachineVector::iterator sm_iter =
		scv._lacks_initial_state.begin() ;
		sm_iter != scv._lacks_initial_state.end() ; ++sm_iter)
	{
		s << **sm_iter << " (Machine) has no defined initial state." << endl ;
	}

	for (StateCheckVisitor::StateVector::iterator s_iter =
		scv._ingress.begin() ;
		s_iter != scv._ingress.end() ; ++s_iter)
	{
		s << **s_iter << " (State) has no incoming events." << endl ;
	}

	for (StateCheckVisitor::StateVector::iterator s_iter =
		scv._egress.begin() ;
		s_iter != scv._egress.end() ; ++s_iter)
	{
		s << **s_iter << " (State) has no outgoing events." << endl ;
	}

	return s ;
}
