/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: StateCheckVisitor.h,v $
$Revision: 1.4 $
$Date: 1997/07/02 04:45:24 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: StateCheckVisitor.h,v $
Revision 1.4  1997/07/02 04:45:24  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.3  1996/12/26 05:55:29  andrewm
Checkpoint, the compiler is working again.

Revision 1.2  1996/10/01 04:39:38  andrewm
checkpoint and revision

 * Revision 1.1  1996/09/22  01:18:50  andrewm
 * pre-alpha release
 *
 *--
 */
#ifndef _StateCheckVisitor_h_
#define _StateCheckVisitor_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <iostream.h>
#include <vector>

#include "MachineVisitor.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class StateCheckVisitor :
	public MachineVisitor
{
	friend ostream& operator <<(ostream&s, StateCheckVisitor& scv) ;

public:
	StateCheckVisitor() ;
	~StateCheckVisitor() ;

	virtual void visit(Smachine *machine) ;
	virtual void visit(State *state) ;
	virtual void visit(Transition *transition) ;

	int discrepancies() ;

private:
	typedef vector<Smachine *> SmachineVector ;
	typedef vector<State *> StateVector ;

	SmachineVector _lacks_initial_state ;
	StateVector _ingress ;
	StateVector _egress ;
	int _egress_count ;

private:
	StateCheckVisitor& operator =(const StateCheckVisitor&) ;
} ;


#endif /* _StateCheckVisitor_h_ */
