/*
 *  @(#) fdm.c
 *  @(#) Copyright (C) 2001 Tyler Pierce (tyler@alumni.brown.edu)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/time.h>
#include <time.h>
#include <math.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xresource.h>

#define degs 360
#define degs2 (degs/2)
#define degs4 (degs/4)
#define degs8 (degs/8)
#define dtor 0.0174532925	/*  pi / degs2; */
#define thrmax 120
#define tailmax (thrmax * 2 + 1)
#define tmodes '7'
#define ymax (hei - 1)
#define ymin 0
#define xmax (wid - 1)
#define xmin 0
#define rlmax 200

/* Feb 2001: */
#define arrcpy(DEST,SRC) memcpy (DEST, SRC, sizeof(DEST))

typedef double real;
typedef unsigned char banktype[thrmax];

class linedata
{
private:
  int deg, spiturn, turnco, turnsize;
  unsigned char col;
  bool dead;

public:
  char orichar;
  real x, y;
  int tmode, tsc, tslen, tclim, otslen, ctinc, reclen, recpos, circturn, prey,
    slice;
  int xrec[rlmax + 1], yrec[rlmax + 1];
  int turnseq[50];
  bool filled, killwalls, vhfollow,
    selfbounce, tailfollow, realbounce, little;

  bool move (unsigned char thr);
  void firstinit (unsigned char thr);
  void newonscreen ();
};

Display *mydpy;
Window mywindow;
GC mygc;
XEvent myevent;
Colormap mycmap;
bool neednewkey = true;
XColor mycolors[tailmax];

int hei = 500, wid = 500, waitfreecycles = 50, use_root = 0;
bool erasing = true;
char *instring = "c2#f3#yet";

unsigned char rgb[256][3];
real sinof[degs], cosof[degs], tanof[degs];
unsigned char *point;

linedata thread[thrmax];
banktype bank;
int bankt, boxw, boxh, curviness, gridden, ogd, bordcorn;
unsigned char bordcol, threads;
char ch, boolop;

bool
wasakeypressed ()
{
  if ((!neednewkey) || (*instring != 0))
    return true;
  else
    return !(neednewkey =
	     !XCheckWindowEvent (mydpy, mywindow, KeyPressMask, &myevent));
}

char
readkey ()
{
  char readkey_result;
  if (*instring == 0)
    {
      char key_buffer[1];
      KeySym key_sym;
      if (neednewkey)
	XWindowEvent (mydpy, mywindow, KeyPressMask, &myevent);
      XLookupString (&myevent.xkey, key_buffer, 1, &key_sym, NULL);
      neednewkey = true;
      readkey_result = key_sym;
    }
  else
    {
      readkey_result = *instring;
      instring++;
    };
  return toupper (readkey_result);
}

int
random1 (int i)
{
  return (rand () % i);
}

void
waitabit (int x)
{
  static int cyc = 0;
  if (++cyc > x)
    {
      static struct timespec req;
      static struct timespec rem;
      req.tv_sec = 0;
      req.tv_nsec = 100000;
      while (nanosleep (&req, &rem) != 0)
	req = rem;
      cyc = 0;
    }
}

void
clearscreen ()
{
  XClearWindow (mydpy, mywindow);
  memset (point, 0, (wid + 1) * hei);
}

void
sp (int y, int x, int c)
{
  XSetForeground (mydpy, mygc, mycolors[c].pixel);
  XDrawPoint (mydpy, mywindow, mygc, x, y);
  point[(wid * y) + x] = c;
}

int
gp (int y, int x)
{
  int gp_result;
  gp_result = (point[(wid * y) + x]);
  return gp_result;
}

void
redraw (int x, int y, int width, int height)
{
  for (int co = x; co <= x + width - 1; co++)
    for (int ro = y; ro <= y + height - 1; ro++)
      if (point[wid * ro + co] != 0)
	sp (ro, co, point[wid * ro + co]);
}

void
palupdate ()
{
  int colnum;
  for (colnum = 0; colnum < tailmax; colnum++)
    {
      mycolors[colnum].red = (rgb[colnum][0] << 10);
      mycolors[colnum].green = (rgb[colnum][1] << 10);
      mycolors[colnum].blue = (rgb[colnum][2] << 10);
      mycolors[colnum].flags = DoRed | DoBlue | DoGreen;
      XAllocColor (mydpy, mycmap, &mycolors[colnum]);
    };

/* Redraw, but not if we're just processing instring: */
  if (*instring == 0)
    redraw (xmin, ymin, wid, hei);
}

void
randpal ()
{
  for (int co = 1; co <= 255; co++)
    for (int ro = 0; ro <= 2; ro++)
      if (co > tailmax)
	rgb[co][ro] = random1 (20);
      else
	rgb[co][ro] = random1 (64);
  for (int ro = 0; ro <= 2; ro++)
    rgb[0][ro] = 0;
}

void
gridupdate (bool interruptible)
{
  if (gridden > 0)
    for (int x = 0; x <= xmax && !(wasakeypressed () && interruptible);
	 x += boxw)
      for (int y = 0; y <= ymax; y += boxh)
	{
	  if (random1 (15) < gridden)
	    {
#define lesser(A,B) ( ((A)<(B)) ? (A) : (B) )
	      int max = lesser (x + boxw, xmax);
	      for (int co = x; co <= max; co++)
		sp (y, co, 1);
	    }
	  if (random1 (15) < gridden)
	    {
	      int max = lesser (y + boxh, ymax);
	      for (int ro = y; ro <= max; ro++)
		sp (ro, x, 1);
	    }
	}
}

void
bordupdate ()
{
  int xbord, ybord;

  if ((bordcorn == 0) || (bordcorn == 1))
    ybord = ymin;
  else
    ybord = ymax;
  if ((bordcorn == 0) || (bordcorn == 3))
    xbord = xmin;
  else
    xbord = xmax;
  for (int co = xmin; co <= xmax; co++)
    sp (ybord, co, bordcol);
  for (int ro = ymin; ro <= ymax; ro++)
    sp (ro, xbord, bordcol);
}

bool
inbank (unsigned char thr)
{
  if (bankt > 0)
    for (int co = 1; co <= bankt; co++)
      if (bank[co - 1] == thr)
	return true;
  return false;
}

void
pickbank ()
{
  unsigned char orgb[256][3];

  arrcpy (orgb, rgb);
  for (int co = 2; co <= tailmax; co++)
    for (int ro = 0; ro <= 2; ro++)
      rgb[co][ro] = 25;
  bankt = 0;
  unsigned char thr = 1;
  ch = '\0';
  do
    {
      while (inbank (thr))
	thr = thr % threads + 1;
      for (int co = 1; co <= threads; co++)
	{
	  for (int ro = 0; ro <= 2; ro++)
	    rgb[co + 1][ro] = 25;
	  if (inbank (co))
	    for (int ro = 0; ro <= 1; ro++)
	      rgb[co + 1][ro] = 60;
	}
      for (int ro = 0; ro <= 2; ro++)
	rgb[thr + 1][ro] = 60;
      palupdate ();
      ch = readkey ();
      palupdate ();
      switch (ch)
	{
	case '+':
	  do
	    {
	      thr = thr % threads + 1;
	    }
	  while (inbank (thr));
	  break;
	case '-':
	  do
	    {
	      thr = (thr % threads - 2 + threads) % threads + 1;
	    }
	  while (inbank (thr));
	  break;
	case ' ':
	  bank[++bankt - 1] = thr;
	  break;
	case '1'...'9':
	  bank[++bankt - 1] = ch - '0';
	  if (bank[bankt - 1] > threads)
	    bankt--;
	  break;
	case 'I':
	  {
	    banktype tbank;
	    int tbankt = 0;
	    for (int co = 1; co <= threads; co++)
	      if (!inbank (co))
		{
		  tbankt++;
		  tbank[tbankt - 1] = co;
		}
	    bankt = tbankt;
	    arrcpy (bank, tbank);
	  }
	  break;
	case 'T':
	  ch = readkey ();
	  switch (ch)
	    {
	    case '1'...tmodes:
	      for (int co = 1; co <= threads; co++)
		if (thread[co - 1].tmode == ch - '0')
		  {
		    bank[++bankt - 1] = co;
		  }
	      break;
	    }
	  break;
	case 'A':
	  for (bankt = 1; bankt <= threads; bankt++)
	    bank[bankt - 1] = bankt;
	  bankt = threads;
	  break;
	case 'E':
	  for (bankt = 1; bankt <= thrmax; bankt++)
	    bank[bankt - 1] = bankt;
	  bankt = thrmax;
	  break;
	}
    }
  while (!((ch == 'N') || (bankt >= threads) || (ch == '\15')
/* Added to make command line easier: */
	   || (ch == '#')));
  if ((bankt == 0) && (ch != 'N'))
    {
      bankt = 1;
      bank[0] = thr;
    }
  arrcpy (rgb, orgb);
  palupdate ();
}

void
bankmod (bool * bool_)
{
  switch (boolop)
    {
    case 'T':
      *bool_ = !*bool_;
      break;
    case 'Y':
      *bool_ = true;
      break;
    case 'N':
      *bool_ = false;
      break;
    }
}

void
linedata::newonscreen ()
{
  filled = false;
  dead = false;
  if (little)
    reclen = random1 (10) + 5;
  else
    reclen = random1 (rlmax - 30) + 30;
  deg = random1 (degs);
  y = random1 (hei);
  x = random1 (wid);
  recpos = 0;
  turnco = 2;
  turnsize = random1 (4) + 2;
}

void
linedata::firstinit (unsigned char thr)
{
  col = thr + 1;
  prey = 0;
  tmode = 1;
  slice = degs / 3;
  orichar = 'R';
  spiturn = 5;
  selfbounce = false;
  realbounce = false;
  vhfollow = false;
  tailfollow = false;
  killwalls = false;
  little = false;
  ctinc = random1 (2) * 2 - 1;
  circturn = ((thr % 2) * 2 - 1) * ((thr - 1) % 7 + 1);
  tsc = 1;
  tslen = 6;
  turnseq[0] = 6;
  turnseq[1] = -6;
  turnseq[2] = 6;
  turnseq[3] = 6;
  turnseq[4] = -6;
  turnseq[5] = 6;
  tclim = (unsigned char) (((real) degs) / 2 / 12);
}

void
maininit ()
{
  boxh = 10;
  boxw = 10;
  gridden = 0;
  bordcorn = 0;
  threads = 4;
  curviness = 30;
  bordcol = 1;
  ogd = 8;
  ch = '\0';
  for (unsigned char thr = 1; thr <= thrmax; thr++)
    {
      thread[thr - 1].firstinit (thr);
      thread[thr - 1].newonscreen ();
    }
  for (int co = degs - 1; co >= 0; co--)
    {
      sinof[co] = sin (co * dtor);
      cosof[co] = cos (co * dtor);
      if (co % degs4 == 0)
	tanof[co] = tanof[co + 1];
      else
	tanof[co] = tan (co * dtor);
    }
  randpal ();
}

bool
linedata::move (unsigned char thr)
{
  if (dead)
    return (false);
  if (prey == 0)
    switch (tmode)
      {
      case 1:
	deg += random1 (2 * turnsize + 1) - turnsize;
	break;
      case 2:
	if ((slice == degs) || (slice == degs2) || (slice == degs4))
	  {
	    if (orichar == 'D')
	      {
		if (deg % degs4 != degs8)
		  deg = degs4 * random1 (4) + degs8;
	      }
	    else if (orichar == 'V')
	      if (deg % degs4 != 0)
		deg = degs4 * random1 (4);
	  }
	if (random1 (100) == 0)
	  {
	    if (slice == 0)
	      deg = deg - degs4 + random1 (degs2);
	    else
	      deg += (random1 (2) * 2 - 1) * slice;
	  }
	break;
      case 3:
	deg += circturn;
	break;
      case 4:
	if (abs (spiturn) > 11)
	  spiturn = 5;
	else
	  deg += spiturn;
	if (random1 (15 - abs (spiturn)) == 0)
	  {
	    spiturn += ctinc;
	    if (abs (spiturn) > 10)
	      ctinc *= -1;
	  }
	break;
      case 5:
	turnco = abs (turnco) - 1;
	if (turnco == 0)
	  {
	    turnco = curviness + random1 (10);
	    circturn *= -1;
	  }
	deg += circturn;
	break;
      case 6:
	if (abs (turnco) == 1)
	  turnco *= -1 * (random1 (degs2 / abs (circturn)) + 5);
	else if (turnco == 0)
	  turnco = 2;
	else if (turnco > 0)
	  {
	    turnco--;
	    deg += circturn;
	  }
	else
	  turnco++;
	break;
      case 7:
	turnco++;
	if (turnco > tclim)
	  {
	    turnco = 1;
	    tsc = (tsc % tslen) + 1;
	  }
	deg += turnseq[tsc - 1];
	break;
      }
  else
    {
      int desdeg;
      real dy, dx;
      if (tailfollow || (prey == thr))
	{
	  dx = thread[prey - 1].xrec[thread[prey - 1].recpos] - x;
	  dy = thread[prey - 1].yrec[thread[prey - 1].recpos] - y;
	}
      else
	{
	  dx = thread[prey - 1].x - x;
	  dy = thread[prey - 1].y - y;
	}
      desdeg =
	(vhfollow) ?
	((fabs (dx) > fabs (dy)) ?
	 ((dx > 0) ?
	  0 * degs4
	  :
	  2 * degs4)
	 :
	 ((dy > 0) ?
	  1 * degs4
	  :
	  3 * degs4))
	:
	((dx > 0) ?
	 ((dy > 0) ?
	  1 * degs8 : 7 * degs8) : ((dy > 0) ? 3 * degs8 : 5 * degs8));
      if (((desdeg - (desdeg % degs4)) != (deg - (deg % degs4))) || vhfollow)
	{
	  if (abs (desdeg - deg) <= abs (circturn))
	    deg = desdeg;
	  else
	    deg += (desdeg > deg) ?
	      ((desdeg - deg > degs2) ? -abs (circturn) : abs (circturn))
	      : ((deg - desdeg > degs2) ? abs (circturn) : -abs (circturn));
	}
      else
	deg += (tanof[deg] > dy / dx) ? -abs (circturn) : abs (circturn);
    }

#define wraparound(VAL,LIMIT) { 	\
		    if (VAL >= LIMIT)	\
		      VAL -= LIMIT;	\
		    else if (VAL < 0)	\
		      VAL += LIMIT; }
  wraparound (deg, degs);
  {
    unsigned char oldcol;
    real oldy = y, oldx = x;
    x += cosof[deg];
    wraparound (x, wid);
    y += sinof[deg];
    wraparound (y, hei);
#define xi ((int) x)
#define yi ((int) y)

    oldcol = (gp (yi, xi));
    if ((oldcol > 0) && (oldcol <= tailmax))
      {
	bool vertwall, horiwall;
	if ((oldcol == 1) && ((killwalls && (gridden > 0)) || realbounce))
	  {
	    vertwall = (gp ((int) oldy, xi) == 1);
	    horiwall = (gp (yi, (int) oldx) == 1);
	  }
	if ((oldcol == 1) && realbounce && (vertwall || horiwall))
	  {
	    if (vertwall)
	      deg = -deg + degs2;
	    else
	      deg = -deg;
	  }
	else
	  {
	    if (((oldcol != col) && realbounce)
		|| ((oldcol == col) && selfbounce))
	      deg += degs4 * (random1 (2) * 2 - 1);
	    else if (oldcol != col)
	      deg += degs2;
	  }
	if (killwalls && (gridden > 0) && (oldcol == 1))
	  {
	    if (vertwall)
	      {
		for (int ro = yi - yi % boxh;
		     ro <= yi - yi % boxh + boxh; ro++)
		  if ((ro < hei)
		      /* TYLER: NOTE the following gp can segfault! */
		      && ((gp (ro, xi + 1) != 1) || (ro == ymax)))
		    sp (ro, xi, 0);
	      }
	    if (horiwall)
	      {
		for (int co = xi - xi % boxw;
		     co <= xi - xi % boxw + boxw; co++)
		  if ((co < wid)
		      /* TYLER: NOTE the following gp can segfault! */
		      && ((gp (yi + 1, co) != 1) || (co == xmax)))
		    sp (yi, co, 0);
	      }
	  }
	if ((oldcol != col) || selfbounce)
	  {
	    x = oldx;
	    y = oldy;
	  }
	wraparound (deg, degs);
      }
  }

  sp (yi, xi, col);
  if (filled)
    {
      if (erasing)
	sp (yrec[recpos], xrec[recpos], 0);
      else
	sp (yrec[recpos], xrec[recpos], col + thrmax);
    }
  yrec[recpos] = yi;
  xrec[recpos] = xi;
  if (recpos == reclen - 1)
    filled = true;
  if (filled && !erasing)
    {
      int co;
      co = recpos;
      dead = true;
      do
	{
	  int nextco = co + 1;
	  if (nextco == reclen)
	    nextco = 0;
	  if ((yrec[co] != yrec[nextco]) || (xrec[co] != xrec[nextco]))
	    dead = false;
	  co = nextco;
	}
      while (!((!dead) || (co == recpos)));
    }
  recpos++;
  if (recpos == reclen)
    recpos = 0;
  return (!dead);
}

void
fdm_main ()
{
  bool halted = false, autopal = false;
  maininit ();
  palupdate ();

  do
    {
      clearscreen ();
      for (unsigned char thr = 1; thr <= threads; thr++)
	thread[thr - 1].newonscreen ();
      if (autopal)
	{
	  randpal ();
	  palupdate ();
	}
      bordupdate ();
      gridupdate (false);
      bool cleared = false;
      do
	{
	  while (wasakeypressed ())
	    {
	      ch = readkey ();
	      switch (ch)
		{
		case 'M':
		  ch = readkey ();
		  switch (ch)
		    {
		    case 'A':
		    case 'N':
		      unsigned char othreads = threads;
		      if (ch == 'N')
			threads = 0;
		      do
			{
			  ch = readkey ();
			  switch (ch)
			    {
			    case '1'...tmodes:
			      thread[++threads - 1].tmode = ch - '0';
			      break;
			    case 'R':
			      thread[++threads - 1].tmode =
				random1 (tmodes - '0') + 1;
			      break;
			    }
			}
		      while (!
			     ((ch == '\15') || (ch == '#')
			      || (threads == thrmax)));
		      if (threads == 0)
			threads = othreads;
		      cleared = true;
		      break;
		    }
		  break;
		case 'C':
		  pickbank ();
		  if (bankt > 0)
		    {
		      ch = readkey ();
		      switch (ch)
			{
			case 'D':
			  ch = readkey ();
			  switch (ch)
			    {
			    case '1'...'9':
#define forallinbank(LDP) linedata *LDP; for (int bankc = 1;	\
		(LDP = &thread[bank[bankc - 1] - 1],	\
		bankc <= bankt); bankc++)
			      {
				forallinbank (L) L->slice = degs / (ch - '0');
			      }
			      break;
			    case 'M':
			      {
				forallinbank (L) L->slice = 0;
			      }
			      break;
			    }
			  break;
			case 'S':
			  {
			    forallinbank (L)
			    {
			      L->otslen = L->tslen;
			      L->tslen = 0;
			    }
			  }
			  do
			    {
			      char oldch = ch;
			      ch = readkey ();
			      forallinbank (L)
			      {
				switch (ch)
				  {
				  case '0'...'9':
				    L->tslen++;
				    L->turnseq[L->tslen - 1] = ch - '0';
				    if (oldch == '-') 
				      L->turnseq[L->tslen - 1] *= -1;
				    if (bankc % 2 == 0)
				      L->turnseq[L->tslen - 1] *= -1;
				    break;
				  }
			      }
			    }
			  while (!((ch == '\15') || (ch == '#')
				   || (thread[bank[0] - 1].tslen == 50)));
			  {
			    forallinbank (L)
			    {
			      int co, ro;

			      if (L->tslen == 0)
				L->tslen = L->otslen;
			      co = 0;
			      for (ro = 1; ro <= L->tslen; ro++)
				co += L->turnseq[ro - 1];
			      if (co == 0)
				L->tclim = 1;
			      else
				L->tclim = (int) (((real) degs2) / abs (co));
			      L->tsc = random1 (L->tslen) + 1;
			    }
			  }
			  break;
			case 'T':
			  {
			    ch = readkey ();
			    forallinbank (L)
			    {
			      switch (ch)
				{
				case '1'...tmodes:
				  L->tmode = ch - '0';
				  break;
				case 'R':
				  L->tmode = random1 (tmodes - '0') + 1;
				  break;
				}
			    }
			  }
			  break;
			case 'O':
			  ch = readkey ();
			  {
			    forallinbank (L) L->orichar = ch;
			  }
			  break;
			case 'F':
			  {
			    banktype fbank;
			    arrcpy (fbank, bank);
			    int fbankt = bankt;
			    pickbank ();
			    for (int bankc = 1; bankc <= fbankt; bankc++)
			      {
				linedata *L = &thread[fbank[bankc - 1] - 1];
				if (ch == 'N')
				  L->prey = 0;
				else
				  L->prey = bank[0 + (bankc - 1) % bankt];
			      }
			  }
			  break;
			case 'L':
			  forallinbank (L) L->prey = bank[bankc % bankt];
			  break;
			case 'R':
			  ch = readkey ();
			  {
			    forallinbank (L) switch (ch)
			      {
			      case '1'...'9':
				L->circturn = 10 - (ch - '0');
				break;
			      case 'R':
				L->circturn = random1 (7) + 1;
				break;
			      }
			  }
			  break;
			}
		    }
		  break;
		case 'T':
		case 'Y':
		case 'N':
		  boolop = ch;
		  pickbank ();
		  if (bankt > 0)
		    {
		      ch = readkey ();
		      forallinbank (L)
		      {
			switch (ch)
			  {
			  case 'S':
			    bankmod (&L->selfbounce);
			    break;
			  case 'V':
			    bankmod (&L->vhfollow);
			    break;
			  case 'R':
			    bankmod (&L->realbounce);
			    break;
			  case 'L':
			    bankmod (&L->little);
			    cleared = true;
			    break;
			  case 'T':
			    bankmod (&L->tailfollow);
			    break;
			  case 'K':
			    bankmod (&L->killwalls);
			    break;
			  }
		      }
		    }
		  break;
		case 'R':
		  if (bordcol == 1)
		    {
		      bordcol = 0;
		      bordupdate ();
		      bordcorn = (bordcorn + 1) % 4;
		      bordcol = 1;
		      bordupdate ();
		    }
		  break;
		case '\33':
		  halted = true;
		  break;
		case '1'...tmodes:
		  for (int co = 1; co <= thrmax; co++)
		    thread[co - 1].tmode = ch - '0';
		  break;
		case '\40':
		  cleared = true;
		  break;
		case 'E':
		  erasing = !erasing;
		  break;
		case 'P':
		  randpal ();
		  palupdate ();
		  break;
		case 'G':
		  {
		    char dimch = 'B';
		    if (gridden == 0)
		      gridden = ogd;
		    bool gridchanged = true;
		    do
		      {
			int msize = 0;
			if (gridchanged)
			  {
			    clearscreen ();
			    gridupdate (true);
			  }
			ch = readkey ();
			gridchanged = true;
			switch (ch)
			  {
			  case '+':
			    msize = 1;
			    break;
			  case '-':
			    msize = -1;
			    break;
			  case ']':
			    if (gridden < 15)
			      gridden++;
			    break;
			  case '[':
			    if (gridden > 0)
			      gridden--;
			    break;
			  case 'O':
			    ogd = gridden;
			    gridden = 0;
			    break;
			  case 'S':
			    boxw = boxh;
			  case 'W':
			  case 'H':
			  case 'B':
			    dimch = ch;
			    break;
			  default:
			    gridchanged = false;
			  }
			if ((dimch == 'W') || (dimch == 'B'))
			  boxw += msize;
			if ((dimch == 'H') || (dimch == 'B'))
			  boxh += msize;
			if (boxw == 0)
			  boxw = 1;
			if (boxh == 0)
			  boxh = 1;
		      }
		    while (!((ch == '\15') || (ch == '#') || (ch == 'O')));
		    cleared = true;
		  }
		  break;
		case 'A':
		  autopal = !autopal;
		  break;
		case 'B':
		  bordcol = 1 - bordcol;
		  bordupdate ();
		  break;
		case '-':
		  if (waitfreecycles > 0)
		    waitfreecycles -= 1;
		  break;
		case '+':
		  if (waitfreecycles < 100)
		    waitfreecycles += 1;
		  break;
		case '/':
		  if (curviness > 5)
		    curviness -= 5;
		  break;
		case '*':
		  if (curviness < 50)
		    curviness += 5;
		  break;
		case ']':
		  if (threads < thrmax)
		    thread[++threads - 1].newonscreen ();
		  break;
		case '[':
		  if (threads > 1)
		    {
		      linedata *L = &thread[threads - 1];
		      int lastpos = (L->filled) ? L->reclen - 1 : L->recpos;
		      for (int co = 0; co <= lastpos; co++)
			sp (L->yrec[co], L->xrec[co], 0);
		      threads--;
		    }
		  break;
		case 'Q':
		  waitfreecycles = 100;
		  break;
		}
	    }

	  if (waitfreecycles != 100)
	    waitabit (waitfreecycles);

	  {
	    bool alltrap = true;
	    for (unsigned char thr = 1; thr <= threads; thr++)
	      if (thread[thr - 1].move (thr))
		alltrap = false;
	    if (alltrap)
	      cleared = true;
	  }

	  {
	    XEvent xe;
	    while (XCheckWindowEvent
		   (mydpy, mywindow, StructureNotifyMask | ExposureMask, &xe))
	      switch (xe.type)
		{
		case ConfigureNotify:
		  wid = xe.xconfigure.width;
		  hei = xe.xconfigure.height;
		  free (point);
		  point = (unsigned char *) malloc ((wid + 1) * hei);
		  cleared = true;
		  break;
		case Expose:
		  if (!cleared)
		    redraw (xe.xexpose.x,
			    xe.xexpose.y, xe.xexpose.width,
			    xe.xexpose.height);
		  break;
		}
	  }
	}
      while (!(halted || cleared));
    }
  while (!halted);
}

/* Function Name: GetVRoot (slightly changed from the X Windows FAQ)
 * Description: Gets the root window, even if it's a virtual root
 * Arguments: the display and the screen
 * Returns: the root window for the client
 */
Window
GetVRoot (Display * dpy, int scr)
{
  Window rootReturn, parentReturn, *children;
  unsigned int numChildren;
  Window root = RootWindow (dpy, scr);
  Atom __SWM_VROOT = None;
  int i;

  __SWM_VROOT = XInternAtom (dpy, "__SWM_VROOT", False);
  XQueryTree (dpy, root, &rootReturn, &parentReturn, &children, &numChildren);
  for (i = 0; i < numChildren; i++)
    {
      Atom actual_type;
      int actual_format;
      unsigned long int nitems, bytesafter;
      Window *newRoot = NULL;

      if (XGetWindowProperty (dpy, children[i], __SWM_VROOT, 0, 1,
			      False, XA_WINDOW, &actual_type, &actual_format,
			      &nitems, &bytesafter,
			      (unsigned char **) &newRoot) == Success
	  && newRoot)
	{
	  root = *newRoot;
	  break;
	}
    }

  XFree ((char *) children);
  return root;
}

int
main (int argc, char **argv)
{
  mydpy = XOpenDisplay (NULL);

  for (int argnum = 1; argnum < argc; argnum++)
    {
      if (!strcmp (argv[argnum], "-geometry"))
	{
	  int x, y;
	  unsigned int uh, uw;
	  XParseGeometry (argv[++argnum], &x, &y, &uw, &uh);
	  hei = (int) uh;
	  wid = (int) uw;
	}
      else if (!strcmp (argv[argnum], "-instring"))
	instring = argv[++argnum];
      else if (!strcmp (argv[argnum], "-root"))
	use_root = 1;
      else if (!strcmp (argv[argnum], "-speed"))
	waitfreecycles = atoi (argv[++argnum]);
      else
	{
	  fprintf (stderr,
		   "\nfdm options are:"
		   "\n -speed NUMBER:  set speed, can be from 0 to 100."
		   "\n -root:  use root window."
		   "\n -instring STRING:  put STRING in kbd buffer."
		   "\n -geometry WIDTHxHEIGHT \n");
	  exit (1);
	}
    }

  if (use_root)
    mywindow = GetVRoot (mydpy, DefaultScreen (mydpy));
  else
    mywindow = XCreateSimpleWindow (mydpy, DefaultRootWindow (mydpy), 0, 0,
				    wid, hei, 0, 0, BlackPixel (mydpy,
								DefaultScreen
								(mydpy)));
  XStoreName (mydpy, mywindow, "fdm");
  XMapWindow (mydpy, mywindow);
  XSetWindowBackground (mydpy, mywindow,
			BlackPixel (mydpy, DefaultScreen (mydpy)));
  XWindowAttributes xgwa;
  XGetWindowAttributes (mydpy, mywindow, &xgwa);
  wid = xgwa.width;
  hei = xgwa.height;
  mycmap = xgwa.colormap;
  XGCValues mygcv;
  XGetGCValues (mydpy, XDefaultGC (mydpy, XDefaultScreen (mydpy)),
		GCForeground, &mygcv);
  mygc = XCreateGC (mydpy, mywindow, GCForeground, &mygcv);
  XSelectInput (mydpy, mywindow,
		KeyPressMask | ExposureMask | StructureNotifyMask);
  point = (unsigned char *) malloc ((wid + 1) * hei);

  {
    struct timeval tv;
    struct timezone tz;
    gettimeofday (&tv, &tz);
    srand (tv.tv_usec);
  }

  fdm_main ();
  return 0;
}
