#include "halftone.h"
#include <stdio.h>


/* print orderly pixels evenly */
void printPixels( long w, long h )
{
		short lp;

		printf( "\n/* pixels */\n" );
		for( lp=0; lp<h; lp++){
			int wlp;
			printf( "\"" );
			for( wlp=0; wlp<w; wlp++)
				printf( "%c%c", 'A'+(lp/32), 'A'+(lp%32) );
			printf( "\",\n" );
		}
		printf( "};\n" );
}


/* generate even 24bit palette spread */
void ditherPalette( char *rgbPalette, char *destPalette, long lines, long bitsize )
{
	short lp,r,g,b, rgb15;
	
	switch ( bitsize ){
	  case 24:
		for( lp=0; lp<lines; lp++){
			*destPalette++ = *rgbPalette++;
			*destPalette++ = *rgbPalette++;
			*destPalette++ = *rgbPalette++;
		}
		break;

	  case 16:
		for( lp=0; lp<lines; lp++){
			r = *rgbPalette++;
			g = *rgbPalette++;
			b = *rgbPalette++;
			rgb15 = MGL_halfTonePixel565( 0,lp , r,g,b);
			r = (rgb15 & 0xf800) >> 10;
			g = (rgb15 & 0x07e0) >> 5;
			b = (rgb15 & 0x001f);
			*destPalette++ = r<<3;
			*destPalette++ = g<<2;
			*destPalette++ = b<<3;
		}
		break;

	  case 15:
		for( lp=0; lp<lines; lp++){
			r = *rgbPalette++;
			g = *rgbPalette++;
			b = *rgbPalette++;
			rgb15 = MGL_halfTonePixel555( 0,lp , r,g,b);
			r = (rgb15 & 0x7c00) >> 10;
			g = (rgb15 & 0x03e0) >> 5;
			b = (rgb15 & 0x001f);
			*destPalette++ = r<<3;
			*destPalette++ = g<<3;
			*destPalette++ = b<<3;
		}
		break;

	  case 8:
		break;

	}
}



/* generate even 24bit palette spread */
void generatePalette( char *rgbPalette , long start, long end, long lines )
{
		long	r1,g1,b1, r2,g2,b2, ri,gi,bi, lp;

		r1 = (start & 0xff0000);
		g1 = (start & 0xff00) <<8;
		b1 = (start & 0xff) <<16;

		r2 = (end & 0xff0000);
		g2 = (end & 0xff00) <<8;
		b2 = (end & 0xff) <<16;

		ri = (r2-r1)/lines;
		gi = (g2-g1)/lines;
		bi = (b2-b1)/lines;

		for( lp=0; lp<lines; lp++ ){
			r1 += ri;
			g1 += gi;
			b1 += bi;
			*rgbPalette++ = r1>>16;
			*rgbPalette++ = g1>>16;
			*rgbPalette++ = b1>>16;
		}
}

/* print whatever the palette contains */
void printPalette( char *rgb, long lines )
{
		long lp, r,g,b, col;

		for( lp=0; lp<lines; lp++ ){
			r = *rgb++;
			g = *rgb++;
			b = *rgb++;
			col = ((r&0xff)<<16) | ((g&0x0ff)<<8) | (b&0xff);
			printf( "\"%c%c c #%06x\",\n", 'A'+(lp/32), 'A'+(lp%32), col );
		}
}







void main ( int argc, char **argv )
{
	if ( argc>2 ){
		long	start, end, col,lines=768, w=8, colors=768, bitsize=24, lp=0;
		char	*rgbPalette, *newPalette;

		if ( !(rgbPalette = malloc( 1*3*lines ) )) exit(1);
		if ( !(newPalette = malloc( 1*3*lines ) )) exit(1);

		srand( time() );

		if ( !strcmp( "rand", argv[1] ) ) start = rand() *0xffffff ;
			else sscanf( argv[1], "%x", &start);
		if ( !strcmp( "rand", argv[2] ) ) end = rand() *0xffffff ;
			else sscanf( argv[2], "%x", &end);

		if ( argc > 3 )
			colors = lines = atoi( argv[3] );
		if ( argc > 4 )
			bitsize = atoi( argv[4] );

		printf( "/* XPM */\nstatic char *data[] = {\n" );
		printf( "\"%d   %d   %d   2\",\n", w,lines, colors );

		generatePalette( rgbPalette, start, end, lines );
		ditherPalette( rgbPalette, newPalette, lines, bitsize );
		printPalette( newPalette, lines );
		printPixels( w, lines );

	} else {
		printf( "MakeGradXPM 1.2 (c)1997/June by Raul Sobon (cheekyboy@2-hoy.com)\n");
		printf("%s : [start rgb] [end rgb] [lines] [bpp]\n", argv[0]);
	}
}

