/* curstars - curses-based `3D' starfield.
 * Public domain by Russell Marks.
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <unistd.h>
#include <curses.h>

#define MAX_STARS 1000


struct star_tag
  {
  int prev_x,prev_y;	/* previously plotted position */
  double angle,dist;
  double dist_add;
  double dist_add_add;
  };

struct star_tag stars[MAX_STARS];



void newone(int f)
{
stars[f].angle=(rand()/(double)RAND_MAX)*2*3.1415927;
stars[f].prev_x=stars[f].prev_y=-1;
stars[f].dist=(double)(4+rand()%8);
stars[f].dist_add=1.;
stars[f].dist_add_add=0.;
stars[f].dist_add_add=0.03+(rand()/(double)RAND_MAX)*0.3;
}


void screenon()
{
initscr();
cbreak(); noecho();
nodelay(stdscr,TRUE);
curs_set(0);	/* hide cursor */
}


void screenoff()
{
wclear(stdscr);
move(LINES-1,0);
refresh();
echo(); nocbreak();
endwin();
putchar('\n');
}


void drawpix(int x,int y,int dist)
{
/* XXX crude! */
move(y/2,x);
if(!dist)
  {
  addch(' ');
  return;
  }

addch((y&1)?'.':'\'');
}


int main(int argc,char *argv[])
{
int f,x,y;
int num_stars;

srand(time(NULL));

screenon();

num_stars=40;
if(argc==2) num_stars=atoi(argv[1]);
if(num_stars==0) num_stars=1;
if(num_stars>MAX_STARS) num_stars=MAX_STARS;

for(f=0;f<num_stars;f++)
  newone(f);

while(getch()==ERR)
  {
  for(f=0;f<num_stars;f++)
    {
    stars[f].dist+=stars[f].dist_add;
    stars[f].dist_add+=stars[f].dist_add_add;
    x=COLS/2+(int)(cos(stars[f].angle)*stars[f].dist);
    y=LINES+(int)(sin(stars[f].angle)*stars[f].dist);
    
    if(stars[f].prev_x!=-1)
      drawpix(stars[f].prev_x,stars[f].prev_y,0);
    
    if(x>=COLS || x<0 || y<0 || y>=LINES*2)
      newone(f);
    else
      {
      drawpix(x,y,stars[f].dist);
      stars[f].prev_x=x;
      stars[f].prev_y=y;
      }
    }
  
  move(0,0);	/* `hide' the cursor (for terminals without cursor-off) */
  refresh();
  
  usleep(20000);
  }

screenoff();
exit(0);
}
