/* Moshe's Screen Saver: Have fun with a non-used terminal 
    Copyright (C) 1997 Moshe Zadka moshez@math.huji.ac.il

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <time.h>
#include <curses.h>
#include <string.h>
#include <math.h>

/* Declar drand, so compiler will know it returns a double */
double drand48();

/* The characters we draw. Lot's of spaces so screen won't get messy */
char draw[]="*...                          ";

int main(int argc, char **argv)
{
	int x,y;		/* Coordinates */
	char what;		/* The character we will draw */

	int len = strlen(draw);

	srand48(getpid()+time(NULL));

	if(argc!=1)
	{
		printf(
		"Moshe's Screen Saver, version 0.1, Copyright (C) 1977 Moshe Zadka\n");
		printf(
		"Moshe's Screen Saver comes with ABSOLUTELY NO WARRANTY\n");
		printf(
		"This is free software, and you are welcome to redistribute it\n");
		printf(
		"under certain conditions.\n");

		sleep(10);
	}


	/* Initialize curses */
	initscr();
	noecho();
	cbreak();
	nodelay(stdscr, TRUE);		/* Don't hang with getch */

	clear();

	/* As long as no key is pressed */
	while(getch() == ERR)
	{
		/* Choose random coordinates and character */
		x = drand48() * COLS;
		y = drand48() * LINES;
		what = draw[(int)(drand48() * len)]; 

		/* Draw the character where we want it */
		move(y,x);
		addch(what);

		/* Move to 0,0 so the curser won't jump around */
		move(0,0);

		/* Sleep a bit, so we don't tire the eye, nor
		** move then our due in CPU resources */
		usleep(1000);
	}
	
	/* The user pressed a key: Let's say clean up */
	clear();
	refresh();
	endwin();

	/* And say goodbye */
	printf("Goodbye, and thanks for using Moshe's Screen Saver\n");
	return 0;
}

