/*************************************************** 
 
 mandelca.c: implements a non-linear cellular automaton.        	
 Copyright (C) 02000 Luke Schubert

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 

 The author may be contacted at luke@dspace.com.au

 file:     mandelca.c
 function: Implements a non-linear CA.
 Author:   Luke Schubert 01/02/00
           $Id: mandelca.c,v 1.3 2000/03/28 09:51:36 luke Exp $
           $Log: mandelca.c,v $
           Revision 1.3  2000/03/28 09:51:36  luke
           Added email address

           Revision 1.2  2000/03/28 09:47:33  luke
           Added copyright & license notice

           Revision 1.1  2000/02/13 02:32:09  luke
           Initial revision

 ***************************************************/

/* #include <curses.h> */
#include <stdio.h>
#include <math.h>
#include "mandelca.h"

double new_cell_x[CA_WIDTH][CA_HEIGHT],
  new_cell_y[CA_WIDTH][CA_HEIGHT],
  old_cell_x[CA_WIDTH][CA_HEIGHT],
  old_cell_y[CA_WIDTH][CA_HEIGHT],
  orig_cell_x[CA_WIDTH][CA_HEIGHT],
  orig_cell_y[CA_WIDTH][CA_HEIGHT];

int no_gens;

/* WINDOW *win1; */

void init_ca(void)
{
  int i,j;

  for (i=0; i<CA_WIDTH; i++) {
    for (j = 0; j < CA_HEIGHT; j++) {
      new_cell_x[i][j] = 0.0;
      new_cell_y[i][j] = 0.0;
      old_cell_x[i][j] = (float)LEFT_X + (float)i*CPLX_WD/(float)CA_WIDTH;
      old_cell_y[i][j] = (float)TOP_Y  + (float)j*CPLX_HT/(float)CA_HEIGHT;
      orig_cell_x[i][j] = old_cell_x[i][j];
      orig_cell_y[i][j] = old_cell_y[i][j];
      /* printf("%f %f\n", old_cell_x[i][j], old_cell_y[i][j]); */
    }
  }
}

/* void init_win(void)
{
  initscr();

  if (has_colors()) {
    start_color();

    init_pair(0, COLOR_BLACK, COLOR_WHITE);
    init_pair(1, COLOR_RED, COLOR_WHITE);
    init_pair(2, COLOR_GREEN, COLOR_WHITE);
    init_pair(3, COLOR_YELLOW, COLOR_WHITE);
    init_pair(4, COLOR_BLUE, COLOR_WHITE);
    init_pair(5, COLOR_MAGENTA, COLOR_WHITE);
    init_pair(6, COLOR_CYAN, COLOR_WHITE);
    init_pair(7, COLOR_WHITE, COLOR_WHITE);
  }

  win1 = newwin(CA_HEIGHT, CA_WIDTH, 5, 5);

  noecho();
} */

void display(void)
{
  int i,j;
  int mag_class;
  /* chtype c; */
  char c;

  c = 'A';
  for (i = 0; i < CA_WIDTH; i++) {
    for (j = 0; j < CA_HEIGHT; j++) {
      mag_class = (int)((old_cell_x[i][j] * old_cell_x[i][j] 
		   + old_cell_y[i][j] * old_cell_y[i][j]) 
			/ COL_GRAD);		  
      if (mag_class > MAX_COLOURS) {
	mag_class = MAX_COLOURS;
	old_cell_x[i][j] = sqrt((double)(MAX_COLOURS * COL_GRAD));
	old_cell_y[i][j] = sqrt((double)(MAX_COLOURS * COL_GRAD));
      }
      /* wattrset(win1, mag_class);
	 mvwaddch(win1, i, CA_HEIGHT - j, c); */
      printf("%c", (c + mag_class));
    }
    printf("\n");
  }
  /* wrefresh(win1); */
  printf("\n\n");
}

void update_ca(void)
{
  int i,j, di, dj;
  
  for (i = 0; i < CA_WIDTH; i++) {
    for (j = 0; j < CA_HEIGHT; j++) { 
      if ((i == CA_WIDTH/2) && (j == CA_HEIGHT/2)) {
        printf("old_cell_x[%d][%d] = %f\n", i, j, old_cell_x[i][j]);
      }

      new_cell_x[i][j] = (old_cell_x[i][j] * old_cell_x[i][j] 
			  - old_cell_y[i][j] * old_cell_y[i][j]);
      new_cell_y[i][j] = (2*old_cell_x[i][j] * old_cell_y[i][j]);
      /* for (di = -1; di <= 1; di++) {
	for (dj = -1; dj <= 1; dj++) {
	  if ((di+i >= 0) && (di+i < CA_WIDTH)
	      && (dj + j >= 0) && (dj + j < CA_HEIGHT)) {
	    new_cell_x[i][j] += old_cell_x[i][j]/9;
	    new_cell_y[i][j] += old_cell_y[i][j]/9;
	  }
	}
	} */
      new_cell_x[i][j] += orig_cell_x[i][j];
      new_cell_y[i][j] += orig_cell_y[i][j];
    }
  }
  
  for (i = 0; i < CA_WIDTH; i++) {
    for (j = 0; j < CA_HEIGHT; j++) {
      old_cell_x[i][j] = new_cell_x[i][j];
      old_cell_y[i][j] = new_cell_y[i][j];
    }
  }
}

int main(void)
{
  int quit, key;
  int i,j;
  /* chtype c2; */

  init_ca();
  printf("Started OK ...\n");
  /*  init_win();

  c2 = 'a';
  mvwaddch(win1, 5, 5, c2); */

  quit = 0;
  no_gens = 0;

  /* while (quit!=1) { */
  for (i = 0; i < MAX_AGE; i++) {
    display();
    update_ca();
    for (j = 0; j < 20000000; j++) {
    }
  }
    /* key = getch();
    if (key == 'q') {
      quit = 1;
      } */
    /* quit = 1;
       } */
  /* wattrset(win1, 3);
     mvwaddch(win1, 5, 5, c2); */

  /* for (i=0; i < 100000000; i++) {
    quit = quit;
    } */
  
  /* delwin(win1);
     endwin(); */
}


