/*------------------------------------------------------------------*\

 mca_calc.h: header file for Mandelbrot Cellular Automaton C files 
 Copyright (C) 02000 Luke Schubert

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 

 The author may be contacted at luke@dspace.com.au

 file:     mca_calc.h
 function: Header file for mca_main.c and mca_calc.c
 author:   Luke Schubert 01/02/00
          $Id: mca_calc.h,v 1.9 2000/03/28 09:51:06 luke Exp $

\*------------------------------------------------------------------*/

#define CA_HEIGHT   500      /* one dimension of the cellular automaton   */ 
#define CA_WIDTH    500      /* other dimension of the cellular automaton */ 
#define MAX_MAGN    2.0      /* maximum magnitude of cells (unused)       */ 
#define COL_GRAD    0.125   /* step size of magnitude for next colour    */
#define MAX_COLOURS 24       /* total number of colours used              */
/* #define COL_GRAD    MAX_MAGN/(float)MAX_COLOURS */
#define DIFF_COLOURS 12      /* number of different ratios of r:g:b       */
#define SHADES      2        /* number of shades per colour               */
#define INTERP      1

#if 1
#define LEFT_X      -2.0     /* real value of leftmost cells              */
#define TOP_Y       -1.5     /* imaginary value of topmost cells          */
#define CPLX_HT     3.0      /* add to TOP_Y -> imag value of B cells     */ 
#define CPLX_WD     3.0      /* add to LEFT_X -> real value of R cells    */
#endif

#if 0
#define LEFT_X      -0.2
#define TOP_Y       0.6
#define CPLX_HT     0.3
#define CPLX_WD     0.3 
#endif

#define MAX_AGE     20       /* unused (was total number of generations)  */
#define AVG_NBHD    0        /* 1 to use averaging over a neighbourhood   */
#define NBHD_FACTOR 1.0
#define PERIOD      4000     /* in ms, before refreshing window           */

#define COL_SCHEME  R_TO_Y   /* unused (was a selection from the below)   */
#define RAINBOW     1        /* 1 to select rainbow colour scheme         */ 
#define R_TO_Y      0        /* 1 to select red, shading to yellow, c.s.  */
#define B_TO_I      0        /* 1 to select blue, shading to indigo, c.s. */
#define G_TO_B      0        /* 1 to select green, shading to blue, c.s.  */

#define MAND_LIFE   0        /* 1 to select "Life"-like extra CA rule     */ 
#define LIFE_COL    4        /* how many colours are special for life rule */
#define LIFE_SCALE  0.8      /* the scaling factor for the original value */

#define USE_POWER   1        /* 1 to use alternate polar calculation      */
#define POWER       2        /* power to use - 2 for standard Mandelbrot  */

#define OFLOW_RESET 1        /* 1 to reset cell on magnitude overflow     */

typedef struct {
  int colour_array[CA_HEIGHT][CA_WIDTH];
  int no_gens;
} colour_struct;

colour_struct mca_calc(int no_gens);

/* typedef struct {
  GdkWidget *widget;
  GdkWidget *darea;
  } double_widget; */

/*  
 *           $Log: mca_calc.h,v $
 *           Revision 1.9  2000/03/28 09:51:06  luke
 *           Added email address
 *
 *           Revision 1.8  2000/03/28 09:46:21  luke
 *           Added copyright & license reference
 *
 *           Revision 1.7  2000/03/27 10:07:37  luke
 *           Reset values to a suitable starting position
 *
 *           Revision 1.6  2000/03/27 09:58:28  luke
 *           Added SHADES, INTERP and more sub-options for MAND_LIFE
 *
 *           Revision 1.5  2000/03/03 23:20:07  luke
 *           Added OFLOW_RESET for controlling outside blinking
 *
 *           Revision 1.4  2000/03/03 23:05:48  luke
 *           Added POWER options; added comments for most options
 *
 *           Revision 1.3  2000/02/14 12:09:15  luke
 *           Added more colour schemes & MAND_LIFE option.
 *
 *           Revision 1.2  2000/02/13 08:42:48  luke
 *           Added more options: AVG_NBHD, PERIOD
 *
 *           Revision 1.1  2000/02/13 02:33:30  luke
 *           Initial revision
 *
 */
