/* mxp.c - Mandelbrot Explorer (main program and X11 setup)
 *
 * Released under version 2 of the Gnu Public License.
 * By Chris Brady, cbrady@sgi.com
 */ 

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Repeater.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include <X11/bitmaps/xlogo11>
#include "mxp.h"
#ifdef XPM
#include <X11/xpm.h>
#include "icon.xpm"
#else
#include "icon.xbm"
#endif
#ifdef MPI
#include <mpi.h>
#endif

/* externals from menu.c */
extern void make_menus();
extern struct menud *get_menu();

/* externals from colors.c */
extern Colormap cmap;
extern int colors;
extern int reserved;
extern void init_cmap();
extern void setup_cmap();
extern void color_inc();
extern void color_dec();
extern void bias_inc();
extern void bias_dec();

/* externals from file.c */
extern struct setup set;
extern void read_rc_file();
extern void filename_cb();
extern void pop_down();
extern char fname[];

/* externals from mandel.c */
extern void mooz();
extern void redo();
extern void decrement();
extern void increment();

/* externals from draw.c */
void create_draw();
void create_images();

/* externals from anim.c */
void make_anim_popup();

void command_done();
void close_stats();
void show_stats();
void set_wm_hints();
void quit();

XtAppContext ctx;
Widget toplevel;
Widget command;
Widget status_pu, stats_btn;
Widget st_time, st_pct, st_pixsec, st_pixels, st_mag;
Widget st_ux, st_uy, st_lx, st_ly, st_cx, st_cy, st_size, st_mflops;
Widget iter_label, error_pu, errorm; 
Widget mag_label, color_label, file_popup, file_text;
Cursor crosshair_xcr;
Cursor watch_xcr;
Cursor hand_xcr;
Dimension wwidth;
Dimension wheight;
Pixmap marker;
Pixmap icon_pixmap;
Pixmap icon_shape;
Pixel black_pix;
Pixel def_bg;
short depth;
int stats_flag;
#ifdef MPI
int mpi_rank;
int mpi_size;
#endif

static String fallback[] = {
	"*background:                gray",
	"*Label.background:          lightskyblue",
	"*Command.background:        slateblue3",
	"*Command.foreground:        white",
	"*Repeater.background:       slateblue3",
	"*Repeater.foreground:       white",
	"*Toggle.background:         slateblue3",
	"*Toggle.foreground:         white",
	"*MenuButton.background:     slateblue3",
	"*MenuButton.foreground:     white",
	"*SimpleMenu.background:     turquoise",
	NULL
};

String text_trans = "<Key>Return: filecb()";
static XtActionsRec acts[] = {
        { "filecb", filename_cb }
};

int main(int argc, char **argv) {
	Display *dp;
	int i;
	Arg argies[10];
	Widget temp;
	Widget button, command;

#ifdef MPI
	MPI_Init( &argc, &argv);
	MPI_Comm_rank(MPI_COMM_WORLD, &mpi_rank);
	if (mpi_rank != 0) {
		sched();
	}
	MPI_Comm_size(MPI_COMM_WORLD, &mpi_size);
	if (mpi_size == 1) {
		printf("FATAL: MXP must be run with 2 or more threads when compiled with MPI suport.\n");
		exit(1);
	}
#endif

	/*
	 * Create top level widget
	 */
	toplevel = XtAppInitialize(&ctx, "Mxp", NULL,
	    0, &argc, argv, fallback, NULL, 0);

	dp = XtDisplay(toplevel);
	black_pix = BlackPixel(dp, DefaultScreen(dp));
	depth = DisplayPlanes(dp,DefaultScreen(dp));

	marker = XCreateBitmapFromData(dp,
		RootWindowOfScreen(XtScreen(toplevel)),
		xlogo11_bits, xlogo11_width, xlogo11_height);
	i = 0;
	XtSetArg(argies[i], XtNbackground, &def_bg); i++;
        XtGetValues(toplevel, argies, i);
	crosshair_xcr = XCreateFontCursor(dp, XC_crosshair);
	watch_xcr = XCreateFontCursor(dp, XC_watch);
	hand_xcr = XCreateFontCursor(dp, XC_hand2);

#ifdef XPM
	XpmCreatePixmapFromData(dp, RootWindowOfScreen(XtScreen(toplevel)),
		icon_xpm, &icon_pixmap, &icon_shape, NULL);
#else
	icon_pixmap = XCreateBitmapFromData(dp,
		RootWindowOfScreen(XtScreen(toplevel)),
		icon_bits, icon_width, icon_height);
#endif

	/*
	 * Read parameters from rc file (if one exists)
	 */
	read_rc_file();
	wwidth = set.win_wid;
	wheight = set.win_hgt;
	
	/*
	 * Create a private colormap
	 */
	init_cmap(dp);
	reserved = 0;

	/*
	 * Create a paned widget to hold all of the command and status
	 * buttons / labels
	 */
	i = 0;
	XtSetArg( argies[i], XtNwidth, (XtArgVal) 170); i++;
	command = XtCreateManagedWidget("command", panedWidgetClass, toplevel,
		argies, i);

	/*
	 * Create menus (File, Size and Color Scheme)
	 */
	make_menus(command);

	/*
	 * Create animation setup popup
	 */
	make_anim_popup();

	/*
	 * Creat a popup to get a filename
	 */
	file_popup = XtCreatePopupShell("filename", transientShellWidgetClass,
		toplevel, NULL, 0);
        temp = XtCreateManagedWidget("filebox", boxWidgetClass,
                file_popup, NULL, 0);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtSetArg(argies[i], XtNlabel, "File Name:"); i++;
        XtCreateManagedWidget("file_label", labelWidgetClass,
                temp, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNuseStringInPlace, TRUE); i++;
        XtSetArg(argies[i], XtNtype, XawAsciiString); i++;
        XtSetArg(argies[i], XtNlength, MAX_NAME); i++;
        XtSetArg(argies[i], XtNstring, fname); i++;
        XtSetArg(argies[i], XtNeditType, XawtextEdit); i++;
        file_text = XtCreateManagedWidget("filetext", asciiTextWidgetClass,
                temp, argies, i);
        button = XtCreateManagedWidget("OK", commandWidgetClass,
                temp, NULL, 0);
	XtAddCallback(button, XtNcallback, filename_cb, (XtPointer)0);
        button = XtCreateManagedWidget("Cancel", commandWidgetClass,
                temp, NULL, 0);
	XtAddCallback(button, XtNcallback, pop_down, (XtPointer)file_popup);

	/*
	 * Creat a popup to report errors 
	 */
	error_pu = XtCreatePopupShell("error_pu", transientShellWidgetClass,
		toplevel, NULL, 0);
	i = 0;
	temp = XtCreateManagedWidget("error", boxWidgetClass,
		error_pu, argies, i);
	errorm = XtCreateManagedWidget("Error", labelWidgetClass, temp,
		argies, i);
	button = XtCreateManagedWidget("OK", commandWidgetClass,
	    temp, argies, i);
	XtAddCallback(button, XtNcallback, pop_down, (XtPointer)error_pu);

	/*
	 * Creat a popup to display status information
	 */
	i = 0;
        XtSetArg( argies[i], XtNtransient, (XtArgVal) FALSE); i++;
	status_pu = XtCreatePopupShell("Statistics", transientShellWidgetClass,
		toplevel, argies, i);
	i = 0;
	XtSetArg( argies[i], XtNwidth, (XtArgVal) 170); i++;
	temp = XtCreateManagedWidget("status", panedWidgetClass, status_pu,
		argies, i);
	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
	XtSetArg( argies[i], XtNborderWidth, (XtArgVal) 0); i++;
	XtSetArg( argies[i], XtNbackground, (XtArgVal) def_bg); i++;
	button = XtCreateManagedWidget("Close", commandWidgetClass, temp,
		argies, i);
	XtSetArg( argies[i], XtNjustify, (XtArgVal) XtJustifyLeft); i++;
	st_time = XtCreateManagedWidget("Time", labelWidgetClass, temp,
		argies, i);
	st_pct = XtCreateManagedWidget("Percent", labelWidgetClass, temp,
		argies, i);
	st_pixsec = XtCreateManagedWidget("Pixsec", labelWidgetClass, temp,
		argies, i);
	st_mflops = XtCreateManagedWidget("Mflops", labelWidgetClass, temp,
		argies, i);
	st_mag = XtCreateManagedWidget("Zoom", labelWidgetClass, temp,
		argies, i);
	st_size = XtCreateManagedWidget("Size", labelWidgetClass, temp,
		argies, i);
	st_pixels = XtCreateManagedWidget("Pixels", labelWidgetClass, temp,
		argies, i);
	st_cx = XtCreateManagedWidget("X", labelWidgetClass, temp,
		argies, i);
	st_cy = XtCreateManagedWidget("Y", labelWidgetClass, temp,
		argies, i);
	st_ux = XtCreateManagedWidget("UX", labelWidgetClass, temp,
		argies, i);
	st_uy = XtCreateManagedWidget("UY", labelWidgetClass, temp,
		argies, i);
	st_lx = XtCreateManagedWidget("LX", labelWidgetClass, temp,
		argies, i);
	st_ly = XtCreateManagedWidget("LY", labelWidgetClass, temp,
		argies, i);
	XtAddCallback(button, XtNcallback, close_stats, 0);

	/*
	 * Create buttons and labels that are in the command box
	 */
	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
	stats_btn = XtCreateManagedWidget("Statistics", commandWidgetClass,
	    command, argies, i);
	XtAddCallback(stats_btn, XtNcallback, show_stats, 0);
	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
	button = XtCreateManagedWidget("Unzoom", commandWidgetClass,
	    command, argies, i);
	XtAddCallback(button, XtNcallback, mooz, 0);
	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
	button = XtCreateManagedWidget("Redo", commandWidgetClass,
	    command, argies, i);
	XtAddCallback(button, XtNcallback, redo, 0);

	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
	temp = XtCreateManagedWidget("iter", boxWidgetClass, command,
		argies, i);
	i = 0;
	XtSetArg( argies[i], XtNborderWidth, (XtArgVal) 0); i++;
	XtSetArg( argies[i], XtNbackground, (XtArgVal) def_bg); i++;
	XtCreateManagedWidget("Iter", labelWidgetClass, temp, argies, i);
	i = 0;
	XtSetArg( argies[i], XtNinitialDelay, (XtArgVal) 350); i++;
	XtSetArg( argies[i], XtNrepeatDelay, (XtArgVal) 100); i++;
	button = XtCreateManagedWidget("+", repeaterWidgetClass, temp,
		argies, i);
	XtAddCallback(button, XtNcallback, increment, 0);
	i = 0;
	XtSetArg( argies[i], XtNborderWidth, (XtArgVal) 0); i++;
	iter_label = XtCreateManagedWidget("     0", labelWidgetClass,
	    temp, argies, i);
	i = 0;
	XtSetArg( argies[i], XtNinitialDelay, (XtArgVal) 350); i++;
	XtSetArg( argies[i], XtNrepeatDelay, (XtArgVal) 100); i++;
	button = XtCreateManagedWidget("-", repeaterWidgetClass, temp,
		argies, i);
	XtAddCallback(button, XtNcallback, decrement, 0);

	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
	temp = XtCreateManagedWidget("colors", boxWidgetClass, command,
		argies, i);
	i = 0;
	XtSetArg( argies[i], XtNborderWidth, (XtArgVal) 0); i++;
	XtSetArg( argies[i], XtNbackground, (XtArgVal) def_bg); i++;
	XtCreateManagedWidget("Colors", labelWidgetClass, temp, argies, i);
	i = 0;
	XtSetArg( argies[i], XtNinitialDelay, (XtArgVal) 350); i++;
	XtSetArg( argies[i], XtNrepeatDelay, (XtArgVal) 100); i++;
	button = XtCreateManagedWidget("+", repeaterWidgetClass, temp,
		argies, i);
	XtAddCallback(button, XtNcallback, color_inc, 0);
	i = 0;
	XtSetArg( argies[i], XtNborderWidth, (XtArgVal) 0); i++;
	color_label = XtCreateManagedWidget("  0", labelWidgetClass,
	    temp, argies, i);
	i = 0;
	XtSetArg( argies[i], XtNinitialDelay, (XtArgVal) 350); i++;
	XtSetArg( argies[i], XtNrepeatDelay, (XtArgVal) 100); i++;
	button = XtCreateManagedWidget("-", repeaterWidgetClass, temp,
		argies, i);
	XtAddCallback(button, XtNcallback, color_dec, 0);

	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
	temp = XtCreateManagedWidget("Rotate", boxWidgetClass, command,
		argies, i);
	i = 0;
	XtSetArg( argies[i], XtNborderWidth, (XtArgVal) 0); i++;
	XtSetArg( argies[i], XtNbackground, (XtArgVal) def_bg); i++;
	XtCreateManagedWidget("Col_Rotate", labelWidgetClass, temp, argies, i);
	i = 0;
	XtSetArg( argies[i], XtNinitialDelay, (XtArgVal) 350); i++;
	XtSetArg( argies[i], XtNrepeatDelay, (XtArgVal) 150); i++;
	button = XtCreateManagedWidget("+", repeaterWidgetClass, temp,
		argies, i);
	XtAddCallback(button, XtNcallback, bias_inc, 0);
	i = 0;
	XtSetArg( argies[i], XtNinitialDelay, (XtArgVal) 350); i++;
	XtSetArg( argies[i], XtNrepeatDelay, (XtArgVal) 150); i++;
	button = XtCreateManagedWidget("-", repeaterWidgetClass, temp,
		argies, i);
	XtAddCallback(button, XtNcallback, bias_dec, 0);

	XtRealizeWidget(toplevel);
	set_wm_hints(toplevel, "Controls", "Controls", NULL, hand_xcr);
	XtAddEventHandler(toplevel, StructureNotifyMask,
		FALSE, command_done, 0);

	XtOverrideTranslations(file_text, XtParseTranslationTable(text_trans));
	XtAppAddActions(ctx, acts, XtNumber(acts));
	XtAppMainLoop(ctx);
}

/*
 * Called when the toplevel widget has been mapped. This provides
 * syncronization so that the drawform window can be placed relative
 * the toplevel window after it has been mapped.
 */
void command_done(w, call_data, evnt)
Widget w;
caddr_t call_data;
XEvent *evnt;
{
        if (evnt->type == MapNotify) {
                XtRemoveEventHandler(toplevel, StructureNotifyMask,
                        FALSE, (XtEventHandler)command_done, 0);
                create_draw();
                create_images();
        }
}

void quit()
{
        exit(0);
}  

/*
 * Popup the status window
 */
void show_stats()
{
	int i;
	Arg arg[2];
	Position top_y, thgt, shgt;
	Dimension border_w, scr_h;
	Position pos_x, pos_y, tmp, title;
	XSizeHints sizehints;

	XtRealizeWidget(status_pu);

	stats_flag = 1;
	XtSetArg( arg[0], XtNsensitive, (XtArgVal) FALSE);
	XtSetValues(stats_btn, arg, 1);


	scr_h = HeightOfScreen(XtScreen(toplevel));

	i = 0;
        XtSetArg (arg[i], XtNheight, &thgt); i++;
        XtGetValues(toplevel, arg, i);

	i = 0;
        XtSetArg (arg[i], XtNheight, &shgt); i++;
        XtGetValues(status_pu, arg, i);

	/*
	 * I don't know how to get these dimensions the title and border
	 * dimensions so I am hard coding my defaults. KLUDGE!!!
	 */
	border_w = 5;
	title = 18;

	XtTranslateCoords(toplevel, 0, 0, &pos_x, &top_y);

	/*
	 * Place the new window on the screen just below the command
	 * window if possible, otherwise put it on top.
	 */
	tmp = top_y + shgt + thgt + (border_w * 2) + title;
	if (tmp <= scr_h) {
		pos_y = top_y + thgt + (border_w * 1);
	} else {
		pos_y = top_y - shgt - (border_w * 3) - (title * 2);
	}
	pos_x -= border_w;

	i = 0;
       	XtSetArg (arg[i], XtNx, pos_x); i++;
        XtSetArg (arg[i], XtNy, pos_y); i++;
        XtSetValues(status_pu, arg, i);
	sizehints.flags = USPosition;
	set_wm_hints(status_pu, "Statistics", "Stats", &sizehints, hand_xcr);

	XtPopup(status_pu, XtGrabNone);
}

/*
 * Popdown the status window
 */
void close_stats()
{
	Arg arg[1];

	stats_flag = 0;
	XtSetArg( arg[0], XtNsensitive, (XtArgVal) TRUE);
	XtSetValues(stats_btn, arg, 1);
	XtPopdown(status_pu);
}

/*
 * Called to set window manager hints, sizehints, window name, icon name,
 * icon, cursor and colormap for all windows.
 */
void set_wm_hints(w, name, iname, szhints, cursor)
Widget w;
char *name;
char *iname;
XSizeHints *szhints;
Cursor cursor;
{
	Arg arg[1];
	XWMHints wmhints;
	XTextProperty nm;
	XTextProperty inm;

	wmhints.flags = IconPixmapHint|WindowGroupHint;
	wmhints.icon_pixmap = icon_pixmap;
	wmhints.window_group = 991;
#ifdef XPM
	wmhints.flags |= IconMaskHint;
	wmhints.icon_mask = icon_shape;
#endif
	XStringListToTextProperty(&name, 1, &nm);
	XStringListToTextProperty(&iname, 1, &inm);
	XSetWMProperties(XtDisplay(w), XtWindow(w), &nm, &inm, NULL, 0,
                   szhints, &wmhints, NULL);	

	if (depth == 8) {
		XtSetArg(arg[0], XtNcolormap, cmap);
		XtSetValues(w, arg, 1);
	}

	XDefineCursor(XtDisplay(w), XtWindow(w), cursor);
}
