/* mxp.h - Mandelbrot Explorer
 *
 * Released under version 2 of the Gnu Public License.
 * By Chris Brady, cbrady@sgi.com
 */ 
#define BORDER_WIDTH	 5
#define TITLE_HEIGHT	18

#define RC_FILE ".mxprc"
#define MAX_NAME 80

#define ITER_2_COL_0(n) ((n * colors) / iter + reserved)
#define ITER_2_COL_1(n) (((n >> color_shift) % colors) + reserved)


/*
 * structure for save load setup
 */
struct setup {
	int mode;
	int color_mode;
	int color_shift;
	int colors;
	int bias;
	int iter;
	Dimension win_wid;
	Dimension win_hgt;
	int aspect_opt;
	double upper_x;
	double lower_x;
	double upper_y;
	double lower_y;
	double mag;
	double aspect;
};

struct menu_ent {
	short type;
	char *label;
	Widget button;
	void (*callb)();
	XtPointer data;
};

struct menud {
	char *name;
	char *label;
	Widget button;
	Widget popup;
	int count;
	int margin;
	struct menu_ent *entry;
};
	

struct zoomd {
        struct zoomd *zp;
        double lx, ux;
        double ly, uy;
        double mag;
        double aspect;
};

typedef struct comp{
        double re;
        double im;
}complex; 

#define M_NONE		0
#define M_CLEAR		1
#define M_NODISP	2
#define M_SYNC		4

#ifdef MPI
struct mdef {
        int wwidth;
        int sline;
        int nline;
        int iter;
        int msg_len;
        double disty;
        double distx;
        double incy;
        double incx;
};
struct wtab {
        int stat;
        int sline;
        int nline;
        int id;
};
#endif
