/*
 * Copyright (C) 1995 by Tom Pfau (pfau@cnj.digex.net)
 *
 * This file may be distributed under the terms of the GPL.
 */
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <X11/X.h>
#include <X11/XWDFile.h>
#include "mandelbrot.h"
#include "expand.h"
#include "setcolor.h"
#include "hlsrgb.h"

static XWDFileHeader hdr;
static char windowname[] = "mdb";
static XWDColor clr;

void main(int argc, char *argv[])
{
    struct PARAMS params;
    unsigned char colors[SCREEN_WIDTH];
    short int buf[SCREEN_WIDTH+1];
    short int tbuf[SCREEN_WIDTH];
    int i,l,o;
    int number_colors=256;
    FILE *log,*sixel;
    char *ifname=NULL,*ofname=NULL;
    float a,fr,fg,fb;
    o = 0;
    if (argc < 3)
    {
	printf("mxwd inputfile outputfile\n");
        exit(2);
    }
    ifname = argv[1];
    ofname = argv[2];
    if ((log = fopen(ifname,"rb")) == NULL)
    {
	perror(ifname);
        exit(2);
    }
    fread(&params,sizeof(struct PARAMS),1,log);
    printf("Coordinates:\n\tLeft: %18.16g\n\tTop:  %18.16g\n",
	    params.left,params.top);
    printf("Height: %18.16g\n",params.height);
    printf("Limit:  %8f\n",params.limit);
    printf("Iterations: %hd\n",params.iterations);
    if (!params.processes)
	params.processes = 1;
    printf("Computed with %d processes\n",params.processes);
    if ((sixel = fopen(ofname,"w")) == NULL)
    {   perror(ofname);
        exit(2);
    }
    hdr.header_size = htonl(sz_XWDheader + sizeof(windowname));
    hdr.file_version = htonl(XWD_FILE_VERSION);
    hdr.pixmap_format = htonl(ZPixmap);
    hdr.pixmap_depth = htonl(8);
    hdr.pixmap_width = htonl(SCREEN_WIDTH);
    hdr.pixmap_height = htonl(SCREEN_HEIGHT);
    hdr.xoffset = 0;
    hdr.byte_order = htonl(LSBFirst);
    hdr.bitmap_unit = htonl(32);
    hdr.bitmap_bit_order = htonl(LSBFirst);
    hdr.bitmap_pad = htonl(32);
    hdr.bits_per_pixel = htonl(8);
    hdr.bytes_per_line = htonl(SCREEN_WIDTH);
    hdr.visual_class = htonl(PseudoColor);
    hdr.red_mask = 0;
    hdr.green_mask = 0;
    hdr.blue_mask = 0;
    hdr.bits_per_rgb = htonl(6);
    hdr.colormap_entries = htonl(256);
    hdr.ncolors = htonl(256);
    hdr.window_width = htonl(SCREEN_WIDTH);
    hdr.window_height = htonl(SCREEN_HEIGHT);
    hdr.window_x = htonl(10);
    hdr.window_y = htonl(10);
    hdr.window_bdrwidth = 0;
    fwrite(&hdr,sz_XWDheader,1,sixel);
    fwrite(windowname,sizeof(windowname),1,sixel);
    for (i=0;i<256;i++)
    {
	clr.pixel = htonl(i);
	if (i == 0)
	    clr.red = clr.green = clr.blue = -1;
	else if (i == -1)
	    clr.red = clr.green = clr.blue = 0;
	else
	{
	    a = (float) (i-1) * 360.0 / 255.0;
	    hls_to_rgb(a,0.5,0.8,&fr,&fg,&fb);
	    clr.red = htons((int) (fr * 65535.0));
	    clr.green = htons((int) (fg * 65535.0));
	    clr.blue = htons((int) (fb * 65535.0));
	}
	clr.flags = 7;
	clr.pad = 0;
	fwrite(&clr,sizeof(clr),1,sixel);
    }
    for (l=0;l<SCREEN_HEIGHT;l++)
    {   fread(buf,sizeof(short int),1,log);
	fread(&buf[1],sizeof(short int),buf[0],log);
	expand(buf,tbuf);
	set_color(tbuf,colors,params.iterations,number_colors);
	fwrite(colors,SCREEN_WIDTH,1,sixel);
    }
    fclose(sixel);
}
