#ifndef IMAGE_H__
#define IMAGE_H__

void set_area(int x1, int y1, int x2, int y2);
char *readpic(char *name, int *width, int *height);
__inline__ void points(int x1, int y1, unsigned long c);
__inline__ void points_matrix(int x1, int y1, unsigned long c);
__inline__ unsigned long int getpoints(int x1, int y1);
__inline__ void arena(int x, int y, int dx, int dy, unsigned long c);
/*void filter(int x1, int y1, int x2, int y2, unsigned long filter, etyp event);
 */
__inline__ void line(int x1, int y1, int x2, int y2, unsigned long c);
__inline__ void conv_line(int x1, int y1, int x2, int y2, unsigned long c);
__inline__ void copyxyim(char *src1, int im_width, int im_x1, int im_y1,
			 int dx, int dy, int dest_x1, int dest_y1);
__inline__ void unpack(unsigned long rgb, unsigned int *r, unsigned int *g,
		       unsigned int *b);
__inline__ unsigned long pack(unsigned int r, unsigned int g,
			      unsigned int b);
__inline__ int c_shift(unsigned long mask);
__inline__ unsigned long rgb_conv(unsigned r, unsigned g, unsigned b);
__inline__ void create_back();
__inline__ void put_back(int x, int y, int dx, int dy);
__inline__ void get_back(int x, int y, int dx, int dy);
__inline__ void polygon3(int x1, int y1, int x2, int y2,
			 int x3, int y3, unsigned long c);
__inline__ void clear_data(int x1, int y1, int x2, int y2);

unsigned int image_width(void);
unsigned int image_height(void);
void image_to_swap(int k);
int image_swap_status(void);

#define C_SMALL 0x01		/* 256 */
#define C_REALCOLOR 0x02	/* 32768 */
#define C_HICOLOR 0x03		/* 65536 */
#define C_TRUECOLOR 0x04	/* 16777216 */


#define NR_IMAGE 2

struct swap_xy {
	int x1;
	int y1;
	int x2;
	int y2;
};

#define DATA_UL 0x01
#define DATA_US 0x02
#define DATA_UC 0x04

struct dataa {
	int init;
	union {
		unsigned short int **usint;
		unsigned long int **ulint;
		unsigned char **uchar;
	} data;
};

struct image {
	unsigned int height, width;

	unsigned int bytes_line;
	unsigned int bytes_pixel;
	int next_nr_i;
	int nr_i;

	unsigned long blackpixel;
	unsigned long whitepixel;

	int ready;
	char *data[NR_IMAGE];
	char *buff_line;
	struct dataa data2[NR_IMAGE];

	int to_swap;

	struct swap_xy swap_xy;
	int new_swap_set;
	int typ;
};
#endif
