#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "config.h"
#include "mmath.h"
#include "image.h"
#include "gi.h"
#ifndef OPT
#include <assert.h>
#endif

extern ginter gi;

struct image image;

unsigned int image_width()
{
	return image.width;
}

unsigned int image_height()
{
	return image.height;
}

void image_to_swap(int k)
{
	image.to_swap = k;
}

int image_swap_status()
{
	return image.to_swap;
}



void set_area(int x1, int y1, int x2, int y2)
{
#ifndef OPT
	assert(x1 >= 0 && x1 <= image.width);
	assert(y1 >= 0 && y1 <= image.height);
	assert(x2 >= 0 && x2 <= image.width);
	assert(y2 >= 0 && y2 <= image.height);
#endif

	switch (image.new_swap_set) {
	case 0:
		image.swap_xy.x1 = MIN(x1, image.swap_xy.x1);
		image.swap_xy.y1 = MIN(y1, image.swap_xy.y1);
		image.swap_xy.x2 = MAX(x2, image.swap_xy.x2);
		image.swap_xy.y2 = MAX(y2, image.swap_xy.y2);
		break;
	case 1:
	default:
		image.new_swap_set = 0;
		image.swap_xy.x1 = x1;
		image.swap_xy.y1 = y1;
		image.swap_xy.y2 = x2;
		image.swap_xy.y2 = y2;
		break;
	}
}


/*
char *readpic(char *name, int *width, int *height, etyp * )
{
	int cmax;
	char *buf2 = NULL;
	char *buf = NULL;
	buf = ppm_read(name, width, height, &cmax);

	if (buf == NULL)
		return NULL;
	buf2 = malloc(*height ** width * image.bytes_pixel);
	if (buf2 == NULL) {
		free(buf);
		return NULL;
	}
	switch (image.bytes_pixel) {
#if(SIZEOF_UNSIGNED_LONG==4)
	case 4:
		{
			unsigned long *tmpl = (unsigned long *) buf2;
			unsigned char *tmp = (unsigned char *) buf;
			int i;
			for (i = 0; i < *width ** height * 3; i += 3)
				*tmpl++ =
				    pack(tmp[i], tmp[i + 1], tmp[i + 2],
					 );

		}
		break;
#endif
#if(SIZEOF_UNSIGNED_SHORT==2)
	case 2:{
			unsigned short *tmpl = (unsigned short *) buf2;
			unsigned char *tmp = (unsigned char *) buf;
			int i;
			for (i = 0; i < *width ** height * 3; i += 3)
				*tmpl++ =
				    c_pack(tmp[i], tmp[i + 1], tmp[i + 2],
					   cmax, );
		}
		break;
#endif
	default:
		{
			unsigned char *tmpl = (unsigned char *) buf2;
			unsigned char *tmp = (unsigned char *) buf;
			int i;

			for (i = 0; i < *width ** height * 3;
			     i += 3, tmpl += image.bytes_pixel) {
				unsigned long *t = (unsigned long *) tmpl;
				*t &= ~(image.full_mask);
				*t |=
				    c_pack(tmp[i], tmp[i + 1], tmp[i + 2],
					   cmax, );
#ifndef OPT
				if (info.flag & VERBOSE && i == 3) {
					printf("pack:%lx\n",
					       c_pack(tmp[i], tmp[i + 1],
						      tmp[i + 2], cmax,
						      ));
					printf("out:%lx\n",
					       *t & (image.
						     red_mask | 
						     image.
						     green_mask | 
						     image.blue_mask));
				}
#endif
			}
		}
		break;
	}
	free(buf);
	return buf2;

}
*/



/* cmax = 0xff, rgb with 3(or 4) bytes*/
__inline__ unsigned long rgb_conv(unsigned r, unsigned g, unsigned b)
{
	switch (image.typ) {
	case C_TRUECOLOR:
		return (r << 16 | g << 8 | b);
	case C_REALCOLOR:
		return ((r >> 3) << 10 | (g >> 3) << 5 | b >> 3);
	case C_HICOLOR:
		return ((r >> 3) << 11 | (g >> 2) << 5 | b >> 3);
	case C_SMALL:
		return gi.set_palette(r, g, b);
	default:
		return 0;
	}
}



__inline__ unsigned long int getpoints(int x1, int y1)
{
#ifndef OPT
	assert(x1 >= 0 && x1 <= image.width);
	assert(y1 >= 0 && y1 <= image.height);
#endif
	switch (image.data2[image.nr_i].init) {
	case DATA_US:
		return image.data2[image.nr_i].data.usint[y1][x1];
	case DATA_UL:
		return image.data2[image.nr_i].data.ulint[y1][x1];
	case DATA_UC:
	default:
		return image.data2[image.nr_i].data.uchar[y1][x1];
	}
}

__inline__ void points_matrix(int x1, int y1, unsigned long c)
{
#ifndef OPT
	assert(x1 >= 0 && x1 <= image.width);
	assert(y1 >= 0 && y1 <= image.height);
#endif
	switch (image.data2[image.nr_i].init) {
	case DATA_UL:
		image.data2[image.nr_i].data.ulint[y1][x1] =
		    (unsigned long) c;
		return;
	case DATA_US:
		image.data2[image.nr_i].data.usint[y1][x1] =
		    (unsigned short) c;
		return;
	case DATA_UC:
		image.data2[image.nr_i].data.uchar[y1][x1] =
		    (unsigned char) c;
		return;

	}
}

__inline__ void points(int x1, int y1, unsigned long c)
{
#ifndef OPT
	assert(x1 >= 0 && x1 <= image.width);
	assert(y1 >= 0 && y1 <= image.height);
#endif
	switch (image.bytes_pixel) {
#if(SIZEOF_UNSIGNED_LONG==4)
	case 4:
		{
			register unsigned long *dat =
			    (unsigned long *) image.data[image.nr_i];
			dat[(image.bytes_line / 4) * y1 + x1] =
			    (unsigned long) c;

		}
		break;
#endif
#if(SIZEOF_UNSIGNED_SHORT==2)
	case 2:{

			register unsigned short *dat =
			    (unsigned short *) image.data[image.nr_i];
			dat[(image.bytes_line / 2) * y1 + x1] =
			    (unsigned short) c;

		} break;
#endif
#if(SIZEOF_UNSIGNED_CHAR==1)

	case 1:{
			register unsigned char *dat =
			    (unsigned char *) image.data[image.nr_i];
			dat[(image.bytes_line) * y1 + x1] =
			    (unsigned char) c;

		} break;
#endif
/*	default:
		{
			register unsigned long *dat =
			    (unsigned long *) (image.
					       data[image.nr_i]
					       +
					       (image.bytes_line) *
					       y1 +
					       image.bytes_pixel *
					       x1);
			*dat &= ~(image.full_mask);
			*dat |= c;
		} break;*/
	}
}


__inline__ int conv_x(int x1, int w2)
{
	return x1 - w2;
}

__inline__ int conv_y(int y1, int h2)
{
	return h2 - y1;
}

__inline__ void conv_line(int x1, int y1, int x2, int y2, unsigned long c)
{
	if (y1 != y2 && x2 != x1) {
		x1 = conv_x(x1, image.width / 2);
		x2 = conv_x(x2, image.width / 2);
		y1 = conv_y(y1, image.height / 2);
		y2 = conv_y(y2, image.height / 2);
		{
			register double m =
			    (double) (y2 - y1) / (double) (x2 - x1);
			register double k = (double) y1 - (double) x1 * m;
			if (ABS(m) < 1.0) {
				register int xa = MIN(x1, x2);
				register int xe = MAX(x1, x2);
				while (xa < xe) {
					points(xa,
					       (int) rint((double) xa * m +
							  k), c);
					xa++;
				}
			} else {
				register int ya = MIN(y1, y2);
				register int ye = MAX(y1, y2);
				while (ya < ye) {
					points((int)
					       rint(((double) ya - k) / m),
					       ya, c);
					ya++;
				}
			}
		}
	} else if (y1 == y2) {
		x1 = conv_x(x1, image.width / 2);
		x2 = conv_x(x2, image.width / 2);
		y1 = conv_y(y1, image.height / 2);
		{
			register int xa = MIN(x1, x2);
			register int xe = MAX(x1, x2);
			while (xa < xe) {
				points(xa, y1, c);
				xa++;
			}
		}
	} else {
		x1 = conv_x(x1, image.width / 2);
		y1 = conv_y(y1, image.height / 2);
		y2 = conv_y(y2, image.height / 2);
		{
			register int ya = MIN(y1, y2);
			register int ye = MAX(y1, y2);
			while (ya < ye) {
				points(x1, ya, c);
				ya++;
			}
		}
	}
}

__inline__ void line(int x1, int y1, int x2, int y2, unsigned long c)
{
#ifndef OPT
	assert(x1 >= 0 && x1 <= image.width);
	assert(y1 >= 0 && y1 <= image.height);
	assert(x2 >= 0 && x2 <= image.width);
	assert(y2 >= 0 && y2 <= image.height);
#endif

	if (y1 != y2 && x2 != x1) {
		register double m =
		    (double) (y2 - y1) / (double) (x2 - x1);
		register double k = (double) y1 - (double) x1 * m;
		switch ((int) floor(ABS(m))) {
		case 0:{
				register int xa = MIN(x1, x2);
				register int xe = MAX(x1, x2);
				while (xa <= xe) {
					points(xa,
					       (int) rint((double) xa * m +
							  k), c);
					xa++;
				}
				/*
				 * points(xe,MAX(y1,y2),c,);
				 */
			} break;
		default:{
				register int ya = MIN(y1, y2);
				register int ye = MAX(y1, y2);
				while (ya <= ye) {
					points((int)
					       rint(((double) ya - k) / m),
					       ya, c);
					ya++;
				}
				/*
				 * points(MAX(x1,x2),ye,c,);
				 */
			} break;
		}
	} else if (y1 == y2) {
		register int xa = MIN(x1, x2);
		register int xe = MAX(x1, x2);
		while (xa <= xe) {
			points(xa, y1, c);
			xa++;
		}
		/*
		 * points(xa,y1,c,);
		 */
	} else {
		register int ya = MIN(y1, y2);
		register int ye = MAX(y1, y2);
		while (ya <= ye) {
			points(x1, ya, c);
			ya++;
		}
		/*
		 * points(x1,ye,c,);
		 */
	}
}


__inline__ void h_line_p(int x1, int y1, int x2, unsigned long c)
{
	{
		int xa = MIN(x1, x2);
		int xe = MAX(x1, x2);

		if (xe < 0 || xa > (int) image.width)
			return;

		if (xa < 0)
			xa = 0;
		if (xe >= image.width)
			xe = image.width - 1;
#ifndef OPT
		assert(xa >= 0 && xa <= image.width);
		assert(y1 >= 0 && y1 <= image.height);
		assert(xe >= 0 && xe <= image.width);
#endif
		while (xa <= xe) {
			points(xa, y1, c);
			xa++;
		}
	}
}

__inline__ void polygon3(int x1, int y1, int x2, int y2, int x3, int y3,
			 unsigned long c)
{
	int xa = x1;
	int ya = y1;
	int xb;
	int yb;
	int yc;
	int xc;
	register double m1 = 0, m2 = 0, m3 = 0;
	register double k1 = 0, k2 = 0, k3 = 0;
	int f1cons = 0;
	int f2cons = 0;
	int f3cons = 0;

	if (y2 < ya) {
		xb = xa;
		yb = ya;
		xa = x2;
		ya = y2;
	} else {
		xb = x2;
		yb = y2;
	}

	if (y3 < ya) {
		xc = xb;
		yc = yb;
		xb = xa;
		yb = ya;
		xa = x3;
		ya = y3;
	} else if (y3 < yb) {
		xc = xb;
		yc = yb;
		xb = x3;
		yb = y3;
	} else {
		xc = x3;
		yc = y3;
	}

	if (xa == xb || ya == yb)
		f1cons = 1;
	else {
		m1 = (double) (ya - yb) / (double) (xa - xb);
		k1 = (double) ya - (double) xa *m1;
	}

	if (xa == xc || ya == yc)
		f2cons = 1;
	else {
		m2 = (double) (ya - yc) / (double) (xa - xc);
		k2 = (double) ya - (double) xa *m2;
	}

	if (xc == xb || yc == yb)
		f3cons = 1;
	else {
		m3 = (double) (yc - yb) / (double) (xc - xb);
		k3 = (double) yc - (double) xc *m3;
	}

	if (yc < 0 || ya >= (int) image.height)
		return;

	if (ya < 0)
		ya = 0;
	if (yc >= image.height)
		yc = image.height - 1;

	for (; ya <= yc; ya++) {
		int xl1 = xa, xl2 = xa;
		if (ya < yb) {
			if (f1cons)
				xl1 = xa;
			else
				xl1 = (int)
				    rint(((double) ya - k1) / m1);
		} else {
			if (f3cons)
				xl1 = xb;
			else
				xl1 = (int)
				    rint(((double) ya - k3) / m3);
		}
		if (f2cons)
			xl2 = xc;
		else
			xl2 = (int) rint(((double) ya - k2) / m2);
		h_line_p(xl1, ya, xl2, c);
	}

}

__inline__ void arena(int x, int y, int dx, int dy, unsigned long c)
{
#ifndef OPT
	assert(x >= 0 && x <= image.width);
	assert(y >= 0 && y <= image.height);
	assert((x + dx) >= 0 && (x + dx) <= image.width);
	assert((y + dy) >= 0 && (y + dy) <= image.height);
#endif

	switch (image.data2[image.nr_i].init) {
	case DATA_UL:
		while (dy--) {
			register int tdx = dx;
			while (tdx--)
				image.data2[image.nr_i].data.ulint[y +
								   dy][x +
								       tdx]
				    = c;
		}
		return;
	case DATA_US:
		while (dy--) {
			register int tdx = dx;
			while (tdx--)
				image.data2[image.nr_i].data.usint[y +
								   dy][x +
								       tdx]
				    = (unsigned short) c;
		}
		return;
	case DATA_UC:
		while (dy--) {
			register int tdx = dx;
			while (tdx--)
				image.data2[image.nr_i].data.
				    uchar[y + dy][x + tdx] =
				    (unsigned char) c;
		}
		return;

	}
}

__inline__ void clear_data(int x1, int y1, int x2, int y2)
{
	int dx = x2 - x1;
	int dy = y2 - y1;
#ifndef OPT
	assert(x1 >= 0 && x1 <= image.width);
	assert(x2 >= 0 && x2 <= image.width);
	assert(y1 >= 0 && y1 <= image.height);
	assert(y2 >= 0 && y2 <= image.height);
#endif


	switch (image.bytes_pixel) {
#if(SIZEOF_UNSIGNED_LONG==4)
	case 4:
		{
			register unsigned long *dat =
			    (unsigned long *) image.data[image.nr_i]
			    + (image.bytes_line / 4) * y1 + x1;
			while (dy--) {
				memset((void *) dat, 0,
				       (dx) * (image.bytes_pixel));
				dat += (image.bytes_line / 4);
			}
		} break;
#endif
#if(SIZEOF_UNSIGNED_SHORT==2)
	case 2:{
			register unsigned short *dat =
			    (unsigned short *) image.data[image.nr_i]
			    + (image.bytes_line / 2) * y1 + x1;
			while (dy--) {
				memset((void *) dat, 0,
				       (dx) * (image.bytes_pixel));
				dat += (image.bytes_line / 2);
			}
		} break;
#endif
#if(SIZEOF_UNSIGNED_CHAR==1)
	case 1:{
			register unsigned char *dat =
			    (unsigned char *) image.data[image.nr_i]
			    + (image.bytes_line) * y1 + x1;
			while (dy--) {
				memset((void *) dat, 0,
				       (dx) * (image.bytes_pixel));
				dat += (image.bytes_line);
			}
		} break;
#endif
	default:
		{
			register unsigned char *dat
			    = (unsigned char *) image.data[image.nr_i]
			    + (image.bytes_line) * y1
			    + image.bytes_pixel * x1;
			while (dy--) {
				memcpy((void *) dat, 0,
				       (dx) * (image.bytes_pixel));
				dat += image.bytes_line;
			}
		} break;
	}
}


/*           inline void
   filter (int x1, int y1, int x2, int y2, unsigned long filter, etyp )
   {

   //unsigned long *dat = (unsigned long *).data[.nr_i];
   char *dat = (char *) .data[.nr_i];
   if (x1 == x2 && y1 == y2)   {
   dat[(.bytes_line) * y1 + x1] &= filter;
   }
   else
   {
   int x = x1, y = y1 - 1;
   x2 = (x2 < .width ? x2 : .width - 1);
   y2 = (y2 < .height ? y2 : .height - 1);
   for (; (y = (x == x1 ? y + 1 : y)) <= y2; x = (x < x2 ? x + 1 : x1))
   dat[(.bytes_line) * y + x] &= filter;
   }
   }
 */


#if (NR_IMAGE==2)
__inline__ void create_back()
{
	image.nr_i = 1;
	copyxyim(image.data[0], image.width, 0, 0, image.width,
		 image.height, 0, 0);
	image.nr_i = 0;
}

__inline__ void put_back(int x, int y, int dx, int dy)
{
	image.nr_i = 1;
	copyxyim(image.data[0], image.width, x, y, dx, dy, x, y);
	image.nr_i = 0;
}

__inline__ void get_back(int x, int y, int dx, int dy)
{
#ifndef OPT
	assert(x >= 0 && x <= image.width);
	assert(y >= 0 && y <= image.height);
	assert((x + dx) >= 0 && (x + dx) <= image.width);
	assert((y + dy) >= 0 && (y + dy) <= image.height);
#endif
	copyxyim(image.data[1], image.width, x, y, dx, dy, x, y);
}
#endif


__inline__ void copyxyim(char *src1, int im_width, int im_x1, int im_y1,
			 int dx, int dy, int dest_x1, int dest_y1)
{
#ifndef OPT
	assert(im_x1 >= 0 && im_x1 <= image.width);
	assert(im_y1 >= 0 && im_y1 <= image.height);
	assert((im_x1 + dx) >= 0 && (im_x1 + dx) <= image.width);
	assert((im_y1 + dy) >= 0 && (im_y1 + dy) <= image.height);
	assert(dest_x1 >= 0 && dest_x1 <= image.width);
	assert(dest_y1 >= 0 && dest_y1 <= image.height);
	assert((dest_x1 + dx) >= 0 && (dest_x1 + dx) <= image.width);
	assert((dest_y1 + dy) >= 0 && (dest_y1 + dy) <= image.height);

#endif


	switch (image.bytes_pixel) {
#if(SIZEOF_UNSIGNED_LONG==4)
	case 4:
		{
			register unsigned long *dat =
			    (unsigned long *) image.data[image.nr_i] +
			    (image.bytes_line / 4) * dest_y1 + dest_x1;
			register unsigned long *src =
			    (unsigned long *) src1 + (im_width) * im_y1 +
			    im_x1;
			while (dy--) {
				memcpy((void *) dat, (void *) src,
				       (dx) * (image.bytes_pixel));
				dat += (image.bytes_line / 4);
				src += (im_width);
			}
		} break;
#endif
#if(SIZEOF_UNSIGNED_SHORT==2)
	case 2:{
			register unsigned short *dat =
			    (unsigned short *) image.data[image.nr_i] +
			    (image.bytes_line / 2) * dest_y1 + dest_x1;
			register unsigned short *src =
			    (unsigned short *) src1 + (im_width) * im_y1 +
			    im_x1;
			while (dy--) {
				memcpy((void *) dat, (void *) src,
				       (dx) * (image.bytes_pixel));
				dat += (image.bytes_line / 2);
				src += (im_width);
			}
		} break;
#endif
	default:
		{
			register unsigned char *dat
			    = (unsigned char *) image.data[image.nr_i]
			    + (image.bytes_line) * dest_y1
			    + image.bytes_pixel * dest_x1;
			register unsigned char *src
			    = (unsigned char *) src1
			    + image.bytes_pixel * (im_width) * im_y1
			    + image.bytes_pixel * im_x1;
			while (dy--) {
				memcpy((void *) dat, (void *) src,
				       (dx) * (image.bytes_pixel));
				dat += image.bytes_line;
				src += im_width * image.bytes_pixel;
			}
		} break;
	}


}
