#include <stdio.h>
#include "image.h"
#include "text.h"
#include "imtext.h"


static void d_print(int x, int y, unsigned char *let, unsigned long c)
{
	int x1 = 0, y1 = 0;
	while (y1 < TEXT_HEIGHT) {
		if (let[TEXT_HEIGHT - y1] >> (TEXT_WIDTH - x1) & 0x01)
			points(x1 + x, y1 + y, c);
		x1 = (x1 < TEXT_WIDTH ? (x1 + 1) : 0);
		y1 = (x1 == 0 ? (y1 + 1) : y1);
	}
}

int d_string(int x, int y, char *str, unsigned long c)
{
	int y1 = y, x1 = x;
	int plen = 0;
	while (*str != 0x00) {
		if (*str == 0x0a) {
			y1 += TEXT_HEIGHT;
			x1 = x;
			++str;
		}
		if (*str == '.') {
			d_print(x1, y1, point, c);
			plen++;
		}
		if (*str == '-') {
			d_print(x1, y1, minus, c);
			plen++;
		}
		if (*str >= 0x30 && *str <= 0x39) {
			d_print(x1, y1,
				&number[(*str - 0x30) * TEXT_HEIGHT], c);
			plen++;
		}
		if (*str >= 0x41 && *str <= 0x5a) {
			d_print(x1, y1,
				&letters[(*str - 0x41) * TEXT_HEIGHT], c);
			plen++;
		}
		if (*str >= 0x61 && *str <= 0x7a) {
			d_print(x1, y1,
				&letters[(*str - 0x61) * TEXT_HEIGHT], c);
			plen++;
		}
		x1 += TEXT_WIDTH + 2;

		++str;
	}
	return plen;
}
