#include <stdio.h>
#include <string.h>
#include "config.h"
#include "init.h"
#include "args.h"
#include "info.h"

struct info info;

int init(int argc, char **argv)
{
	init_args(argc, argv);
	if (is_arg("--full"))
		info.flag |= FULL;
	if (is_arg("--version")) {
		printf("%s, version %s\n", PACKAGE, VERSION);
		return (1);
	}
	if (is_arg("--fps"))
		info.flag |= FPS;
#ifdef USE_X11
	if (is_arg("-x"))
		info.drv = X11_DRV;
#endif
#ifdef USE_VGA
	if (is_arg("-s"))
		info.drv = SVGA_DRV;
#endif
	if (is_arg("-V"))
		info.flag |= VERBOSE;
	if (is_arg("--help")) {
		printf("%s-%s\n", PACKAGE, VERSION);
		printf
		    ("Suggestions, comments, and bugs to: Markus Fraczek (marekf@gmx.net)\n\n");
		printf("usage: %s [opt]\n", argv[0]);
		print_args();
		return (1);
	}
	return (0);
}
