/* lock 1.1 - a simple program to password lock a terminal.
 *You can enter the password at the password prompt as the program starts or
 *put it as a parameter on the command line. The second option is probably
 *useful when used from a shell script, but not secure.
 *There are additional command line options
 *Copyright (C) 1997 Yevgeniy Rabinovich
 *To contact the author send e-mail to y-rabinovich@uchicago.edu */

#include <stdio.h>
#include <signal.h>
#include <pwd.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_SHADOW
#include <shadow.h>
#endif

char *temp;
char password[13]; 
char verpasswd[13];
char *chkpasswd;
char enc_passwd[13];                    //encrypted password in /etc/passwd
char salt[2];                           //salt for crypt()


int screen_passwd()	//get password while already running.
{
  temp=crypt(getpass("\x1B[2J\x1B[10;0HEnter password which will lock up this sesion:"),salt);
  strcpy(password,temp);
                  //we have to use temp and strcpy, otherwise crypt overwrites
		  //memory address
  temp=crypt(getpass("Please verify entered password:"),salt);
  strcpy(verpasswd,temp);
  if (strcmp(password,verpasswd) != 0)  //if verification fails
    {
      printf("\a\x1B[2J\x1B[10;2HVerification failed. Now exiting.\n");
      return 1;
    }  
  return 0;
}

int unlock()
{
  int i=0;             //counter
  chkpasswd=crypt(getpass("\x1B[2J\x1B[10;10HEnter password to unlock this session:"),salt);
  while (strncmp(password, chkpasswd, 13) != 0)
    {
      printf("You have entered an incorrect password. Try again!\n\n");
      i++;
      sleep(i/3);
      chkpasswd=crypt(getpass("\a\x1B[10CEnter password to unlock this session:"),salt);
    }
  printf("\x1B[2J\x1B[10;2HThe session is now unlocked.\n");
  return 0;                              //exit the program
}

int main(int argc, char *argv[])
{
  struct passwd *log_passwd;             //login password structure
#ifdef HAVE_SHADOW
  struct spwd *spw;
#endif
  
  int arg_countr;                        //counter for argument processing
  int errorlevel=0;                      //value returned by screen_passwd

  signal(SIGINT, SIG_IGN);               //disables CTRL-C
  signal(SIGTSTP, SIG_IGN);              //disables CTRL-Z
  signal(SIGTERM, SIG_IGN);
  signal(SIGHUP, SIG_IGN);
  signal(SIGQUIT, SIG_IGN);
  signal(SIGABRT, SIG_IGN);

  log_passwd=getpwnam(getenv("LOGNAME"));
                         //get user info from /etc/passwd
  strcpy(enc_passwd,log_passwd->pw_passwd);
                         //get encrypted password
#ifdef HAVE_SHADOW
  if ((spw=getspnam(log_passwd->pw_name)) != NULL)
    strcpy(enc_passwd, spw->sp_pwdp);
#endif

  strncpy(salt, enc_passwd, 2);          //get "salt" from encrypted password

  if (argc == 1)                         //if there are no arguments on
					 // command line, ask for password
    {
      errorlevel=screen_passwd();        //get password to lock from user
    }

  else
    {
      for (arg_countr=1; arg_countr < argc; arg_countr++)
	{
	  char *arg_ptr=argv[arg_countr];
	  if (strcmp(arg_ptr,"-p")==0)
	    {
              strncpy(password, enc_passwd, 13);
              errorlevel=0;                       //force errorlevel to 0
            }
	  else
	    {
	      if (argc==2)          //if only password is given on command line
	        {
                  //do nothing ??
		}
              temp=crypt(argv[arg_countr],salt);
                              //get password if given on command line
              strcpy(password, temp);
              //for (i=0 ; i < MAXLEN + 1 ; i++) ((int)argv[arg_countr])='0';
              errorlevel=0;                       //force errorlevel to 0
	    }		 
        }
    }    
  if (errorlevel >= 1)              //if there were errors, exit
    {
      return errorlevel;
    }
  else
    {
      unlock();             //wait for user to give password to unlock
      return 0;
    }
}


/* Values returned by program:
0 - successful;
1 - password verification failed;
//2 - did not give a terminal for -l/-u option
*/

/* To do:
1. zero unencrypted passwords (done ?)
2. allow locking an X terminal (like xlock)
3. allow locking of other vt's used by the user.
//4. make sure you can't use -p and -u together
//5. shorten the names of the terminals
*/

/* Options:
1. -p -- use login password
2. -l -- lock another terminal (doesn't work yet)
3. -u -- unlock another vt     (doesn't work yet)
4. -a -- lock up all user's terminals (doesn't work yet)
5. -x -- lock up X terminal (doesn't work yet)
*/

/* Useful functions: (?)
1. getopt, getpass, ctermid. isatty. killpg. exec*. system. ttyname
*/

/*
The first 2 letters of the encrypted password in /etc/passwd is the "salt" 
used by the crypt().
*/

/*
Warning! If you enter the password on the command line, other users might
be able to view it with the ps command from another terminal!!!
*/
