//
// gcc -o foo foo.c -lXext -lXpm -lX11 -lm -L/usr/X11R6/lib
//

#include <stdio.h>
#include <strings.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>
#include "vroot.h"
#include <sys/time.h>

#ifndef PI                      /* as in stroustrup */
#define PI  M_PI
#endif

char pengfile[]={"/usr/include/X11/pixmaps/pengwatch.xpm"};

int SIZE=32;                     /* radius */
int XCTR=85;                     /* h-center */
int YCTR=140;                    /* v-center */
char color_sec[]="red";           /* seconds hand color */
char color_min[]="green3";        /* minutes hand color */
char color_hour[]="blue";         /* hours hand color */
char color_num[]="gray50";        /* mark color */
char color_cen[]="gold";         /* color of cover on center */
char color_bg[]="rgb:00/60/70";  /* background screen color */
XArc Numbers[12];                /* mark position */
int  iconw, iconh;               /* background screen size */
struct tm *tmval;
time_t current_time;
int interval = 100000;
enum {AUTO, MAN};
int zflag=AUTO;          /* auto adjust for horizontal position */       
int rflag=FALSE;         /* draw on root wondow */


Display *dpy;
Window root, fullscrn, win;
int scrn;
Pixmap pixmask;
GC gc, gc_sec, gc_shadow, gc_min, gc_hour, gc_cen;


typedef struct _XpmIcon {
    Pixmap pixmap;
    Pixmap mask;
    XpmAttributes attributes;
} XpmIcon;
XpmIcon icon;


unsigned long GetColor(char *color)
{
  Colormap cmap;
  XColor c0, c1;
  
  cmap = DefaultColormap(dpy, 0);
  XAllocNamedColor(dpy, cmap, color, &c1, &c0);
  return(c1.pixel);
}


void drawClock()
{
  int deg_sec, deg_min, deg_hour;

  current_time = time(NULL);
  tmval = localtime(&current_time);

  deg_sec = tmval->tm_sec*6.0;
  deg_min = tmval->tm_min*6.0;
  deg_hour = tmval->tm_hour*30.0 + deg_min/12.0;

  XFillArcs(dpy, win, gc, Numbers, 12);
  XDrawLine(dpy, win, gc_hour, XCTR, YCTR, 
            XCTR+(SIZE-8)*sin(PI*deg_hour/180.0), 
            YCTR-(SIZE-8)*cos(PI*deg_hour/180.0));
  XDrawLine(dpy, win, gc_min, XCTR, YCTR, 
            XCTR+(SIZE-2)*sin(PI*deg_min/180.0), 
            YCTR-(SIZE-2)*cos(PI*deg_min/180.0));
  XDrawLine(dpy, win, gc_sec, 
            XCTR-10*sin(PI*deg_sec/180.0), 
            YCTR+10*cos(PI*deg_sec/180.0), 
            XCTR+(SIZE+2)*sin(PI*deg_sec/180.0),  
            YCTR-(SIZE+2)*cos(PI*deg_sec/180.0));
  XFillArc(dpy, win, gc_cen, XCTR-2, YCTR-2, 4, 4, 0, 64*360);
  XDrawArc(dpy, win, gc_sec, XCTR-2, YCTR-2, 4, 4, 0, 64*360);
  XFlush(dpy);
}  

void usage()
{
  printf("Usage: pengwatch [OPTION]...\n\n");
  printf("      -i N      time interval: 100000\n");
  printf("      -x N      x-step: 4 \n");
  printf("      -y N      y-step: 3 \n");
  printf("      -s N      clock size: 32\n");
  printf("      -V N      vertical center of clock: 145\n");
  printf("      -H N      horizontal center of clock: auto adjust\n");
  printf("      -f FILE   xpm imagefile: /usr/include/X11/pixmaps/pengwatch.xpm \n");
  printf("      -b COLOR  backgound color: \"rgb:00/60/70\"\n");  
  printf("      -r        draw on rootwindow\n\n");
  exit(0);
}

void main(int argc, char **argv)
{
  XSetWindowAttributes attr;
  unsigned long attrmask;

  int x1, y1, dx1=3, dy1=2;
  int i, arc=1;
  int sh, sw;
  char *arv;

  while (arc < argc){
    arv = argv[arc];
    if (arv[0] == '-' ){
      switch (arv[1]) {  
      case 'i': interval=atoi(argv[arc+1]);
                break;
      case 'x': dx1=atoi(argv[arc+1]);
                break;
      case 'y': dy1=atoi(argv[arc+1]);
                break;
      case 's': SIZE=atoi(argv[arc+1]);
                break;
      case 'V': YCTR=atoi(argv[arc+1]);
                break;
      case 'H': XCTR=atoi(argv[arc+1]);
                zflag=MAN;
                break;
      case 'f': strcpy(pengfile,argv[arc+1]);
                break;
      case 'b': strcpy(color_bg,argv[arc+1]);
                break;
      case 'r': rflag=TRUE;
                break;
      case 'h': usage();
      default : break;
      }
    }
    arc++;
  }                  

  srand(time(NULL));

  dpy = XOpenDisplay("");
  scrn = DefaultScreen(dpy);
  root = RootWindow(dpy,scrn);

  sw = DisplayWidth(dpy,scrn);       
  sh = DisplayHeight(dpy,scrn);      
  x1 = sw/2 + rand()%(sw/4);         
  y1 = sh/2 + rand()%(sh/8) - sh/4;  

  attr.override_redirect = True;    
  attrmask = CWOverrideRedirect;    

  attrmask |= CWSaveUnder;          
  attr.save_under = True;           

  XpmReadFileToPixmap(dpy, root, pengfile, 
                         &icon.pixmap, &icon.mask, &icon.attributes);

  iconw = icon.attributes.width;
  if (zflag == AUTO) XCTR= iconw/2;
  iconh = icon.attributes.height;

  for (i = 0; i < 12; i++) { 
     Numbers[i].x = XCTR+SIZE*cos(PI*i/6.0)-2;
     Numbers[i].y = YCTR+SIZE*sin(PI*i/6.0)-2;
     Numbers[i].width = 4;         
     Numbers[i].height = 4;
     Numbers[i].angle1 = 0;
     Numbers[i].angle2 = 64*360;
  }

  if (rflag == FALSE) {
     fullscrn = XCreateWindow(dpy,root,0,0,sw,sh,0,0,
                        InputOutput, CopyFromParent, attrmask, &attr);
     XSetWindowBackground(dpy,fullscrn,GetColor(color_bg));
     XLowerWindow(dpy,fullscrn);
     XMapWindow(dpy,fullscrn);
  }

  win = XCreateWindow(dpy,root,x1,y1,iconw,iconh, 0, 0,
                       InputOutput, CopyFromParent, attrmask, &attr);

  gc = XCreateGC(dpy,win, 0, NULL);
  gc_sec = XCreateGC(dpy, win, 0, NULL);
  gc_min = XCreateGC(dpy, win, 0, NULL);
  gc_hour = XCreateGC(dpy, win, 0, NULL);
  gc_cen = XCreateGC(dpy, win, 0, NULL);
  gc_shadow = XCreateGC(dpy, win, 0, NULL);
  XSetForeground(dpy, gc, GetColor(color_num));
  XSetForeground(dpy, gc_sec, GetColor(color_sec));
  XSetForeground(dpy, gc_min, GetColor(color_min));
  XSetForeground(dpy, gc_hour, GetColor(color_hour));
  XSetForeground(dpy, gc_cen, GetColor(color_cen));
  XSetLineAttributes(dpy, gc_hour, 3, LineSolid, CapRound, JoinMiter);
  XSetLineAttributes(dpy, gc_min, 2, LineSolid, CapRound, JoinMiter);
  XSetForeground(dpy,gc,GetColor(color_num));

  XFlush(dpy);

  XShapeCombineMask(dpy, win, ShapeBounding, 0, 0, icon.mask, ShapeSet);
  XMapWindow(dpy,win);

  while(1){ 
    XCopyArea(dpy,icon.pixmap,win,gc,0,0,iconw,iconh,0,0);
    drawClock();
    XFlush(dpy);
    usleep(interval);
    x1 += dx1; if ( x1 < 0  || x1 > sw - iconw) dx1 *= -1;
    y1 += dy1; if ( y1 < 0  || y1 > sh - iconh) dy1 *= -1;
    XMoveWindow(dpy, win, x1, y1);
  }
} 
