/* Messages are #defined to be easy to change if needed, or support
 * other languages.
 * printf: begins with MSG_ (may be multiline; ends in a newline)
 * perror: begins with PERR_ (short, no ending as colon will follow)
 * string: begins with STR_ (ie. corresponds to a %s argument of a format)
 * arguments should be respected !!!
 * Debug messages are not here as they may vary a lot, it's easier
 * to have them in place.
 */
#ifndef _MESSAGES_H_
#define _MESSAGES_H_

#define MSG_HELP \
        "Options are parsed by getopt.\n"\
	"-c: clip drawings (not useful)\n"\
	"-d <p>: give diameter of animated area in pixels\n"\
	"-h: print this help message\n"\
	"-f: use all acceleration (why not)\n"\
	"-m: use shared memory. It is recommended to verify after exiting\n"\
	"    that shared memory was freed (see ipcs(1) and ipcrm(1))\n"\
	"-M: try forcing use of shared memory even if client and server\n"\
	"    dont seem to be on the same machine (incase they are however)\n"\
	/*"-o: optimize distortion\n"*/\
	"-p: rate of rotation (see source:) or try effect\n"\
        "-q: quit at first bounce on lower edge\n"\
	"-r: draw on root window (faster but may leave garbage)\n"\
	"-s: use shape extension\n"\
	"-u: use saveunder of the X server. This should eliminate blinking\n"\
	"-w <n>: n is an integer. If n is > 0 use this number of interlaced\n"\
	"    windows for the animation. Otherwise equivalent to -r\n"


#define MSG_NO_BITMAP "Bitmapped images / monochrome display not supported\n"
#define MSG_FORCE_SHM \
	"Not sure if should use shared memory\n"\
	"You may try forcing it with option -M\n"
#define PERR_NOT_SOCKET \
	"Not connected via socket to X server or couldn't get socket type"
#define MSG_CAUGHT_SIGNAL "Caught%s signal %i\n"
#define STR_SYNTHETIC "synthetic"
#define MSG_RM_SHM "You must remove shared memory by hand\n"
#define MSG_IS_SIG "Signal %s\n"
#define MSG_MAY_FREEZE \
	"Now trying to detach from X the shared memory segments\n"\
	"As this implies connecting to the server,\n"\
	"it is possible that the program hangs.\n"\
	"Kill it with kill -KILL in this case.\n"
#define MSG_FREED_SHM "Shared memory seems to be successfully freed\n"
#define MSG_X_ERROR "XError\n"
#define MSG_X_IO_ERROR "X IO Error\n"
#define MSG_X_ERR_CODE "Error code %s\n"
#define MSG_USAGE "Usage: -hscmurf -w <n> -d <n> -p<n>\n"
#define MSG_NO_SHAPE "Sorry, no shape extension on server\n"
#define MSG_NOT_SAME_AF "Client and server not in same adress family\n"
#define MSG_NOT_SAME_MACH \
	"Server (on %s) and client (on %s)"\
	"don't seem to run on same machine.\n"\
	"Impossible to use shared memory under these circumstances.\n"\
	"If however you know that this is not true,\n"\
	"try setting the DISPLAY environment variable\n"\
	"to something beginning with ':' (a colon), (eg `:0') or unset it.\n"
#define MSG_NO_SHM "Sorry, no shared memory extension on server\n"
#define PERR_CANT_FILL_SIGSET \
	"Could not fill signal set, so using shared memory would be unsafe"
#define PERR_CANT_GROW_SHMTAB \
	"Could not malloc shared memory information structure"
#define PERR_CANT_GET_SHM "Could not get shared memory"
#define PERR_CANT_ATTACH_SHM "Could not attach shared memory"
#define MSG_CANT_OPEN_DISPLAY "Unable to open display\n"
#define MSG_DIA_ROUNDUP "diameter rounded up to %i, for fast option\n"
#define MSG_NO_SAVEUNDER "Server does not saveunders\n"

#endif _MESSAGES_H_
