
/* Solaris options (/usr/openwin/lib may be replaced
 * by /usr/X11R6/lib both in -L and -R options)*/
/* gcc -L/usr/openwin/lib -R/usr/openwin/lib -lX11 -lXext -lm -lnsl -lsocket screenmuse.c -fforce-addr */

/* SunOS options */
/* gcc screenmuse.c -L/usr/X11R6/lib -lX11 -lXext /lib/libm.a -fforce-addr */

/* Linux options */
/* gcc screenmuse.c -L/usr/X11R6/lib -lX11 -lXext -lm -fforce-addr */

/* assembler output */
/* gcc -S screenmuse.c -fverbose-asm -dp -fforce-addr -O3 */

/* profiling options under SunOS */
/* Don't be upset, openwin's libX11 has a BUG */
/* gcc -I/usr/openwin/include/ screenmuse.c -static -L/usr/openwin/lib/ -lXext -lX11 -lm -fforce-addr -O2 -pg */

/* prfofiling options under Solaris */
/* gcc -I/usr/openwin/include/ xwhirl.c -Bstatic -L/usr/openwin/lib/ -R/usr/openwin/lib/ -lXext -lX11 -lsocket -lnsl -ldl -lm -fforce-addr -O2 -pg */
/* Query if server has extension. But when compiling see if client host has libXext ..*/
/* Verify that for fast option sizes are divisible ... for alignement and no gap */
/* Maybe take into consideration the bit and byte order of machines ...? */
/* A better form of distortion ? */
#include <errno.h> 
#include <malloc.h>
#include <math.h>
#include <netdb.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <values.h> /* BITSPERBYTE */

#include <sys/types.h> /* ptrdiff_t */
#include <sys/ipc.h> /* shm */
#include <sys/shm.h>
#include <sys/param.h> /* MAXHOSTNAMELEN */
#include <sys/socket.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xmd.h>  /* machine dependencies ... CARDx */

#include <X11/extensions/shape.h>
#include <X11/extensions/XShm.h>

#include "defaults.h"
#include "messages.h"

#define PSEUDO_XERROR -1
#define PSEUDO_XIOERROR -2
#define PSEUDO_ALLOCERROR -3
#define PSEUDO_EXIT -4

#define STRWLEN(s) s,strlen(s)
#define WERROR(s) write(2,STRWLEN(s))

void cleanup(int);

int BPP(int depth)
{
  int bpp;

  if (depth <= 4) /* supposedly more than 1 pixels per byte */
    {
      fprintf(stderr,MSG_NO_BITMAP);
      cleanup(PSEUDO_EXIT);
    }
  bpp = (depth - 1) / BITSPERBYTE + 1;
  if (bpp == 3) bpp = 4;
  return bpp;
}


void (*calib[5])(int len, int start, XImage *src, XImage *dest);

struct helco {
  int x;
  int y;
};
  


int opt_optdis=DEF_OPTDIS,
  opt_shape=DEF_SHAPE,
  opt_clip=DEF_CLIP,
  opt_shm=DEF_SHM,
  opt_force_shm=DEF_FORCE_SHM,
  opt_saveunder=DEF_SAVEUNDER,
  opt_onroot=DEF_ONROOT,
  opt_fast=DEF_FAST,
  opt_inwin=DEF_INWIN,
  opt_quit=DEF_QUIT;
int arg_interlace,
  arg_dia;
double arg_pow = DEFARG_POW;
int true_vx = 1,true_vy = 1;

int maxx,maxy;
struct {int x; int y;} **distab;
ptrdiff_t *optdistab;
struct shmlink {
  XShmSegmentInfo shminfo;
  struct shmlink *next;
} *shmlist,*curshmlink;
XShmSegmentInfo no_shminfo;


void
cleanup(int sig)
{
  Display *cdpy;
#define EMESGLEN 50
  char emesg[EMESGLEN+1];

  emesg[EMESGLEN] = 0;
#ifdef SNPRINTF
  snprintf(emesg,EMESGLEN,MSG_CAUGHT_SIGNAL:,sig<0?" " STR_SYNTHETIC:"",sig);
#else
  sprintf(emesg,MSG_CAUGHT_SIGNAL,sig<0?" "STR_SYNTHETIC:"",sig);
#endif /* SNPRINTF */
  WERROR(emesg);

  if ((sig == SIGSEGV) || (sig == SIGBUS))
    {
      (sig==SIGSEGV)?
	write(2,STRWLEN(MSG_IS_SIG "SIGSEGV")):
	write(2,STRWLEN(MSG_IS_SIG "SIGBUS"));
      write(2,STRWLEN(MSG_RM_SHM));
      exit(3);
    }

  for (curshmlink = shmlist; curshmlink != NULL; curshmlink = curshmlink->next)
    {
      if (curshmlink->shminfo.shmaddr != NULL)
	shmdt(curshmlink->shminfo.shmaddr);
      if (curshmlink->shminfo.shmid != -1)
	shmctl(curshmlink->shminfo.shmid,IPC_RMID,NULL);
    }

  /* Normally X releases shared memory upon interuption of connection */
  if (/*shmlist != NULL*/0)
    {
      write(2,STRWLEN(MSG_MAY_FREEZE));
      cdpy = XOpenDisplay(NULL);
      if (cdpy != NULL)
	{
	  for (curshmlink = shmlist;
	       curshmlink != NULL;
	       curshmlink = curshmlink->next)
	    if (curshmlink->shminfo.shmseg != 0)
	      XShmDetach(cdpy,&(curshmlink->shminfo));
	  XCloseDisplay(cdpy);
	}
    }

  write(2,MSG_FREED_SHM,45);
  /* Closing the display doesn't make sense, because the signal could
   * have interrupted a client-server communication, and it is not
   * possible to initiate a new request in the middle of an other */
  /*
      if ((XOpenDisplay(NULL) != NULL) && (sig != -1))
    {

    */
  if (sig == PSEUDO_ALLOCERROR) return;
  exit(4);
}

int
xErrorHandler(Display *dpy, XErrorEvent *err)
{
  char msg[80];

  fprintf(stderr,MSG_X_ERROR);
  XGetErrorText(dpy,err->error_code,msg,80);
  fprintf(stderr,MSG_X_ERR_CODE,msg);
  cleanup(PSEUDO_XERROR);
}

int
xIOErrorHandler(Display *dpy)
{
  fprintf(stderr,MSG_X_IO_ERROR);
  cleanup(PSEUDO_XIOERROR);
}

void
parseargs(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int c;

/* option o (optimized) can't exist anymore without fast (look at optdis) */
  while ((c = getopt(argc, argv, "cd:DfhmMop:qrsuw:")) != EOF)
    switch (c)
      {
      case 'c': opt_clip = 1; break;
      case 'd': arg_dia = atoi(optarg); break;
      case 'D': fprintf(stderr,DEFS_MSG,DEF_ALL); exit(0);
      case 'f': opt_fast = 1; opt_optdis = 1; break;
      case 'h': fprintf(stderr,MSG_HELP); exit(0);
      case 'm': opt_force_shm = 1; break;
      case 'M': opt_shm = 0; break;
      case 'o': opt_optdis = 1; break;
      case 'p': arg_pow = atof(optarg); break;
      case 'q': opt_quit = 1; break;
      case 'r': opt_onroot = 1; opt_inwin = 0; break;
      case 's': opt_shape = 1; break;
      case 'u': opt_saveunder = 1; break;
      case 'w': opt_inwin = 1; opt_onroot = 0;
	arg_interlace = atoi(optarg);
	if (arg_interlace == 0) opt_onroot = 1; break;
      case '?': fprintf(stderr,MSG_USAGE);
	exit(2); 
      }
}

Pixmap
shapeinit(Display *dpy, Window rtw, int dia, char *form)
{
  int major_opcode, first_event, first_error;
  Pixmap shape_mask;
  GC xgc;
  XGCValues gcvalues;

  if (!XQueryExtension(dpy,"SHAPE",&major_opcode,&first_event,&first_error))
    {
      opt_shape = 0;
      fprintf(stderr,MSG_NO_SHAPE);
      return (Pixmap) 0;
    }
  shape_mask = XCreatePixmap (dpy,rtw,dia,dia,1/*depth*/);
  xgc = XCreateGC(dpy,shape_mask,0,NULL);
  XFillRectangle(dpy,shape_mask,xgc,0,0,dia+1,dia+1);
  gcvalues.foreground = 1;
  XSetForeground(dpy,xgc,1);
  if (strcmp(form,"circ")==0)
    {
      XDrawArc(dpy,shape_mask,xgc,0,0,dia,dia,0,64*360);
      XFillArc(dpy,shape_mask,xgc,0,0,dia,dia,0,64*360);
    }
  else if (strcmp(form,"rect")==0)
    XFillRectangle(dpy,shape_mask,xgc,0,0,dia+1,dia+1);   
  XFreeGC(dpy,xgc);
  return shape_mask;
}

XShmSegmentInfo
shminit(Display *dpy, int size)
{
  int major_opcode, first_event, first_error;
  struct shmlink *tmpshmlink;
  sigset_t s_set,os_set;
  struct sigaction s_act;
  int sig;

  if ((shmlist == NULL) && !opt_force_shm)
    {

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif
      struct sockaddr sockname;
      int namelen = sizeof(sockname);
      char client [MAXHOSTNAMELEN+1];
      struct hostent *clh;
      char **host_addr;

      /* This is a very bad way to know if we can use shared memory
       * between client and server. Essentially tries to determine if
       * both are on the same machine. I don't see any way to do this.
       * There is a special problem with hostname adresses, which have
       * an unpecified format, depending on the address familiy;
       * even if the only adress family as yet supported is AF_INET
       * in most of the system/library calls, like gethostbyname().
       */
      errno = 0;
      if (0>getsockname(ConnectionNumber(dpy),&sockname,&namelen))
        {
	  perror(PERR_NOT_SOCKET);
	  fprintf(stderr,MSG_FORCE_SHM);
	  opt_shm = 0;
	  return no_shminfo;
	}
      if (sockname.sa_family != AF_UNIX)
	{
	  gethostname(client,MAXHOSTNAMELEN+1);
	  client[MAXHOSTNAMELEN] = 0;
	  clh = gethostbyname(client);
	  if (clh->h_addrtype != sockname.sa_family)
	    {
	      fprintf(stderr,MSG_NOT_SAME_AF MSG_FORCE_SHM);
	      opt_shm = 0;
	      return no_shminfo;
	    }
	  for (host_addr = clh->h_addr_list; *host_addr != NULL; host_addr++)
	    /* I think bcmp is a bad thing, no net to host conversion ... */
	    if (bcmp(*host_addr,sockname.sa_data,
		     MAX(sizeof(sockname.sa_data),clh->h_length))
		== 0) break;
	  if (*host_addr == NULL)
	    {
	      fprintf(stderr,MSG_NOT_SAME_MACH MSG_FORCE_SHM);
	      opt_shm = 0;
	      return no_shminfo;
	    }
	}
      /* This was the old version of determining if client and sever were
       * on same machine. It supposed: same machine = unix socket connection
       */
      /*
	if (*DisplayString(dpy) != 0 && *DisplayString(dpy) != ':')
	{
	  char *server, client[MAXHOSTNAMELEN+1];
	  char *pos;
	
	  server = strdup(DisplayString(dpy));
	  pos = strchr(server,':');
	  if (pos != NULL) *pos = 0;
	  gethostname(client,MAXHOSTNAMELEN+1);
	  opt_shm = 0;
	  fprintf(stderr,MSG_NOT_SAME_MACH,server,client);
	  free(server);
	  return no_shminfo;
	}
     */	
    }

  if (shmlist == NULL)
    {
      if (!XQueryExtension(dpy,"MIT-SHM",
			   &major_opcode,&first_event,&first_error))
	{
	  opt_shm = 0;
	  fprintf(stderr,MSG_NO_SHM);
	  return no_shminfo;
	}
      XSetErrorHandler(xErrorHandler); /* don't want XLib to call exit() */
      XSetIOErrorHandler(xIOErrorHandler);
      
      errno = 0;
      sigfillset((sigset_t *)(&s_set));
      sigdelset((sigset_t *)(&s_set),SIGKILL);
      sigdelset((sigset_t *)(&s_set),SIGSTOP);
      sigdelset((sigset_t *)(&s_set),SIGTSTP);
      sigdelset((sigset_t *)(&s_set),SIGCONT);
#ifdef SIGTRAP
      sigdelset((sigset_t *)(&s_set),SIGTRAP);
#endif SIGTRAP
      /* to permit correct tracing of sigblock() we have to enable SIGTRAP*/
#ifdef SIGPROF
      sigdelset((sigset_t *)(&s_set),SIGPROF);
#endif SIGPROF
      /* for profiling SIGPROF */

      if (errno != 0)
	{
	  perror(PERR_CANT_FILL_SIGSET);
	  opt_shm = 0;
	  return no_shminfo;
	}
      s_act.sa_handler = cleanup;
      s_act.sa_mask = s_set;
      s_act.sa_flags = SA_NOCLDSTOP;
      for (sig = 1; sigismember(&s_set,sig) != -1; sig++)
	if (sigismember(&s_set,sig) == 1)
	  sigaction(sig,&s_act,NULL);
      fprintf(stderr,"It seems the system defines %d signals\n",sig-1);
    }

  errno = 0;
  tmpshmlink = (struct shmlink *) calloc (1,sizeof (struct shmlink));
  if (tmpshmlink == NULL)
    {
      perror(PERR_CANT_GROW_SHMTAB);
      cleanup(PSEUDO_ALLOCERROR);
      opt_shm = 0;
      return no_shminfo;
    }
  tmpshmlink->shminfo.shmid = -1;
  if (shmlist == NULL) curshmlink = shmlist = tmpshmlink;
  else curshmlink = curshmlink->next = tmpshmlink;

  errno = 0;
  sigprocmask(SIG_BLOCK,&s_set,&os_set);
  curshmlink->shminfo.shmid = shmget(0,size,IPC_CREAT|00600);
  sigprocmask(SIG_SETMASK,&os_set,NULL);
  if (curshmlink->shminfo.shmid == -1)
    {
      perror(PERR_CANT_GET_SHM);
      cleanup(PSEUDO_ALLOCERROR);
      opt_shm = 0;
      return no_shminfo;
    }

  errno = 0;
  sigprocmask(SIG_BLOCK,&s_set,&os_set);
  curshmlink->shminfo.shmaddr = shmat(curshmlink->shminfo.shmid,NULL,0);
  sigprocmask(SIG_SETMASK,&os_set,NULL);
  if ((int)curshmlink->shminfo.shmaddr == -1)
    {
      perror(PERR_CANT_ATTACH_SHM);
      cleanup(PSEUDO_ALLOCERROR);
      opt_shm = 0;
      return no_shminfo;
    }
  curshmlink->shminfo.readOnly = False;
  return curshmlink->shminfo;
}

XImage *
shmimage(Display *dpy, XWindowAttributes *rtattr, int w, int h)
{
  XImage *xim;
  int bytes_per_pixel, bytes_per_line, imsize;

  bytes_per_pixel = BPP(rtattr->depth);
  bytes_per_line =
    ((w * bytes_per_pixel - 1) / BitmapPad(dpy) + 1) * BitmapPad(dpy);
  imsize = h * bytes_per_line;

  shminit(dpy,imsize + sizeof(XImage));
  if (!opt_shm) return (XImage *)0;
  XShmAttach(dpy,&(curshmlink->shminfo));
  xim = XShmCreateImage(dpy,rtattr->visual,rtattr->depth,ZPixmap,
			curshmlink->shminfo.shmaddr,
			&(curshmlink->shminfo),w,h);
  return xim;
}

int
heurad(int w,int h)
{
  return w/20;
}

/* move forsees the next step, and adjust vx and vy to make steps
 * allways inside the bounds of the screen. To initialize this feature
 * it is necessary to call first move with vx=vy=0 */
void
move(int *x, int *y, int *vx, int *vy)
{
  *x += *vx;
  *y += *vy;

  if (*x == 0)
    if (*vx < 0) *vx = true_vx;
  if (*x == maxx)
    if (*vx > 0) *vx = - true_vx;
  if (*y <= 0)
    if (*vy < 0) *vy = true_vy;
  if (*y >= maxy)
    if (*vy > 0) *vy = - true_vy;

  if (*x + *vx > maxx)
    *vx = maxx - *x;
  if (*x + *vx < 0)
    *vx = - *x;
  if (*y + *vy > maxy)
    *vy = maxy - *y;
  if (*y + *vy < 0)
    *vy = - *y;
}

void
deplace(XImage *xim, int vx,int vy, int dia)
{
  int i;
  int bytes_per_pixel;
  int decalage;
  
  bytes_per_pixel = BPP(xim->bits_per_pixel);
  decalage = - vy * xim->bytes_per_line - vx * bytes_per_pixel;
  for (i=(decalage>0?dia*xim->bytes_per_line:0)-decalage;
       decalage>0?i>=0:i<dia*xim->bytes_per_line;
       decalage>0?i--:i++)
    xim->data[i+decalage] = xim->data[i];
  /*
  for (i=(vx>0?vx:dia+vx); vx>0?i<dia:i>=0;vx>0?i++:i--)
    for (j=(vy>0?vy:dia+vy);vy>0?j<dia:j>=0;vy>0?j++:j--)
      for (k=0; k<bytes_per_pixel; k++)
	xim->data[(j-vy)*xim->bytes_per_line+(i-vx)*bytes_per_pixel+k] =
	  xim->data[j*xim->bytes_per_line+i*bytes_per_pixel+k];
  */
  /* XPutPixel(xim,i-vx,j-vy,XGetPixel(xim,i,j));*/
}

void
imagecopy(XImage *src, XImage *dest, int x, int y, int w, int h)
{
  int i,j;

  for (i=0; i<w; i++)
    for (j=0; j<h; j++)
      XPutPixel(dest,x+i,y+j,XGetPixel(src,i,j));
}

#ifndef DEBUG
extern inline
#endif DEBUG
struct helco
heladd(struct helco coord, int x, int y, int dia)
{
  coord.y = ((coord.x + x) / dia + coord.y + y) % dia;
  coord.x = (coord.x + x) % dia;
  if (coord.x < 0)
    {
      coord.x += dia;
      coord.y = (coord.y - 1) % dia; /* for neg values / is 1 to big */
    }
  if (coord.y < 0)
    coord.y += dia;

  return coord;
}

void
fastimagecopy(XImage *src, XImage *dest, struct helco pos, int w, int h)
{
  int i,j;
  int dia;
  struct helco ppos;

  dia = dest->width;
  for (i=0; i<w; i++)
    for (j=0; j<h; j++)
      {
	ppos = heladd(pos,i,j,dia);
	XPutPixel(dest,ppos.x,ppos.y,XGetPixel(src,i,j));
	XPutPixel(dest,ppos.x,ppos.y+dia,XGetPixel(src,i,j));
      }
}

void
mkdis(int dia)
{
  int i,j;
  float rad;
  float cx,cy;
  float rr;

  rad = dia / 2.0;
  distab = malloc (dia * sizeof(*distab));
  for (i=0; i<dia; i++)
    {
      distab[i] = malloc (dia * sizeof (**distab));
      for (j=0; j<dia; j++)
	{
	  cx = i - rad;
	  cy = j - rad;
	  rr = sqrt(cx * cx + cy * cy) / rad;
	  if ((rr >= 1)||(i == 0)||(i==dia-1)||(j==0)||(j==dia-1))/*(1)*/
	    {
	      distab[i][j].x = i;
	      distab[i][j].y = j;
	    }
	  else
	    {
	      distab[i][j].x =
		cos(M_PI * 2 * pow((1 - rr),arg_pow)) * cx +
		-sin(M_PI * 2 * pow((1 - rr),arg_pow)) * cy +
		rad;
	      distab[i][j].y =
		sin(M_PI * 2 * pow((1 - rr),arg_pow)) * cx +
		cos(M_PI * 2 * pow((1 - rr),arg_pow)) * cy +
		rad;
	    }
	}
    }
}

int
best_units(int bypp)
{
  if ((bypp < 1) || (bypp > 4)) return 1;
  if (bypp == 3) return 3;
  return 1;
}

/* As pixels are copied `en bloc', bit and byte order doesn't matter. */
void
optdis(int dia,XImage *xi)
{
  int i,j,k;
  unsigned long size;
  int bytes_per_pixel,units_per_pixel,units_per_line;

  if (xi->format != ZPixmap) exit(1);
  bytes_per_pixel = BPP(xi->bits_per_pixel);
  units_per_pixel = best_units(bytes_per_pixel);
  units_per_line = dia * units_per_pixel;
  size = dia * units_per_line;
  optdistab = (ptrdiff_t *) malloc (size * sizeof (ptrdiff_t));
  fprintf(stderr,"dia=%i\nsize=%li\nbytes_per_pixel=%i\nunits_per_pixel=%i\n",
	  dia,size,bytes_per_pixel,units_per_pixel);
  for (i=0; i<dia; i++)
    {
      for (j=0; j<dia; j++)
	for (k=0; k<units_per_pixel; k++)
	  optdistab[i*units_per_line+j*units_per_pixel+k] =
	    (ptrdiff_t) distab[j][i].y*units_per_line+
	                distab[j][i].x*units_per_pixel+k;
      for (j=dia*units_per_pixel; j<units_per_line; j++)
	optdistab[i*units_per_line+j] = (ptrdiff_t) 0;
    }
}

void
distort(int dia, XImage *src, XImage *dest)
{
  int i,j;

  for (i=0; i<dia; i++)
    for (j=0; j<dia; j++)
      XPutPixel(dest,i,j,XGetPixel(src,distab[i][j].x,distab[i][j].y));
}

/* Two end to end copies of the original are in src,
 * this to spare a modulo, but it's worth the effort,
 * the difference in speed is spectacular */
#define FASTDISTORT(type) \
void \
fastdistort_##type (int len, int start, XImage *src, XImage *dest) \
{ \
  type *end; \
  type *destd, *srcd; \
  ptrdiff_t *optd; \
 \
  srcd = (type *) src->data + start / sizeof(type); \
  end = (type *) dest->data + len / sizeof(type); \
  for (optd=optdistab,destd=(type *)dest->data; destd<end; optd++,destd++) \
    *destd = srcd[*optd]; \
}

FASTDISTORT(CARD32)
FASTDISTORT(CARD16)
FASTDISTORT(CARD8)

void
calibrate(void)
{
  calib[1] = fastdistort_CARD8;
  calib[2] = fastdistort_CARD16;
  calib[4] = fastdistort_CARD32;
  /*
  if (sizeof(char) == 1) calib[1] = fastdistort_char;

  if (sizeof(short) == 2) calib[2] = fastdistort_short;
  else if (sizeof(int) == 2) calib[2] = fastdistort_int;

  if (sizeof(short) == 4) calib[4] = fastdistort_short;
  else if (sizeof(int) == 4) calib[4] = fastdistort_int;
  else if (sizeof(long) == 4) calib[4] = fastdistort_long;
  */
}

void
optdistort(int len,XImage *src,XImage *dest)
{
  int i;

  for (i=0; i<len; i++)
    dest->data[i] = src->data[optdistab[i]];
}

void
main(int argc, char *argv[])
{
  int i;
  long scr;
  int W,H;
  Window rtw,sim[arg_interlace];
  Display *dpy;
  GC xgc;
  XSetWindowAttributes wat;
  XWindowAttributes rtattr;
  Pixmap bgpix,shape_mask;
  XImage *xitmp,*xi1,*xivert,*xihori;
  XShmSegmentInfo tmpshmi,xi1shmi;
  void (*fastdistort)(int len, int start, XImage *src, XImage *dest);

  int dia;
  int x,y,vx,vy;
  int act;
  int tmpsize;
  struct helco topleft;

  parseargs(argc,argv);

  dpy = XOpenDisplay(NULL);
  if (dpy == NULL)
    {
      fprintf(stderr,MSG_CANT_OPEN_DISPLAY);
      exit (1);
    }
  fprintf(stderr,"Your display:\n"
	  "Vendor: %s, Release %i, X version %i.%i\n",
	  ServerVendor(dpy),VendorRelease(dpy),
	  ProtocolVersion(dpy),ProtocolRevision(dpy));
#ifdef DEBUG
  XSynchronize(dpy,True);
#endif DEBUG
  scr = DefaultScreen(dpy);
  fprintf(stderr,"depth: %i, bitmap unit %i, bitmappad %i\n",
	  DefaultDepth(dpy,scr),BitmapUnit(dpy),BitmapPad(dpy));
  calibrate();
  rtw = RootWindow(dpy,scr);
  W   = DisplayWidth(dpy,scr);
  H   = DisplayHeight(dpy,scr);
  if (arg_dia > 1)
    dia = arg_dia;
  else
    dia = 2 * heurad(W,H);
  if (opt_fast)
    {
      int bytepad;

      bytepad = (BitmapPad(dpy) - 1) / BITSPERBYTE + 1;
      if (dia % bytepad != 0)
	{
	  dia = ((dia - 1) / bytepad + 1) * bytepad;
	  fprintf(stderr,MSG_DIA_ROUNDUP,dia);
	}
    }
  bgpix = XCreatePixmap(dpy,rtw,dia,dia,DefaultDepth(dpy,scr));
  xgc = XCreateGC(dpy,rtw,0,NULL);
  XSetForeground(dpy,xgc,BlackPixel(dpy,scr));
  XFillRectangle(dpy,bgpix,xgc,0,0,dia+1,dia+1);
  x = y = 0;
  XGetWindowAttributes(dpy,rtw,&rtattr);
  /* Get the whole xi1 from the root window can not work, because the
   * animation is already on it. We must gut only the few lines before
   * the wondow. */
  xi1 = XCreateImage(dpy,rtattr.visual,rtattr.depth,ZPixmap,0,
		     NULL,dia,dia,BitmapPad(dpy),0);
  if (opt_fast)
    {
      int bytes_per_pixel;

      bytes_per_pixel = BPP(xi1->depth);
      fastdistort = calib[bytes_per_pixel / best_units(bytes_per_pixel)];
      /*
      if (bytes_per_pixel < 0 || bytes_per_pixel > 4)
	fastdistort = fastdistort_char;
      else fastdistort = (calib[bytes_per_pixel]==NULL)?
	fastdistort_char:calib[bytes_per_pixel];
      */
    }
  tmpsize = (xi1->bytes_per_line) * dia * sizeof(char);
  if (opt_fast)
    {
      /* This is essential in the fast algo. We have to identical copies
       * end to end of the original image, which evitates a modulo when
       * calculating distorted positions by fastdistort */
      xi1->data = (char *) malloc (2 * tmpsize);
      XGetSubImage(dpy,rtw,x,y,dia,dia,AllPlanes,ZPixmap,xi1,0,0);
      XGetSubImage(dpy,rtw,x,y,dia,dia,AllPlanes,ZPixmap,xi1,0,dia);  
    }
  else
    {
      xi1->data = (char *) malloc (2 * tmpsize);
      XGetSubImage(dpy,rtw,x,y,dia,dia,AllPlanes,ZPixmap,xi1,0,0);
    }

  if (opt_shm)
    xitmp = shmimage(dpy,&rtattr,dia,dia);
  if (!opt_shm)
    {
      xitmp = XCreateImage(dpy,rtattr.visual,xi1->depth,ZPixmap,
			   xi1->xoffset,NULL,dia,dia,xi1->bitmap_pad,0);
      xitmp->data = (char *) malloc (tmpsize);
    }
  if (opt_shm)
    xivert = shmimage(dpy,&rtattr,abs(true_vx),dia);
  if (opt_shm)
    xihori = shmimage(dpy,&rtattr,dia,abs(true_vy));

  if (opt_inwin)
    {
      wat.override_redirect = True;
      wat.bit_gravity = StaticGravity;
      wat.save_under = opt_saveunder?True:False;
      if (!DoesSaveUnders(ScreenOfDisplay(dpy,scr)))
	{
	  opt_saveunder = 0;
	  fprintf(stderr,MSG_NO_SAVEUNDER);
	}
      for (i=0; i<arg_interlace; i++)
	{
	  sim[i] = XCreateSimpleWindow(dpy,rtw,0,0,dia,dia,0,0,
				       BlackPixel(dpy,scr));
	  XChangeWindowAttributes(dpy,sim[i],
				  CWOverrideRedirect|CWBitGravity|CWSaveUnder,
				  &wat);
	}
      if (opt_shape)
	shape_mask = shapeinit(dpy,rtw,dia,"circ");
      /* opt_shape may be set to 0 in shapeinit() */
      if (opt_shape)  
	{
	  for (i=0; i<arg_interlace; i++)
	    XShapeCombineMask(dpy,sim[i],ShapeBounding,0,0,shape_mask,ShapeSet);
	  XFreePixmap(dpy,shape_mask);
	}
      if (opt_clip)
	{
	  shape_mask = shapeinit(dpy,rtw,dia,"circ");
	  XSetClipMask(dpy,xgc,shape_mask);
	  XFreePixmap(dpy,shape_mask);  
	}
    }
  if (opt_onroot)
    XSetSubwindowMode(dpy,xgc,IncludeInferiors);

  maxx = W - dia - 1;
  maxy = H - dia - 1;
  vx = true_vx;
  vy = true_vy;
  x -= vx;
  y -= vy;
  move(&x,&y,&vx,&vy);
  if (opt_fast)
    {
      topleft.x = 0;
      topleft.y = 0;
    }
  act = 0;
  mkdis(dia);
  if (opt_optdis)
    optdis(dia,xitmp);
  /*_XInitImageFuncPtrs(xi1);*/

  while (opt_quit?y<maxy:1)
    {
      /* use XGetSubImage !!! in 3 parts: vert, hori, corner.
       * XPutImage readily manipulates subimages !!! */
      if (opt_shm)
	{
	  xivert->width = abs(vx);
	  xivert->height = dia;
	  XShmGetImage(dpy,rtw,xivert,x+(vx>0?dia:vx),y+vy,AllPlanes);
	  xihori->width = dia;
	  xihori->height = abs(vy);
	  XShmGetImage(dpy,rtw,xihori,x+vx,y+(vy>0?dia:vy),AllPlanes);
	}
      else
	{
	  xivert = XGetImage(dpy,rtw,x+(vx>0?dia:vx),y+vy,
			     abs(vx),dia,AllPlanes,ZPixmap);
      /*
      xihori = XGetImage(dpy,rtw,x+(vx>0?vx:0),y+(vy>0?dia:vy),
			 dia-abs(vx),abs(vy),AllPlanes,ZPixmap);
			 */
	  xihori = XGetImage(dpy,rtw,x+vx,y+(vy>0?dia:vy),
			     dia,abs(vy),AllPlanes,ZPixmap);
	}
      if (opt_fast)
	{
	  topleft = heladd(topleft,vx,vy,dia);
	  fastimagecopy(xivert,xi1,
			vx>0?heladd(topleft,dia-vx,0,dia):topleft,
			abs(vx),dia);
	  fastimagecopy(xihori,xi1,
			vy>0?heladd(topleft,0,dia-vy,dia):topleft,
			dia,abs(vy));
	}
      else
	{
	  deplace(xi1,vx,vy,dia);
	  imagecopy(xivert,xi1,vx>0?dia-vx:0,0,abs(vx),dia);
	  /*imagecopy(xihori,xi1,vx>0?0:-vx,vy>0?dia-vy:0,dia-abs(vx),abs(vy));*/
	  imagecopy(xihori,xi1,0,vy>0?dia-vy:0,dia,abs(vy));
	}
      if (!opt_shm)
	{
	  XDestroyImage(xivert);
	  XDestroyImage(xihori);
	}
      if (opt_onroot)
	{
	  XClearArea(dpy,rtw,x+(vx>0?0:dia+vx),y,abs(vx),dia,True);
	  XClearArea(dpy,rtw,x,y+(vy>0?0:dia+vy),dia,abs(vy),True);
	}
      move(&x,&y,&vx,&vy);
      if (opt_fast)
	fastdistort(dia*xi1->bytes_per_line,
		    topleft.y * xi1->bytes_per_line +
		    topleft.x * ((xi1->bits_per_pixel-1)/8+1),
		    xi1,xitmp);
      /*
      else if (opt_optdis)
	optdistort(dia*xi1->bytes_per_line,xi1,xitmp);
      */
      else
	distort(dia,xi1,xitmp);
      if (opt_onroot)
	if (opt_shm)
	  XShmPutImage(dpy,rtw,xgc,xitmp,0,0,x,y,dia,dia,False);
	else
	  XPutImage(dpy,rtw,xgc,xitmp,0,0,x,y,dia,dia);
      if (opt_inwin)
	{
	  if (opt_shm)
	    XShmPutImage(dpy,bgpix,xgc,xitmp,0,0,0,0,dia,dia,False);
	  else
	    XPutImage(dpy,bgpix,xgc,xitmp,0,0,0,0,dia,dia);
	  if (opt_clip)
	    XSetClipOrigin(dpy,xgc,x,y);
	  XSetWindowBackgroundPixmap(dpy,sim[act],bgpix);
	  XMoveWindow(dpy,sim[act],x,y);
	  XMapRaised(dpy,sim[act]);
	  XUnmapWindow(dpy,sim[(act+arg_interlace-1)%arg_interlace]);
	  act = ++act % arg_interlace ;
	}
    }
    cleanup(PSEUDO_EXIT);
}
