/*
 * LinPlasma 1.0
 *
 * Copyright (C) 1997 by Nick A. Rusnov <masked@peak.org>
 *
 *  This program is free software under the terms of the 
 *  GNU General Public License (see the file GPL, included with
 *  this software for complete license information)
 *
 */
   
char copyright_info[] = "LinPlasma 1.0\nCopyright (C) by Nick A. Rusnov <masked@peak.org>\n\nThis program is free software under the terms of the\nGNU General Public License (see the file GPL, included with\nthis software for complete license information)\n";

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

/* graphics libraries */
#include <vga.h>
#include <vgagl.h>
  
/* returns the radians suitable for use in the sin/cos function */
float rad(theta) float theta;{return (theta * PI) / 180.0;}

#define MYRAND_MAX (RAND_MAX + 1.0)

/* returns a scaled random value using random */ 
int myrand(maxrand) int maxrand;{return 1+(int)((float)maxrand*random()/(MYRAND_MAX));}
        
/* holds the cosine table */
unsigned char sintable[255], costable[255];

/* X and Y size of the viewport */
#define MAXX 320
#define MAXY 200

#define XSIZE (MAXX / 4)
#define YSIZE (MAXY / 4)

/* this holds the screen buffer */
unsigned char screenbuf[XSIZE*YSIZE];
unsigned char fullscreen[MAXX*MAXY];

/* this holds the palette */
unsigned char pal[6144],*palptr;

/* this holds the array positions for each of the pixels */
int lookup[MAXX*MAXY];

/* this generates the cosine table (the pretty pictures */
void gencostbl() 
{
  int foo;
  for (foo=0; foo < 255; foo++) 
    {
      /* do it */
      costable[foo]=rint(cos(5.0*PI*foo/255)*128)+128;
      sintable[foo]=rint(sin(5.0*PI*foo/255)*128)+128;
    } 
} 

/* Generate a palette 1024 entries long of various colour ranges (random) */
void genpal()
{
  int i,r,g,b,rb,gb,bb,rmax,gmax,bmax;

  r = myrand(63);
  g = myrand(63);
  b = myrand(63);
  
  rmax = myrand(50)+13;
  gmax = myrand(50)+13;
  bmax = myrand(50)+13;

  if (myrand(100) < 50)
    {
      rb = 1;
    }
  else
    {
      rb = 0;
    }
  if (myrand(100) < 50)
    {
      gb = 1;
    }
  else
    {
      gb = 0;
    }
  if (myrand(100) < 50)
    {
      bb = 1;
    }
  else
    {
      bb = 0;
    }

  i=0;
  while (i<1024)
    {
      pal[i] = r;
      pal[i+3072] = r;
      if (rb)
	{
	  r--;
	}
      else
	{
	  r++;
	}
      if (r <= 0)
	{
	  rb = 0;
	}
      if (r >= rmax)
	{
	  rb = 1;
	}
      i++;

      pal[i] = g;
      pal[i+3072] = g;
      if (gb)
	{
	  g--;
	}
      else
	{
	  g++;
	}
      if (g <= 0)
	{
	  gb = 0;
	}
      if (g >= gmax)
	{
	  gb = 1;
	}
      i++;

      pal[i] = b;
      pal[i+3072] = b;
      if (bb)
	{
	  b--;
	}
      else
	{
	  b++;
	}
      if (b <= 0)
	{
	  bb = 0;
	}
      if (b >= bmax)
	{
	  bb = 1;
	}
      i++;
    }

  /** 2 **/
  rmax = myrand(50)+13;
  gmax = myrand(50)+13;
  bmax = myrand(50)+13;

  while (i<2048)
    {
      pal[i] = r;
      pal[i+3072] = r;
      if (rb)
	{
	  r--;
	}
      else
	{
	  r++;
	}
      if (r <= 0)
	{
	  rb = 0;
	}
      if (r >= rmax)
	{
	  rb = 1;
	}
      i++;

      pal[i] = g;
      pal[i+3072] = g;
      if (gb)
	{
	  g--;
	}
      else
	{
	  g++;
	}
      if (g <= 0)
	{
	  gb = 0;
	}
      if (g >= gmax)
	{
	  gb = 1;
	}
      i++;

      pal[i] = b;
      pal[i+3072] = b;
      if (bb)
	{
	  b--;
	}
      else
	{
	  b++;
	}
      if (b <= 0)
	{
	  bb = 0;
	}
      if (b >= bmax)
	{
	  bb = 1;
	}
      i++;
    }

  /** 3 **/
  rmax = myrand(50)+13;
  gmax = myrand(50)+13;
  bmax = myrand(50)+13;

  while (i<3072)
    {
      pal[i] = r;
      pal[i+3072] = r;
      if (rb)
	{
	  r--;
	}
      else
	{
	  r++;
	}
      if (r <= 0)
	{
	  rb = 0;
	}
      if (r >= rmax)
	{
	  rb = 1;
	}
      i++;

      pal[i] = g;
      pal[i+3072] = g;
      if (gb)
	{
	  g--;
	}
      else
	{
	  g++;
	}
      if (g <= 0)
	{
	  gb = 0;
	}
      if (g >= gmax)
	{
	  gb = 1;
	}
      i++;

      pal[i] = b;
      pal[i+3072] = b;
      if (bb)
	{
	  b--;
	}
      else
	{
	  b++;
	}
      if (b <= 0)
	{
	  bb = 0;
	}
      if (b >= bmax)
	{
	  bb = 1;
	}
      i++;
    }


  (int)palptr = (int)&pal;

}


/* Cycle the colour palette using a pointer moving along the palette array */
void cycle_colour()
{  if (((int)palptr - (int)&pal) >= 3072)
    {
      (int)palptr = (int)&pal;
    }
  else
    {
      palptr+=3;
    }
  gl_setpalette(palptr); 
}
  

main () 
{
  unsigned char i1,j1,i,j,c,j1m,i1m,j1r,i1r,k1;
  
  int baz,quux,fish,shiz,frob,i2;

  printf("%s",copyright_info);
  
  /* seed the random number generator from the PID */
  srandom(getpid());

  genpal();
  gencostbl();
           

  i1=myrand(255);
  j1=myrand(255);

  /* Make lookup table */
  for (i = 0; i < YSIZE; i++) 
    {
      for (j = 0; j < XSIZE; j++) 
	{
	  baz = i*4;
	  quux = j*4;
	  fish = j+(i*XSIZE);
	  shiz = baz*MAXX;
	  lookup[quux+(shiz)] = fish;
	  lookup[(quux+1)+(shiz)] = fish;
	  lookup[(quux+2)+(shiz)] =fish;
	  lookup[(quux+3)+(shiz)] =fish;
	  shiz = (baz+1)*MAXX;
	  lookup[quux+(shiz)] = fish;
	  lookup[(quux+1)+(shiz)] = fish;
	  lookup[(quux+2)+(shiz)] =fish;
	  lookup[(quux+3)+(shiz)] = fish;
	  shiz = (baz+2)*MAXX;
	  lookup[quux+(shiz)] = fish;
	  lookup[(quux+1)+(shiz)] = fish;
	  lookup[(quux+2)+(shiz)] = fish;
	  lookup[(quux+3)+(shiz)] = fish;
	  shiz = (baz+3)*MAXX;
	  lookup[quux+(shiz)] = fish;
	  lookup[(quux+1)+(shiz)] = fish;
	  lookup[(quux+2)+(shiz)] = fish;
	  lookup[(quux+3)+(shiz)] = fish;
	}
    }

  /* Enter the MODE */
  /* Note that these can be changed to most anything you want, and will look 
     right if you update the defines above also (256 colour modes only,
     probably.) */
  vga_setmode(G320x200x256);
  gl_setcontextvga(G320x200x256);

  /* set the palette to the one held in the buffer */
  gl_setpalette(&pal); 

  /* put the screen buffer onto the screen */
  gl_putbox(0,0,XSIZE,YSIZE,&screenbuf);
  
  
  quux = (YSIZE*4)*MAXX;

  j1m = myrand(1024);
  i1m = myrand(1024);
  j1r = (myrand(100) > 50) ? 0 : 1;
  i1r = (myrand(100) > 50) ? 0 : 1;

  k1 = myrand(1024);

  while (!(vga_getkey()))
  {
    /* do this until user presses a key.. */
    if (i1r)
      {
	i1++;
      }
    else
      {
	i1--;
      }

    if (j1r)
      {
	j1++;
      }
    else
      {
	j1--;
      }
    
    if (j1 > j1m)
      {
	j1r = 0;
      }
    if (j1 < 1)
      {
	j1r = 1;
	j1m = myrand(1024);
      }

    if (i1 > i1m)
      {
	i1r = 0;
      }
    if (i1 < 1)
      {
	i1r = 1;
	i1m = myrand(1024);
      }

    if (sintable[i1m % 255] > costable[j1m % 255])
      {
	k1++;
      }
    else
      {
	k1--;
      }

    for (i=0; i < YSIZE; i++) 
      {
	frob = i*XSIZE;
	i2 = sintable[(i+i1) % 255];
	for (j=0; j < XSIZE; j++) 
	  {
	    c=costable[(j+j1) % 255] + i2 + sintable[(i1+j1+k1) % 255] + costable[(i+j+k1) % 255];
	    
	    screenbuf[j+(frob)]=c;
	  }
      }
    
    for (fish = 0; fish < quux; fish++) 
      {
	fullscreen[fish] = screenbuf[lookup[fish]];
      }

    gl_putbox(0,0,MAXX,MAXY,&fullscreen);
    cycle_colour();
    /*    sleep(5); */
  }
  
  puts("Bye!\n");
}






