#!/bin/sh
#
# ----------------------------------------------------------------------
#  IndexDir.sh
#
#  Copyright (C) 1998 Johan De Wit <jo@correct.nl>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# ----------------------------------------------------------------------
#
# Purpose of this scripts is to make index-jpegs with a maximuum of 20
# thumbnails per jpeg.  This requires the gtnpic binary.

TELLER=0  
ZERO=0
JPGLIST= 
SPACE=" " 
INDEXCOUNT=0  
INDEXNAME="_index.jpg" 

DIRLIST='ls *.jpg' 


for i in $DIRLIST 
do
   if [ $i != "ls" ] 
   then 
      TELLER=$((TELLER+1))
      JPGLIST=$JPGLIST$i$SPACE 
      if [ $TELLER -gt 19 ]  
      then
         if [ $INDEXCOUNT -lt 10 ] 
         then
            OUTPUT=$ZERO$INDEXCOUNT$INDEXNAME 
         else
            OUTPUT=$INDEXCOUNT$INDEXNAME 
         fi 

         gtnpic -bwhite -o$OUTPUT $JPGLIST
         INDEXCOUNT=$(( INDEXCOUNT+1 )) 
         JPGLIST=
         TELLER=0
      fi
   fi
done

# To be sure to get the last jpgs, we execute it again
# If there are filenames in JPGLIST

if [ -n $JPGLST]
then
   OUTPUT=$INDEXCOUNT$INDEXNAME
   gtnpic -bwhite -o$OUTPUT $JPGLIST
fi  
