#ifndef GTNPIC_H
#define GTNPIC_H

#define GTNPIC_VERSION "0.1.3"

#define PICS_ACROSS 5                       /* Number of thumbnails across */
#define TEXTHI 22                           /* Thumbnail text height       */
#define SCRNWIDE 128                        /* Thumbnail image width       */
#define SCRNHIGH 96                         /* Thumbnail image height      */

#define BLACK 0
#define GRAY 128
#define WHITE 255

unsigned char *outimage;                    /* The final index.jpg written */
unsigned char *palette;                     /* Global palette pointer      */
int width;                                  /* Original image width        */
int height;                                 /* Original image height       */
int background;                             /* Index's background color    */

enum {
/* Errors */
    NOERROR,
    ERROR,
/* Imagetypes */
    UNKNOWN,
    PNG,
    GIF,
    JPEG,
    BMP
};

struct imagetypes {
    long offset;
    char magic[25];
    int  type;
};

/* imagetype.c */
extern int get_imagetype(char *filename);

/* resizepic.c */
extern unsigned char *resizepic(unsigned char *thisimage, unsigned char *palr,
                                unsigned char *palg, unsigned char *palb,
                                int currwidth, int currheight,
                                int newwidth, int newheight);

/* readjpeg.c */
extern unsigned char *read_JPEG_file(char *filename, unsigned char **palette);

/* writejpeg.c  */
extern void write_JPEG_file(char *filename, int outwidth, int outheight,
                            int quality);

#endif /* GTNPIC_H */
