#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "gtnpic.h"

static struct imagetypes itypes[]= {
{0  ,"\x89PNG"  ,PNG  },
{0  ,"GIF8"     ,GIF  },
{6  ,"JFIF"     ,JPEG },
{0  ,"BM"       ,BMP  }
};

#define ITYPES (sizeof(itypes)/sizeof(itypes[0]))

/* Private */
static int check_header(struct imagetypes thistype, char *header);

int get_imagetype(char *filename)
{
	FILE *fp;
	int n, i, rc;
	char header[1024];

	memset(header, 0, sizeof (header));
	if( NULL == (fp=fopen(filename, "rb")) )
		return ERROR;
	n=fread(header, 1, 1023, fp);
	fclose(fp);
	if(n <= 0)
		return ERROR;
	for(i = 0; i < ITYPES; i++)
		{
		rc = check_header(itypes[i], header);
		if(UNKNOWN !=rc)
			return rc;
		}
return rc;
}

static int check_header(struct imagetypes thistype, char *header)
{
	char *p;
	char magic[25];
	int length;

	p=header;
	p=p+thistype.offset;
	sprintf(magic,"%s",thistype.magic);
	length=strlen(magic);

	if( strncmp(p,magic,length) )
		return UNKNOWN;

return thistype.type;
}
