#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "gtnpic.h"

unsigned char *resizepic(unsigned char *thisimage, unsigned char *palr,
                         unsigned char *palg, unsigned char *palb,
                         int currwidth, int currheight,
                         int newwidth, int newheight)
{
	register int a,b,x,yp,yw;
	long y,sw,sh,lastyp;
	int c,pixwide,pixhigh;
	int scaledown;
	unsigned char *rline;
	int tmp2,tr,tg,tb,tn;
	int xypos;

	if(NULL == (rline=calloc(1,newwidth*newheight*3)) )
		return NULL;

	switch(background)
		{
		case BLACK:
			for(x=0;x<(newwidth*newheight*3);x++)
				rline[x]=BLACK;
			break;
		case GRAY:
			for(x=0;x<(newwidth*newheight*3);x++)
				rline[x]=GRAY;
			break;
		case WHITE:
			for(x=0;x<(newwidth*newheight*3);x++)
				rline[x]=WHITE;
			break;
		default: /* Set default background to GRAY */
			for(x=0;x<(newwidth*newheight*3);x++)
				rline[x]=GRAY;
			break;
		}

	/* try landscapey */
	sw=newwidth;
	sh=(int)((newwidth*((long)currheight))/((long)currwidth));
	if(sh>newheight)
		/* no, oh well portraity then */
		{
		sh=newheight;
		sw=(int)((newheight*((long)currwidth))/((long)currheight));
		}

	/* so now our zoomed image will be sw x sh */
	scaledown=(currwidth>sw)?1:0; /* 1 if has been reduced, 0 if made bigger */

	/* it's been reduced - easy, just make 'em fit in less space */
	if(scaledown)
		{
		lastyp=-1;
		pixhigh=(int)(((float)currheight)/((float)sh)+0.5);
		pixwide=(int)(((float)currwidth)/((float)sw)+0.5);
		pixhigh++;
		pixwide++;
		for(y=0;y<currheight;y++)
			{
			yp=(y*sh)/currheight;
			if(yp!=lastyp)
				{
				yw=y*currwidth;
				/* we try to resample a bit. get that pentium RSN :) */
				for(x=0;x<currwidth;x++,yw++)
					{
					tr=tg=tb=tn=0;
					for(b=0;(b<pixhigh)&&(y+b<currheight);b++)
					for(a=0;(a<pixwide)&&(x+a<currwidth);a++)
						{
						tmp2=*(thisimage+yw+a+b*currwidth);
						tr+=palr[tmp2];
						tg+=palg[tmp2];
						tb+=palb[tmp2];
						tn++;
						}
					tr/=tn; tg/=tn; tb/=tn;
					xypos=3*(((x*sw)/currwidth)+yp*newwidth);
					rline[xypos]=tr;
					rline[xypos+1]=tg;
					rline[xypos+2]=tb;
					}
				lastyp=yp;
				}
			}
		}
	else
		/* we just leave it the same size */
		{
		for(y=0;y<currheight;y++)
		for(x=0;x<currwidth;x++)
			{
			c=thisimage[y*currwidth+x];
			rline[3*(y*newwidth+x)  ]=palr[c];
			rline[3*(y*newwidth+x)+1]=palg[c];
			rline[3*(y*newwidth+x)+2]=palb[c];
			}
		}
  
return rline;
}
