#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <jpeglib.h>
#include "gtnpic.h"

void write_JPEG_file(char *filename, int outwidth, int outheight, int quality)
{
	struct jpeg_compress_struct cinfo;
	struct jpeg_error_mgr jerr;
	FILE *out;
	JSAMPROW row_pointer[1];
	int row_stride;

	cinfo.err = jpeg_std_error(&jerr);
	jpeg_create_compress(&cinfo);

	if((out=fopen(filename,"wb"))==NULL)
		{
		fprintf(stderr,"can't open %s\n",filename);
		exit(1);
		}
	jpeg_stdio_dest(&cinfo,out);

	cinfo.image_width = outwidth;
	cinfo.image_height = outheight;
	cinfo.input_components = 3;
	cinfo.in_color_space = JCS_RGB;
	jpeg_set_defaults(&cinfo);
	jpeg_set_quality(&cinfo,quality,FALSE);

	jpeg_start_compress(&cinfo,TRUE);

	row_stride=outwidth*3;

	while (cinfo.next_scanline < cinfo.image_height)
		{
		row_pointer[0]=&outimage[cinfo.next_scanline*row_stride];
		jpeg_write_scanlines(&cinfo,row_pointer,1);
		}

	jpeg_finish_compress(&cinfo);
	fclose(out);
	jpeg_destroy_compress(&cinfo);
}
