/*
    pmosc - recreates an image out of smaller image tiles
    Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<limits.h>
#include"pmosc.h"
#include"misc.h"

#define INFO \
"pmosc 0.1 Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>\n" \
"usage: pmosc -o output -i input -x nx -y ny -w width -h height file...\n" \
"    -o output           write the final output image to the file output\n" \
"    -i input            read the big image from the file input\n" \
"    -x nx -y ny         make the final image be composed of nx x ny tiles\n" \
"    -w width -h height  make each tile in the final image\n" \
"                        be width x height pixels in size\n" \
"    file...             everything else passed on the command line\n" \
"                        will be treated as file names of tiles\n"

#define NOTSPEC(s)	{fprintf(stderr,s " not specified\n");info();return 1;}
#define OVERUSE(s)	{fprintf(stderr,s " used more than once\n"); \
							info();return 1;}
#define WITHOUT(o,p)	{fprintf(stderr,o " used without " p "\n"); \
							info();return 1;}
#define INVALID(s)	{fprintf(stderr,"invalid value for " s "\n"); \
							info();return 1;}

static void info(void)
{
	fprintf(stderr,INFO);
}

int main(int argc,char *argv[])
{
	char *output=NULL,*input=NULL;
	unsigned long nx=0,ny=0,width=0,height=0;
	char **file=NULL;
	int count=1,i;

	if(argc == 1)
	{
		info();
		return 0;
	}

	for(i=1;i<argc;i++)
	{
		if(!strcmp(argv[i],"-o"))
		{
			if(output) OVERUSE("-o");
			output = argv[++i];
			if(!output) WITHOUT("-o","output");
		}
		else if(!strcmp(argv[i],"-i"))
		{
			if(input) OVERUSE("-i");
			input = argv[++i];
			if(!output) WITHOUT("-i","input");
		}
		else if(!strcmp(argv[i],"-x"))
		{
			if(nx) OVERUSE("-x");
			if(!argv[++i]) WITHOUT("-x","nx");
			nx = strtoul(argv[i],NULL,0);
			if(!nx || (nx == ULONG_MAX)) INVALID("nx");
		}
		else if(!strcmp(argv[i],"-y"))
		{
			if(ny) OVERUSE("-y");
			if(!argv[++i]) WITHOUT("-y","ny");
			ny = strtoul(argv[i],NULL,0);
			if(!ny || (ny == ULONG_MAX)) INVALID("ny");
		}
		else if(!strcmp(argv[i],"-w"))
		{
			if(width) OVERUSE("-w");
			if(!argv[++i]) WITHOUT("-w","width");
			width = strtoul(argv[i],NULL,0);
			if(!width || (width == ULONG_MAX)) INVALID("width");
		}
		else if(!strcmp(argv[i],"-h"))
		{
			if(height) OVERUSE("-h");
			if(!argv[++i]) WITHOUT("-h","height");
			height = strtoul(argv[i],NULL,0);
			if(!height || (height == ULONG_MAX)) INVALID("height");
		}
		else
		{
			file = xrealloc(file,++count * sizeof(char*));
			file[count - 2] = argv[i];
			file[count - 1] = NULL;
		}
	}

	if(!output) NOTSPEC("output");
	if(!input) NOTSPEC("input");
	if(!nx) NOTSPEC("nx");
	if(!ny) NOTSPEC("ny");
	if(!width) NOTSPEC("width");
	if(!height) NOTSPEC("height");
	if(!file) NOTSPEC("file...");

	return pmosc(output,input,nx,ny,width,height,file);
}

