#!/bin/sh
#
# pnminterp-gen - a shell script which acts a little like a general
# 	form of pnminterp, by scaling up with pnminterp then scaling
# 	down with pnmscale.
#
# it also copes with N<1, but then it just uses pnmscale. :-)

if [ "$1" = "" ]; then
  echo 'usage: pnminterp-gen N [pnmfile]'
  exit 1
fi

tempfile=/tmp/pnmig$$
trap 'rm -f $tempfile' 0 1 3 15

if ! cat $2 >$tempfile 2>/dev/null; then
  echo 'pnminterp-gen: error reading file' 1>&2
  exit 1
fi

# we use the width as indication of how much to scale; width and
# height are being scaled equally, so this should be ok.
width=`pnmfile $tempfile 2>/dev/null|cut -d " " -f 3`

if [ "$width" = "" ]; then
  echo 'pnminterp-gen: not a PNM file' 1>&2
  exit 1
fi

# should really use dc for maths, but awk is less painful :-)
target_width=`awk 'BEGIN{printf("%d",'0.5+"$width"*"$1"')}'`

# work out how far we have to scale it up with pnminterp so that the
# new width is >= the target width.
int_scale=`awk '
BEGIN {
int_scale=1;int_width='"$width"'
while(int_width<'"$target_width"')
  {
  int_scale++
  int_width+='"$width"'
  }
print int_scale
}'`

if [ "$int_scale" -eq 1 ]; then
  pnmscale "$1" $tempfile
else
  pnminterp "$int_scale" $tempfile | pnmscale -xsi "$target_width"
fi
