/*GPL*START*
 * 
 * Copyright (C) 1998 by Johannes Overmann <overmann@iname.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * *GPL*END*/  

#ifndef _qi6refwid_h_
#define _qi6refwid_h_

#include <qwidget.h>
#include <qcolor.h>
#include <qpaintd.h>
#include <qrect.h>
#include "tarray.h"




class FractWid: public QWidget {
  
   Q_OBJECT;
  
 public:
   // cons & des;
   FractWid(QWidget *parent=0, bool julia = false);
   ~FractWid();
      
 public slots:
   void setJuliaCoords(double x, double y);
   void setPosRotZoom(double center_x, double center_y, double rotate, double zoom);
   void forcePosRotZoomChanged();
   void setCrosshairs(bool on);
   void setMaxIter(int max);
   void setGuessing(bool on);
   void setGuessDebug(bool on);
   void setAltColors(bool on);
   void setAsm(bool on);

   signals: 
   void centerChanged(double x, double y);
   void posRotZoomChanged(double center_x, double center_y, double rotate, double zoom);
   void midButtonPressed(QPoint p);

 protected:
   // qt events
   void paintEvent(QPaintEvent *);
   void resizeEvent(QResizeEvent *p);
   void mousePressEvent(QMouseEvent *e);
   void mouseReleaseEvent(QMouseEvent *e);
   void mouseMoveEvent(QMouseEvent *e);
   void mousemove(int dx, int dy);
   
 private slots:
   void calc_next_phase();
   
 private:
   // private methods
   double argphi(int cx, int cy, int x, int y) const;
   double radius(int cx, int cy, int x, int y) const;
   void init_calc(QRect r);
   void full_update();
   void calc_phase();
   void updateRotate();
   const QColor& iter2col(int iter);
   void drawCross(QPaintDevice *pd, int x, int y);
   double calc_simple(int phase, int phaselen, int maxiter, 
		      QRect r, QPaintDevice *pd,
		      double c_x, double c_y, 
		      double dxx, double dxy, double dyx, double dyy,
		      bool julia, double julia_x, double julia_y);
   double calc_init_grid(int phase, int maxiter, 
			 QRect r, QPaintDevice *pd,
			 double c_x, double c_y, 
			 double dxx, double dxy, double dyx, double dyy,
			 bool julia, double julia_x, double julia_y);
   double calc_next_grid(int phase, int maxiter, 
			 QRect r, QPaintDevice *pd,
			 double c_x, double c_y, 
			 double dxx, double dxy, double dyx, double dyy,
			 bool julia, double julia_x, double julia_y);
   int& info(int x, int y) {return inf[infoff + x + infwidth*y];}
   void calc_sync_all_phases(QRect r);
      
   // private data
   bool isdirty;
   QPixmap *pix;
   QPaintDevice *drawable;
   int phase;
   int simple_interlace;
   QColor *col;
   QColor lake_col;
   QColor guess_col;
   int numcol;
   QRect cur_rect, aux_rect;
   int from_x, from_y;
   enum MOUSE_MODE {NONE, DRAG, ROTATE} mousemode;
   
   // fract data
   double center_x, center_y;
   double zoom, rotate;
   double rot_dxx, rot_dxy, rot_dyx, rot_dyy;
   double julia_x,  julia_y;
   bool julia;
   bool cross;
   int maxiter;
   bool guessing;
   bool guessdeb;
   bool altcol;
   int guess_width;
   int inflen;
   int infwidth;
   int infheight;
   int *inf;
   int infoff;
   bool fastasm;
};

#endif




