/*GPL*START*
 * 
 * Copyright (C) 1998 by Johannes Overmann <overmann@iname.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * *GPL*END*/  

#ifndef _mainwidget_h_
#define _mainwidget_h_


#include <qwidget.h>
#include <qmenubar.h>
#include <qframe.h>
#include <qlistbox.h>
#include <qcombo.h>
#include <qchkbox.h>
#include <qstring.h>
#include <qfiledlg.h>
#include <qlined.h>
#include <qvalidator.h>
#include <qlayout.h>

#include "fractwid.h"

class MainWidget: public QWidget {
  
  Q_OBJECT;
  
public:
  // cons & des;
  MainWidget(QWidget *parent=0);
  ~MainWidget();
  

public slots:
  void aboutQt();
  void about();
  void info();

   void tog_julia();
   void hide_julia(QPoint);
   void tog_follow();
   void perhaps_jul_to_mand(double center_x, double center_y, double rotate, double zoom);
   void perhaps_mand_to_jul(double center_x, double center_y, double rotate, double zoom);
   void tog_cross();
   void tog_guess();
   void tog_guessdeb();
   void tog_asm();
   void tog_altcol();
   void set_iter(int);
   void updateCenterStatus(double x, double y);

signals:
  

protected:


private slots:



private:
  // private methods


   // private data
   QMenuBar *menu;
   QPopupMenu *view;
   QPopupMenu *iter;
   QLabel *stat;
   FractWid *mand;
   FractWid *jul;
   bool follow;
   bool oldjulposvalid;
   
   int juliaId, followId, crossId, guessId, guessdebId, altcolId, asmId;
   QRect oldjulpos;
   
};




#endif
